/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.exporting;

import com.google.common.collect.ImmutableList;
import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Tile;

public class HeightMapExporter {
    private final Dimension dimension;
    private final Format format;
    private final int minHeight;
    private final int intHighestHeight;
    private final int bitsRequired;
    private final float floatLowestHeight;
    private final float floatHighestHeight;
    private String formatDescription;

    public HeightMapExporter(Dimension dimension, Format format) {
        this.dimension = dimension;
        this.format = format;
        this.minHeight = dimension.getMinHeight();
        switch (format) {
            case INTEGER_HIGH_RESOLUTION: {
                this.intHighestHeight = dimension.getHighestIntHeight();
                this.bitsRequired = (int)Math.ceil(Math.log((this.intHighestHeight - this.minHeight + 1 << 8) - 1) / Math.log(2.0));
                this.floatHighestHeight = -3.4028235E38f;
                this.floatLowestHeight = -3.4028235E38f;
                break;
            }
            case INTEGER_LOW_RESOLUTION: {
                this.intHighestHeight = dimension.getHighestIntHeight();
                this.bitsRequired = (int)Math.ceil(Math.log(this.intHighestHeight - this.minHeight) / Math.log(2.0));
                this.floatHighestHeight = -3.4028235E38f;
                this.floatLowestHeight = -3.4028235E38f;
                break;
            }
            case FLOAT_NORMALISED: 
            case FLOAT_ONE_TO_ONE: {
                float[] range = dimension.getHeightRange();
                this.floatLowestHeight = range[0];
                this.floatHighestHeight = range[1];
                this.bitsRequired = 32;
                this.intHighestHeight = Integer.MIN_VALUE;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    public List<String> getSupportedFileExtensions() {
        if (this.bitsRequired <= 16) {
            return ImmutableList.of((Object)"png", (Object)"tiff");
        }
        return Collections.singletonList("tiff");
    }

    public String getDefaultFilename() {
        String defaultExtension = this.getSupportedFileExtensions().get(0);
        StringBuilder sb = new StringBuilder();
        sb.append(this.dimension.getWorld().getName().replaceAll("\\s", "").toLowerCase());
        if (this.dimension.getAnchor().dim != 0) {
            sb.append('_');
            sb.append(this.dimension.getName().replaceAll("\\s", "").toLowerCase());
        }
        switch (this.format) {
            case FLOAT_NORMALISED: {
                sb.append("_normalised-");
                break;
            }
            case INTEGER_HIGH_RESOLUTION: {
                sb.append("_high-res-");
                break;
            }
            default: {
                sb.append('_');
            }
        }
        sb.append("heightmap.");
        sb.append(defaultExtension);
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exportToFile(File file) {
        String type = file.getName().substring(file.getName().lastIndexOf(46) + 1).toUpperCase();
        try {
            float scale;
            float offset;
            double dimensionMax;
            double formatMax;
            ImageWriteParam params;
            ImageWriter writer;
            BufferedImage image;
            switch (this.format) {
                case INTEGER_HIGH_RESOLUTION: 
                case INTEGER_LOW_RESOLUTION: {
                    Iterator<Object> writers;
                    ImageTypeSpecifier imageTypeSpecifier;
                    if (this.bitsRequired > 16) {
                        imageTypeSpecifier = ImageTypeSpecifiers.createGrayscale((int)32, (int)3);
                        image = imageTypeSpecifier.createBufferedImage(this.dimension.getWidth() * 128, this.dimension.getHeight() * 128);
                        writers = ImageIO.getImageWriters(imageTypeSpecifier, type);
                        if (!writers.hasNext()) return false;
                        writer = writers.next();
                        params = writer.getDefaultWriteParam();
                        params.setCompressionMode(2);
                        params.setCompressionType("LZW");
                        params.setCompressionQuality(0.0f);
                        this.formatDescription = "in 32-bit unsigned integer grayscale compressed " + type + " format.";
                        formatMax = Math.pow(2.0, 32.0);
                        dimensionMax = this.format == Format.INTEGER_LOW_RESOLUTION ? (double)(this.intHighestHeight - this.minHeight) : (double)(this.intHighestHeight - this.minHeight << 8);
                    } else {
                        image = new BufferedImage(this.dimension.getWidth() * 128, this.dimension.getHeight() * 128, this.bitsRequired <= 8 ? 10 : 11);
                        Iterator<ImageWriter> writers2 = ImageIO.getImageWriters(ImageTypeSpecifier.createFromRenderedImage(image), type);
                        if (!writers2.hasNext()) return false;
                        writer = writers2.next();
                        params = writer.getDefaultWriteParam();
                        this.formatDescription = (this.bitsRequired <= 8 ? "in 8-bit" : "in 16-bit") + " unsigned integer grayscale " + type + " format.";
                        formatMax = Math.pow(2.0, this.bitsRequired <= 8 ? 8.0 : 16.0);
                        dimensionMax = this.format == Format.INTEGER_LOW_RESOLUTION ? (double)(this.intHighestHeight - this.minHeight) : (double)(this.intHighestHeight - this.minHeight << 8);
                    }
                    offset = -3.4028235E38f;
                    scale = -3.4028235E38f;
                    break;
                }
                case FLOAT_NORMALISED: 
                case FLOAT_ONE_TO_ONE: {
                    ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifiers.createGrayscale((int)32, (int)4);
                    image = imageTypeSpecifier.createBufferedImage(this.dimension.getWidth() * 128, this.dimension.getHeight() * 128);
                    Iterator<Object> writers = ImageIO.getImageWriters(imageTypeSpecifier, type);
                    if (!writers.hasNext()) return false;
                    writer = writers.next();
                    params = writer.getDefaultWriteParam();
                    params.setCompressionMode(2);
                    params.setCompressionType("LZW");
                    params.setCompressionQuality(0.0f);
                    this.formatDescription = "in " + (this.format == Format.FLOAT_NORMALISED ? "normalised " : "") + " floating point grayscale compressed " + type + " format.";
                    scale = this.floatHighestHeight - this.floatLowestHeight;
                    offset = this.floatLowestHeight;
                    formatMax = this.format == Format.FLOAT_NORMALISED ? 1.0 : (double)this.floatHighestHeight;
                    dimensionMax = this.format == Format.FLOAT_NORMALISED ? 1.0 : (double)this.floatHighestHeight;
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
            if (dimensionMax / formatMax < 0.2) {
                this.formatDescription = this.formatDescription + "\n\nPLEASE NOTE: this height map will appear very dark when displayed as\nan image, because the exported values are very small compared to the\ntheoretical range of the image format.";
            }
            WritableRaster raster = image.getRaster();
            block21: for (Tile tile : this.dimension.getTiles()) {
                int tileOffsetX = (tile.getX() - this.dimension.getLowestX()) * 128;
                int tileOffsetY = (tile.getY() - this.dimension.getLowestY()) * 128;
                switch (this.format) {
                    case INTEGER_HIGH_RESOLUTION: {
                        int dy;
                        int dx;
                        for (dx = 0; dx < 128; ++dx) {
                            for (dy = 0; dy < 128; ++dy) {
                                raster.setSample(tileOffsetX + dx, tileOffsetY + dy, 0, tile.getRawHeight(dx, dy));
                            }
                        }
                        continue block21;
                    }
                    case INTEGER_LOW_RESOLUTION: {
                        int dy;
                        int dx;
                        for (dx = 0; dx < 128; ++dx) {
                            for (dy = 0; dy < 128; ++dy) {
                                raster.setSample(tileOffsetX + dx, tileOffsetY + dy, 0, tile.getIntHeight(dx, dy) - this.minHeight);
                            }
                        }
                        continue block21;
                    }
                    case FLOAT_ONE_TO_ONE: {
                        int dy;
                        int dx;
                        for (dx = 0; dx < 128; ++dx) {
                            for (dy = 0; dy < 128; ++dy) {
                                raster.setSample(tileOffsetX + dx, tileOffsetY + dy, 0, tile.getHeight(dx, dy));
                            }
                        }
                        continue block21;
                    }
                    case FLOAT_NORMALISED: {
                        int dy;
                        int dx;
                        for (dx = 0; dx < 128; ++dx) {
                            for (dy = 0; dy < 128; ++dy) {
                                raster.setSample(tileOffsetX + dx, tileOffsetY + dy, 0, (tile.getHeight(dx, dy) - offset) / scale);
                            }
                        }
                        break;
                    }
                }
            }
            Throwable throwable = null;
            try (ImageOutputStream out = ImageIO.createImageOutputStream(file);){
                writer.setOutput(out);
                writer.write(null, new IIOImage(image, null, null), params);
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error while exporting image", e);
        }
    }

    public String getFormatDescription() {
        return this.formatDescription;
    }

    public static enum Format {
        INTEGER_LOW_RESOLUTION,
        INTEGER_HIGH_RESOLUTION,
        FLOAT_NORMALISED,
        FLOAT_ONE_TO_ONE;

    }
}

