/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.exporting;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.pepsoft.util.MathUtils;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.RODelegatingDimension;
import org.pepsoft.worldpainter.ReadOnlyTile;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.layers.FloodWithLava;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.NotPresent;
import org.pepsoft.worldpainter.layers.ReadOnly;

public class FlatteningDimension
extends RODelegatingDimension<FlatteningTile> {
    private final Dimension[] dimensions;
    private final Set<Point> tileCoords = new HashSet<Point>();
    private final int lowestX;
    private final int highestX;
    private final int lowestY;
    private final int highestY;
    private final Rectangle extent;
    private final int minHeight;
    private final int maxHeight;
    private Set<Terrain> allTerrains;
    private Set<Layer> allLayers;
    private Set<Layer> allLayersCombinedApplied;

    public FlatteningDimension(Dimension ... dimensions) {
        super(dimensions[0]);
        this.dimensions = (Dimension[])dimensions.clone();
        int lowestX = Integer.MAX_VALUE;
        int highestX = Integer.MIN_VALUE;
        int lowestY = Integer.MAX_VALUE;
        int highestY = Integer.MIN_VALUE;
        Rectangle extent = dimensions[0].getExtent();
        for (Dimension dimension : dimensions) {
            this.tileCoords.addAll(dimension.getTileCoords());
            if (dimension.getLowestX() < lowestX) {
                lowestX = dimension.getLowestX();
            }
            if (dimension.getHighestX() > highestX) {
                highestX = dimension.getHighestX();
            }
            if (dimension.getLowestY() < lowestY) {
                lowestY = dimension.getLowestY();
            }
            if (dimension.getHighestY() > highestY) {
                highestY = dimension.getHighestY();
            }
            if (extent == null) continue;
            Rectangle dimExtent = dimension.getExtent();
            extent = dimExtent != null ? extent.union(dimExtent) : null;
        }
        this.lowestX = lowestX;
        this.highestX = highestX;
        this.lowestY = lowestY;
        this.highestY = highestY;
        this.extent = extent;
        this.minHeight = dimensions[0].getMinHeight();
        this.maxHeight = dimensions[0].getMaxHeight();
    }

    @Override
    public int getTileCount() {
        return this.tileCoords.size();
    }

    @Override
    public int getIntHeightAt(int x, int y, int defaultValue) {
        Object tile = this.getTile(x >> 7, y >> 7);
        return tile != null ? ((Tile)tile).getIntHeight(x & 0x7F, y & 0x7F) : defaultValue;
    }

    @Override
    public float getHeightAt(int x, int y) {
        Object tile = this.getTile(x >> 7, y >> 7);
        return tile != null ? ((Tile)tile).getHeight(x & 0x7F, y & 0x7F) : Float.MIN_VALUE;
    }

    @Override
    public int getRawHeightAt(int x, int y) {
        Object tile = this.getTile(x >> 7, y >> 7);
        return tile != null ? ((Tile)tile).getRawHeight(x & 0x7F, y & 0x7F) : Integer.MIN_VALUE;
    }

    @Override
    public Set<Terrain> getAllTerrains() {
        if (this.allTerrains == null) {
            this.allTerrains = new HashSet<Terrain>();
            for (Dimension dimension : this.dimensions) {
                this.allTerrains.addAll(dimension.getAllTerrains());
            }
        }
        return this.allTerrains;
    }

    @Override
    public int getWaterLevelAt(int x, int y) {
        Object tile = this.getTile(x >> 7, y >> 7);
        return tile != null ? ((Tile)tile).getWaterLevel(x & 0x7F, y & 0x7F) : Integer.MIN_VALUE;
    }

    @Override
    public int getLayerValueAt(Layer layer, int x, int y) {
        Object tile = this.getTile(x >> 7, y >> 7);
        return tile != null ? ((Tile)tile).getLayerValue(layer, x & 0x7F, y & 0x7F) : layer.getDefaultValue();
    }

    @Override
    public boolean getBitLayerValueAt(Layer layer, int x, int y) {
        Object tile = this.getTile(x >> 7, y >> 7);
        return tile != null && ((Tile)tile).getBitLayerValue(layer, x & 0x7F, y & 0x7F);
    }

    @Override
    public float getDistanceToEdge(Layer layer, int x, int y, float maxDistance) {
        return this.doGetDistanceToEdge(layer, x, y, maxDistance);
    }

    @Override
    public Set<Layer> getAllLayers(boolean applyCombinedLayers) {
        if (applyCombinedLayers) {
            if (this.allLayersCombinedApplied == null) {
                this.allLayersCombinedApplied = new HashSet<Layer>();
                for (Dimension dimension : this.dimensions) {
                    this.allLayersCombinedApplied.addAll(dimension.getAllLayers(true));
                }
            }
            return this.allLayersCombinedApplied;
        }
        if (this.allLayers == null) {
            this.allLayers = new HashSet<Layer>();
            for (Dimension dimension : this.dimensions) {
                this.allLayers.addAll(dimension.getAllLayers(false));
            }
        }
        return this.allLayers;
    }

    @Override
    public boolean containsOneOf(Layer ... layers) {
        for (Layer layer : layers) {
            if (!this.getAllLayers(false).contains(layer)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getHeight() {
        return this.highestY - this.lowestY + 1;
    }

    @Override
    public int getHighestX() {
        return this.highestX;
    }

    @Override
    public int getHighestY() {
        return this.highestY;
    }

    @Override
    public int getLowestX() {
        return this.lowestX;
    }

    @Override
    public int getLowestY() {
        return this.lowestY;
    }

    @Override
    public int getFloodedCount(int x, int y, int r, boolean lava) {
        return this.doGetFloodedCount(x, y, r, lava);
    }

    @Override
    public float getSlope(int x, int y) {
        return this.doGetSlope(x, y);
    }

    @Override
    public Set<Point> getTileCoords() {
        return this.tileCoords;
    }

    @Override
    public int getWidth() {
        return this.highestX - this.lowestX + 1;
    }

    @Override
    public boolean isBorderTile(int x, int y) {
        boolean result = false;
        for (Dimension dimension : this.dimensions) {
            if (dimension.isTilePresent(x, y)) {
                return false;
            }
            if (!dimension.isBorderTile(x, y)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public Rectangle getExtent() {
        return this.extent;
    }

    @Override
    public Map<Layer, Integer> getLayersAt(int x, int y) {
        Object tile = this.getTile(x >> 7, y >> 7);
        return tile != null ? ((Tile)tile).getLayersAt(x & 0x7F, y & 0x7F) : null;
    }

    @Override
    public Dimension.TileVisitationBuilder visitTilesForEditing() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Tile doGetTile(Point coords) {
        return this.tileCoords.contains(coords) ? new FlatteningTile(coords.x, coords.y) : null;
    }

    class FlatteningTile
    extends ReadOnlyTile {
        private final Tile[] tiles;
        private final int[][] layerToUse;
        private final List<Layer> layers;

        FlatteningTile(int tileX, int tileY) {
            super(tileX, tileY, FlatteningDimension.this.minHeight, FlatteningDimension.this.maxHeight, false);
            this.layerToUse = new int[8][8];
            ArrayList<Tile> tiles = new ArrayList<Tile>(FlatteningDimension.this.dimensions.length);
            TreeSet<Layer> layers = new TreeSet<Layer>();
            for (Dimension dimension : FlatteningDimension.this.dimensions) {
                Tile layerTile = dimension.getTile(tileX, tileY);
                if (layerTile == null) continue;
                tiles.add(layerTile);
                layers.addAll(layerTile.getLayers());
            }
            this.tiles = tiles.toArray(new Tile[tiles.size()]);
            this.layers = new ArrayList<Layer>(layers);
            int lastTile = this.tiles.length - 1;
            for (int x = 0; x < 8; ++x) {
                block2: for (int y = 0; y < 8; ++y) {
                    int xInChunk = x << 4;
                    int yInChunk = y << 4;
                    this.layerToUse[x][y] = lastTile;
                    for (int i = 0; i < lastTile; ++i) {
                        if (this.tiles[i].getBitLayerValue(ReadOnly.INSTANCE, xInChunk, yInChunk)) {
                            this.layerToUse[x][y] = i;
                            continue block2;
                        }
                        if (this.tiles[i].getBitLayerValue(NotPresent.INSTANCE, xInChunk, yInChunk) || this.layerToUse[x][y] <= i) continue;
                        this.layerToUse[x][y] = i;
                    }
                }
            }
        }

        @Override
        public int getFloodedCount(int x, int y, int r, boolean lava) {
            int count = 0;
            for (int dx = -r; dx <= r; ++dx) {
                for (int dy = -r; dy <= r; ++dy) {
                    int xx = x + dx;
                    int yy = y + dy;
                    if (FlatteningDimension.this.getWaterLevelAt(xx, yy) <= FlatteningDimension.this.getIntHeightAt(xx, yy) || lava != FlatteningDimension.this.getBitLayerValueAt(FloodWithLava.INSTANCE, xx, yy)) continue;
                    ++count;
                }
            }
            return count;
        }

        @Override
        public List<Layer> getActiveLayers(int x, int y) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float getSlope(int x, int y) {
            return this.doGetSlope(x, y);
        }

        @Override
        public int getIntHeight(int x, int y) {
            return Math.round(this.tiles[this.layerToUse[x >> 4][y >> 4]].getHeight(x, y));
        }

        @Override
        public float getHeight(int x, int y) {
            return this.tiles[this.layerToUse[x >> 4][y >> 4]].getHeight(x, y);
        }

        @Override
        public int getRawHeight(int x, int y) {
            return this.tiles[this.layerToUse[x >> 4][y >> 4]].getRawHeight(x, y);
        }

        @Override
        public int getLowestRawHeight() {
            int lowestHeight = Integer.MAX_VALUE;
            for (int x = 0; x < 128; ++x) {
                for (int y = 0; y < 128; ++y) {
                    int height = this.tiles[this.layerToUse[x >> 4][y >> 4]].getRawHeight(x, y);
                    if (height < lowestHeight) {
                        lowestHeight = height;
                    }
                    if (lowestHeight > 0) continue;
                    return 0;
                }
            }
            return lowestHeight;
        }

        @Override
        public int getHighestRawHeight() {
            int highestHeight = Integer.MIN_VALUE;
            for (int x = 0; x < 128; ++x) {
                for (int y = 0; y < 128; ++y) {
                    int height = this.tiles[this.layerToUse[x >> 4][y >> 4]].getRawHeight(x, y);
                    if (height <= highestHeight) continue;
                    highestHeight = height;
                }
            }
            return highestHeight;
        }

        @Override
        public synchronized int[] getRawHeightRange() {
            int lowestRawHeight = Integer.MAX_VALUE;
            int highestRawHeight = Integer.MIN_VALUE;
            int maxRawHeight = (FlatteningDimension.this.maxHeight - 1 - FlatteningDimension.this.minHeight) * 256;
            for (int x = 0; x < 128; ++x) {
                for (int y = 0; y < 128; ++y) {
                    int height = this.tiles[this.layerToUse[x >> 4][y >> 4]].getRawHeight(x, y);
                    if (height < lowestRawHeight) {
                        lowestRawHeight = height;
                    }
                    if (height > highestRawHeight) {
                        highestRawHeight = height;
                    }
                    if (lowestRawHeight > 0 || highestRawHeight < maxRawHeight) continue;
                    return new int[]{0, maxRawHeight};
                }
            }
            return new int[]{lowestRawHeight, highestRawHeight};
        }

        @Override
        public Terrain getTerrain(int x, int y) {
            return this.tiles[this.layerToUse[x >> 4][y >> 4]].getTerrain(x, y);
        }

        @Override
        public Set<Terrain> getAllTerrains() {
            HashSet<Terrain> allTerrains = new HashSet<Terrain>();
            for (int x = 0; x < 128; ++x) {
                for (int y = 0; y < 128; ++y) {
                    allTerrains.add(this.getTerrain(x, y));
                }
            }
            return allTerrains;
        }

        @Override
        public int getWaterLevel(int x, int y) {
            return this.tiles[this.layerToUse[x >> 4][y >> 4]].getWaterLevel(x, y);
        }

        @Override
        public List<Layer> getLayers() {
            return this.layers;
        }

        @Override
        public boolean containsOneOf(Layer ... layers) {
            for (Layer layer : layers) {
                if (!this.layers.contains(layer)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasLayer(Layer layer) {
            return this.layers.contains(layer);
        }

        @Override
        public List<Layer> getLayers(Set<Layer> additionalLayers) {
            return this.doGetLayers(additionalLayers);
        }

        @Override
        public boolean getBitLayerValue(Layer layer, int x, int y) {
            return this.tiles[this.layerToUse[x >> 4][y >> 4]].getBitLayerValue(layer, x, y);
        }

        @Override
        public int getBitLayerCount(Layer layer, int x, int y, int r) {
            int count = 0;
            for (int dx = -r; dx <= r; ++dx) {
                for (int dy = -r; dy <= r; ++dy) {
                    if (!FlatteningDimension.this.getBitLayerValueAt(layer, x + dx, y + dy)) continue;
                    ++count;
                }
            }
            return count;
        }

        @Override
        public Map<Layer, Integer> getLayersAt(int x, int y) {
            return this.tiles[this.layerToUse[x >> 4][y >> 4]].getLayersAt(x, y);
        }

        @Override
        public float getDistanceToEdge(Layer layer, int x, int y, float maxDistance) {
            int r = (int)Math.ceil(maxDistance);
            if (!FlatteningDimension.this.getBitLayerValueAt(layer, x, y)) {
                return 0.0f;
            }
            float distance = maxDistance;
            block0: for (int i = 1; i <= r; ++i) {
                if (!(FlatteningDimension.this.getBitLayerValueAt(layer, x - i, y) && FlatteningDimension.this.getBitLayerValueAt(layer, x + i, y) && FlatteningDimension.this.getBitLayerValueAt(layer, x, y - i) && FlatteningDimension.this.getBitLayerValueAt(layer, x, y + i) || !((float)i < distance))) {
                    return i;
                }
                for (int d = 1; d <= i; ++d) {
                    if (FlatteningDimension.this.getBitLayerValueAt(layer, x - i, y - d) && FlatteningDimension.this.getBitLayerValueAt(layer, x + d, y - i) && FlatteningDimension.this.getBitLayerValueAt(layer, x + i, y + d) && FlatteningDimension.this.getBitLayerValueAt(layer, x - d, y + i) && (d >= i || FlatteningDimension.this.getBitLayerValueAt(layer, x - i, y + d) && FlatteningDimension.this.getBitLayerValueAt(layer, x - d, y - i) && FlatteningDimension.this.getBitLayerValueAt(layer, x + i, y - d) && FlatteningDimension.this.getBitLayerValueAt(layer, x + d, y + i))) continue;
                    float tDistance = MathUtils.getDistance((int)i, (int)d);
                    if (!(tDistance < distance)) continue block0;
                    distance = tDistance;
                    continue block0;
                }
            }
            return distance;
        }

        @Override
        public int getLayerValue(Layer layer, int x, int y) {
            return this.tiles[this.layerToUse[x >> 4][y >> 4]].getLayerValue(layer, x, y);
        }
    }
}

