/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.exporting;

import java.awt.Point;
import org.pepsoft.minecraft.Direction;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;

public final class Cursor
implements Cloneable {
    private final MinecraftWorld minecraftWorld;
    private int x;
    private int y;
    private int height;
    private Direction direction;

    public Cursor(MinecraftWorld minecraftWorld, int x, int y, int height, Direction direction) {
        this.minecraftWorld = minecraftWorld;
        this.x = x;
        this.y = y;
        this.height = height;
        this.direction = direction;
    }

    public Cursor(MinecraftWorld minecraftWorld, Point location, int height, Direction direction) {
        this.minecraftWorld = minecraftWorld;
        this.x = location.x;
        this.y = location.y;
        this.height = height;
        this.direction = direction;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public Material getBlock() {
        return this.minecraftWorld.getMaterialAt(this.x, this.y, this.height);
    }

    public void setBlock(Material material) {
        this.minecraftWorld.setMaterialAt(this.x, this.y, this.height, material);
    }

    public boolean isFree() {
        return this.minecraftWorld.getMaterialAt(this.x, this.y, this.height) == Material.AIR;
    }

    public boolean isFreeOrInsubstantial() {
        Material block = this.minecraftWorld.getMaterialAt(this.x, this.y, this.height);
        return block == Material.AIR || block.insubstantial;
    }

    public boolean setBlockIfFree(Material material) {
        Material existingBlock = this.minecraftWorld.getMaterialAt(this.x, this.y, this.height);
        if (existingBlock == Material.AIR || existingBlock.insubstantial) {
            this.minecraftWorld.setMaterialAt(this.x, this.y, this.height, material);
            return true;
        }
        return false;
    }

    public void setBlockWithDirection(Material material) {
        this.minecraftWorld.setMaterialAt(this.x, this.y, this.height, material.setDirection(this.direction));
    }

    public boolean setBlockWithDirectionIfFree(Material material) {
        Material existingBlock = this.minecraftWorld.getMaterialAt(this.x, this.y, this.height);
        if (existingBlock == Material.AIR || existingBlock.insubstantial) {
            this.minecraftWorld.setMaterialAt(this.x, this.y, this.height, material.setDirection(this.direction));
            return true;
        }
        return false;
    }

    public Material getBlockInFront() {
        return this.minecraftWorld.getMaterialAt(this.x + this.direction.getDx(), this.y + this.direction.getDy(), this.height);
    }

    public Material getBlockBehind() {
        return this.minecraftWorld.getMaterialAt(this.x - this.direction.getDx(), this.y - this.direction.getDy(), this.height);
    }

    public Material getBlockToTheLeft() {
        Direction leftDirection = this.direction.left();
        return this.minecraftWorld.getMaterialAt(this.x + leftDirection.getDx(), this.y + leftDirection.getDy(), this.height);
    }

    public Material getBlockToTheRight() {
        Direction rightDirection = this.direction.right();
        return this.minecraftWorld.getMaterialAt(this.x + rightDirection.getDx(), this.y + rightDirection.getDy(), this.height);
    }

    public Material getBlockAbove() {
        return this.minecraftWorld.getMaterialAt(this.x, this.y, this.height + 1);
    }

    public Material getBlockBelow() {
        return this.minecraftWorld.getMaterialAt(this.x, this.y, this.height - 1);
    }

    public Cursor forward() {
        this.x += this.direction.getDx();
        this.y += this.direction.getDy();
        return this;
    }

    public Cursor backward() {
        this.x -= this.direction.getDx();
        this.y -= this.direction.getDy();
        return this;
    }

    public Cursor moveLeft() {
        this.x += this.direction.left().getDx();
        this.y += this.direction.left().getDy();
        return this;
    }

    public Cursor moveRight() {
        this.x += this.direction.right().getDx();
        this.y += this.direction.right().getDy();
        return this;
    }

    public Cursor turnLeft() {
        this.direction = this.direction.left();
        return this;
    }

    public Cursor turnRight() {
        this.direction = this.direction.right();
        return this;
    }

    public Cursor turnAround() {
        this.direction = this.direction.opposite();
        return this;
    }

    public Cursor up() {
        ++this.height;
        return this;
    }

    public Cursor down() {
        --this.height;
        return this;
    }

    public Cursor clone() {
        try {
            return (Cursor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

