/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.biomeschemes;

import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.biomeschemes.AbstractBiomeScheme;

public abstract class AbstractMinecraft1_1BiomeScheme
extends AbstractBiomeScheme {
    public static final int BIOME_OCEAN = 0;
    public static final int BIOME_PLAINS = 1;
    public static final int BIOME_DESERT = 2;
    public static final int BIOME_EXTREME_HILLS = 3;
    public static final int BIOME_FOREST = 4;
    public static final int BIOME_TAIGA = 5;
    public static final int BIOME_SWAMPLAND = 6;
    public static final int BIOME_RIVER = 7;
    public static final int BIOME_HELL = 8;
    public static final int BIOME_SKY = 9;
    public static final int BIOME_FROZEN_OCEAN = 10;
    public static final int BIOME_FROZEN_RIVER = 11;
    public static final int BIOME_ICE_PLAINS = 12;
    public static final int BIOME_ICE_MOUNTAINS = 13;
    public static final int BIOME_MUSHROOM_ISLAND = 14;
    public static final int BIOME_MUSHROOM_ISLAND_SHORE = 15;
    public static final int BIOME_BEACH = 16;
    public static final int BIOME_DESERT_HILLS = 17;
    public static final int BIOME_FOREST_HILLS = 18;
    public static final int BIOME_TAIGA_HILLS = 19;
    public static final int BIOME_EXTREME_HILLS_EDGE = 20;
    public static final String[] BIOME_NAMES = new String[]{"Ocean", "Plains", "Desert", "Extreme Hills", "Forest", "Taiga", "Swampland", "River", "Hell", "Sky", "Frozen Ocean", "Frozen River", "Ice Plains", "Ice Mountains", "Mushroom Island", "Mushroom Island Shore", "Beach", "Desert Hills", "Forest Hills", "Taiga Hills", "Extreme Hills Edge"};
    private static final boolean[][][] BIOME_PATTERNS = new boolean[21][][];

    @Override
    public final int getBiomeCount() {
        return BIOME_NAMES.length;
    }

    @Override
    public final int getColour(int biome, ColourScheme colourScheme) {
        switch (biome) {
            case 0: {
                return colourScheme.getColour(Material.WATER);
            }
            case 1: {
                return colourScheme.getColour(Material.GRASS_BLOCK);
            }
            case 2: {
                return colourScheme.getColour(Material.SAND);
            }
            case 3: {
                return colourScheme.getColour(Material.GRASS_BLOCK);
            }
            case 4: {
                return colourScheme.getColour(Material.LEAVES_OAK);
            }
            case 5: {
                return colourScheme.getColour(Material.SNOW);
            }
            case 6: {
                return colourScheme.getColour(Material.LEAVES_OAK);
            }
            case 7: {
                return colourScheme.getColour(Material.WATER);
            }
            case 8: {
                return colourScheme.getColour(Material.NETHERRACK);
            }
            case 9: {
                return colourScheme.getColour(Material.AIR);
            }
            case 10: {
                return colourScheme.getColour(Material.ICE);
            }
            case 11: {
                return colourScheme.getColour(Material.ICE);
            }
            case 12: {
                return colourScheme.getColour(Material.SNOW);
            }
            case 13: {
                return colourScheme.getColour(Material.SNOW);
            }
            case 14: {
                return colourScheme.getColour(Material.MYCELIUM);
            }
            case 15: {
                return colourScheme.getColour(Material.MYCELIUM);
            }
            case 16: {
                return colourScheme.getColour(Material.SAND);
            }
            case 17: {
                return colourScheme.getColour(Material.SAND);
            }
            case 18: {
                return colourScheme.getColour(Material.LEAVES_OAK);
            }
            case 19: {
                return colourScheme.getColour(Material.SNOW);
            }
            case 20: {
                return colourScheme.getColour(Material.GRASS_BLOCK);
            }
        }
        throw new IllegalArgumentException(Integer.toString(biome));
    }

    @Override
    public final boolean[][] getPattern(int biome) {
        return BIOME_PATTERNS[biome];
    }

    @Override
    public boolean isBiomePresent(int biome) {
        return biome <= 20;
    }

    @Override
    public String getBiomeName(int biome) {
        return BIOME_NAMES[biome];
    }

    private static boolean[][] createPattern(BufferedImage image) {
        boolean[][] pattern = new boolean[16][];
        for (int x = 0; x < 16; ++x) {
            pattern[x] = new boolean[16];
            for (int y = 0; y < 16; ++y) {
                pattern[x][y] = image.getRGB(x, y) != -1;
            }
        }
        return pattern;
    }

    static {
        try {
            BufferedImage image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/swamp_pattern.png"));
            AbstractMinecraft1_1BiomeScheme.BIOME_PATTERNS[6] = AbstractMinecraft1_1BiomeScheme.createPattern(image);
            image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/mountains_pattern.png"));
            AbstractMinecraft1_1BiomeScheme.BIOME_PATTERNS[3] = AbstractMinecraft1_1BiomeScheme.createPattern(image);
            AbstractMinecraft1_1BiomeScheme.BIOME_PATTERNS[13] = AbstractMinecraft1_1BiomeScheme.createPattern(image);
            image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/deciduous_trees_pattern.png"));
            AbstractMinecraft1_1BiomeScheme.BIOME_PATTERNS[4] = AbstractMinecraft1_1BiomeScheme.createPattern(image);
            image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/pine_trees_pattern.png"));
            AbstractMinecraft1_1BiomeScheme.BIOME_PATTERNS[5] = AbstractMinecraft1_1BiomeScheme.createPattern(image);
            image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/hills_pattern.png"));
            AbstractMinecraft1_1BiomeScheme.BIOME_PATTERNS[17] = AbstractMinecraft1_1BiomeScheme.createPattern(image);
            AbstractMinecraft1_1BiomeScheme.BIOME_PATTERNS[20] = AbstractMinecraft1_1BiomeScheme.createPattern(image);
            image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/deciduous_hills_pattern.png"));
            AbstractMinecraft1_1BiomeScheme.BIOME_PATTERNS[18] = AbstractMinecraft1_1BiomeScheme.createPattern(image);
            image = ImageIO.read(ClassLoader.getSystemResourceAsStream("org/pepsoft/worldpainter/icons/pine_hills_pattern.png"));
            AbstractMinecraft1_1BiomeScheme.BIOME_PATTERNS[19] = AbstractMinecraft1_1BiomeScheme.createPattern(image);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error loading image", e);
        }
    }
}

