/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.biomeschemes;

import org.pepsoft.worldpainter.BiomeScheme;

public abstract class AbstractBiomeInfo
implements BiomeScheme {
    private final String[] names;
    private final boolean[][][] patterns;
    private final int highestId;

    protected AbstractBiomeInfo(String[] names, boolean[][][] patterns) {
        int highestId;
        this.names = names;
        this.patterns = patterns;
        for (int i = highestId = names.length - 1; i >= 0; --i) {
            if (names[i] == null) continue;
            highestId = i;
            break;
        }
        this.highestId = highestId;
    }

    @Override
    public final void setSeed(long seed) {
    }

    @Override
    public int getBiomeCount() {
        return this.highestId + 1;
    }

    @Override
    public int[] getBiomes(int x, int y, int width, int height) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void getBiomes(int x, int y, int width, int height, int[] buffer) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public boolean[][] getPattern(int biome) {
        return this.patterns[biome];
    }

    @Override
    public String getBiomeName(int biome) {
        return this.names[biome];
    }

    @Override
    public boolean isBiomePresent(int biome) {
        return biome >= 0 && biome <= this.highestId && this.names[biome] != null;
    }
}

