/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import com.google.common.collect.ImmutableSortedSet;
import java.awt.Point;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jnbt.CompoundTag;
import org.jnbt.XMLTransformer;
import org.pepsoft.minecraft.CustomGenerator;
import org.pepsoft.minecraft.Direction;
import org.pepsoft.minecraft.MapGenerator;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.SeededGenerator;
import org.pepsoft.minecraft.SuperflatPreset;
import org.pepsoft.util.AttributeKey;
import org.pepsoft.util.FileUtils;
import org.pepsoft.util.MemoryUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.SubProgressReceiver;
import org.pepsoft.util.undo.Cloneable;
import org.pepsoft.util.undo.UndoManager;
import org.pepsoft.worldpainter.CoordinateTransform;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.GameType;
import org.pepsoft.worldpainter.Generator;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.InstanceKeeper;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.exporting.WorldExportSettings;
import org.pepsoft.worldpainter.history.HistoryEntry;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.Layer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class World2
extends InstanceKeeper
implements Serializable,
java.lang.Cloneable {
    private String name = "Generated World";
    private boolean createGoodiesChest = true;
    private Point spawnPoint = new Point(0, 0);
    private File importedFrom;
    @Deprecated
    private SortedMap<Integer, Dimension> dimensions;
    private boolean mapFeatures = true;
    @Deprecated
    private int gameType;
    @Deprecated
    private Material[] customMaterials;
    @Deprecated
    private int biomeAlgorithm = -1;
    private int maxheight;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    @Deprecated
    private String generatorName;
    @Deprecated
    private int version;
    @Deprecated
    private Generator generator;
    private boolean dontAskToConvertToAnvil = true;
    private boolean customBiomes;
    @Deprecated
    private int dimensionToExport;
    @Deprecated
    private Set<Point> tilesToExport;
    private boolean askToRotate;
    private boolean allowMerging = true;
    private Direction upIs = Direction.NORTH;
    private boolean allowCheats;
    @Deprecated
    private String generatorOptions;
    private MixedMaterial[] mixedMaterials = new MixedMaterial[96];
    private boolean extendedBlockIds;
    private int wpVersion = 12;
    private int difficulty = 2;
    private List<HistoryEntry> history = new ArrayList<HistoryEntry>();
    private BorderSettings borderSettings = new BorderSettings();
    private File mergedWith;
    @Deprecated
    private Set<Integer> dimensionsToExport;
    private Platform platform;
    private GameType gameTypeObj = GameType.SURVIVAL;
    private Map<String, Object> attributes;
    @Deprecated
    private SuperflatPreset superflatPreset;
    private Map<Dimension.Anchor, Dimension> dimensionsByAnchor = new HashMap<Dimension.Anchor, Dimension>();
    private WorldExportSettings exportSettings;
    private List<File> dataPacks;
    private int minHeight;
    private transient Set<Warning> warnings;
    private transient Map<String, Object> metadata;
    private transient long changeNo;
    @Deprecated
    public static final int BIOME_ALGORITHM_NONE = -1;
    @Deprecated
    public static final int BIOME_ALGORITHM_CUSTOM_BIOMES = 6;
    @Deprecated
    public static final int BIOME_ALGORITHM_AUTO_BIOMES = 7;
    public static final int DEFAULT_MAX_HEIGHT = 256;
    public static final long DEFAULT_OCEAN_SEED = 27594263L;
    public static final long DEFAULT_LAND_SEED = 227290L;
    public static final String METADATA_KEY_WP_VERSION = "org.pepsoft.worldpainter.wp.version";
    public static final String METADATA_KEY_WP_BUILD = "org.pepsoft.worldpainter.wp.build";
    public static final String METADATA_KEY_TIMESTAMP = "org.pepsoft.worldpainter.timestamp";
    public static final String METADATA_KEY_PLUGINS = "org.pepsoft.worldpainter.plugins";
    public static final String METADATA_KEY_NAME = "name";
    private static final int CURRENT_WP_VERSION = 12;
    private static final Logger logger = LoggerFactory.getLogger(World2.class);
    private static final long serialVersionUID = 2011062401L;

    public World2(Platform platform, int minHeight, int maxHeight) {
        if (platform == null) {
            throw new NullPointerException();
        }
        if (minHeight < platform.minMinHeight || minHeight > platform.maxMinHeight) {
            throw new IllegalArgumentException("minHeight " + minHeight + " outside platform " + platform.displayName + " minHeight limits (" + platform.minMinHeight + " - " + platform.maxMinHeight + ")");
        }
        if (maxHeight < platform.minMaxHeight || maxHeight > platform.maxMaxHeight) {
            throw new IllegalArgumentException("maxHeight " + maxHeight + " outside platform " + platform.displayName + " maxHeight limits (" + platform.minMaxHeight + " - " + platform.maxMaxHeight + ")");
        }
        this.platform = platform;
        this.minHeight = minHeight;
        this.maxheight = maxHeight;
    }

    public World2(Platform platform, long minecraftSeed, TileFactory tileFactory) {
        if (platform == null) {
            throw new NullPointerException();
        }
        if (tileFactory.getMinHeight() < platform.minMinHeight || tileFactory.getMinHeight() > platform.maxMinHeight) {
            throw new IllegalArgumentException("tileFactory.minHeight " + tileFactory.getMinHeight() + " < " + platform.minMinHeight + " or > " + platform.maxMinHeight);
        }
        if (tileFactory.getMaxHeight() < platform.minMaxHeight || tileFactory.getMaxHeight() > platform.maxMaxHeight) {
            throw new IllegalArgumentException("tileFactory.maxHeight " + tileFactory.getMaxHeight() + " < " + platform.minMaxHeight + " or > " + platform.maxMaxHeight);
        }
        this.platform = platform;
        this.minHeight = tileFactory.getMinHeight();
        this.maxheight = tileFactory.getMaxHeight();
        Dimension dim = new Dimension(this, "Surface", minecraftSeed, tileFactory, Dimension.Anchor.NORMAL_DETAIL);
        this.addDimension(dim);
    }

    public long getChangeNo() {
        long totalChangeNo = this.changeNo + this.borderSettings.getChangeNo();
        for (Dimension dimension : this.dimensionsByAnchor.values()) {
            totalChangeNo += dimension.getChangeNo();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("World change no: {}", (Object)totalChangeNo);
        }
        return totalChangeNo;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Objects.requireNonNull(name);
        if (!name.equals(this.name)) {
            String oldName = this.name;
            this.name = name;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange(METADATA_KEY_NAME, oldName, name);
        }
    }

    public boolean isCreateGoodiesChest() {
        return this.createGoodiesChest;
    }

    public void setCreateGoodiesChest(boolean createGoodiesChest) {
        if (createGoodiesChest != this.createGoodiesChest) {
            this.createGoodiesChest = createGoodiesChest;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("createGoodiesChest", !createGoodiesChest, createGoodiesChest);
        }
    }

    public Point getTileCoordinates(int worldX, int worldY) {
        int tileX = (int)Math.floor((double)worldX / 128.0);
        int tileY = (int)Math.floor((double)worldY / 128.0);
        return new Point(tileX, tileY);
    }

    public Point getTileCoordinates(Point worldCoords) {
        return this.getTileCoordinates(worldCoords.x, worldCoords.y);
    }

    public Point getSpawnPoint() {
        return this.spawnPoint;
    }

    public void setSpawnPoint(Point spawnPoint) {
        if (!spawnPoint.equals(this.spawnPoint)) {
            Point oldSpawnPoint = this.spawnPoint;
            this.spawnPoint = spawnPoint;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("spawnPoint", oldSpawnPoint, spawnPoint);
        }
    }

    public File getImportedFrom() {
        return this.importedFrom;
    }

    public void setImportedFrom(File importedFrom) {
        if (importedFrom == null ? this.importedFrom != null : !importedFrom.equals(this.importedFrom)) {
            File oldImportedFrom = this.importedFrom;
            this.importedFrom = importedFrom;
            this.propertyChangeSupport.firePropertyChange("importedFrom", oldImportedFrom, importedFrom);
        }
    }

    public boolean isMapFeatures() {
        return this.mapFeatures;
    }

    public void setMapFeatures(boolean mapFeatures) {
        if (mapFeatures != this.mapFeatures) {
            this.mapFeatures = mapFeatures;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("mapFeatures", !mapFeatures, mapFeatures);
        }
    }

    public GameType getGameType() {
        return this.gameTypeObj;
    }

    public void setGameType(GameType gameType) {
        if (gameType != this.gameTypeObj) {
            GameType oldGameType = this.gameTypeObj;
            this.gameTypeObj = gameType;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("gameType", (Object)oldGameType, (Object)gameType);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    @Deprecated
    public Dimension getDimension(int dim) {
        switch (dim) {
            case -3: {
                return this.getDimension(Dimension.Anchor.END_DETAIL_CEILING);
            }
            case -2: {
                return this.getDimension(Dimension.Anchor.NETHER_DETAIL_CEILING);
            }
            case -1: {
                return this.getDimension(Dimension.Anchor.NORMAL_DETAIL_CEILING);
            }
            case 0: {
                return this.getDimension(Dimension.Anchor.NORMAL_DETAIL);
            }
            case 1: {
                return this.getDimension(Dimension.Anchor.NETHER_DETAIL);
            }
            case 2: {
                return this.getDimension(Dimension.Anchor.END_DETAIL);
            }
        }
        return null;
    }

    public boolean isDimensionPresent(Dimension.Anchor anchor) {
        return this.dimensionsByAnchor.containsKey(anchor);
    }

    public Dimension getDimension(Dimension.Anchor anchor) {
        return this.dimensionsByAnchor.get(anchor);
    }

    public Set<Dimension> getDimensions() {
        return new HashSet<Dimension>(this.dimensionsByAnchor.values());
    }

    public Set<Dimension> getDimensionsWithRole(Dimension.Role role, boolean inverted, int id) {
        return (Set)this.dimensionsByAnchor.values().stream().filter(dimension -> {
            Dimension.Anchor anchor = dimension.getAnchor();
            return anchor.role == role && anchor.invert == inverted && anchor.id == id;
        }).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.comparingInt(dimension -> dimension.getAnchor().dim)));
    }

    public final void addDimension(Dimension dimension) {
        TileFactory tileFactory;
        if (this.dimensionsByAnchor.containsKey(dimension.getAnchor())) {
            throw new IllegalStateException("Dimension " + dimension.getAnchor() + " already exists");
        }
        if (dimension.getMinHeight() < this.minHeight) {
            throw new IllegalStateException("Dimension has lower min height (" + dimension.getMinHeight() + ") than world (" + this.minHeight + ")");
        }
        if (dimension.getMaxHeight() > this.maxheight) {
            throw new IllegalStateException("Dimension has higher max height (" + dimension.getMaxHeight() + ") than world (" + this.maxheight + ")");
        }
        if (dimension.getWorld() != this) {
            throw new IllegalArgumentException("Dimension belongs to another world");
        }
        this.dimensionsByAnchor.put(dimension.getAnchor(), dimension);
        if (dimension.getAnchor().dim == 0 && (tileFactory = dimension.getTileFactory()) instanceof HeightMapTileFactory && ((HeightMapTileFactory)tileFactory).getWaterHeight() < 32) {
            this.generator = Generator.FLAT;
        }
        if (!dimension.getAnchor().equals(Dimension.Anchor.NORMAL_DETAIL)) {
            this.history.add(new HistoryEntry(13, new Serializable[]{dimension.getName()}));
        }
    }

    public Dimension removeDimension(Dimension.Anchor anchor) {
        if (this.dimensionsByAnchor.containsKey(anchor)) {
            ++this.changeNo;
            Dimension dimension = this.dimensionsByAnchor.remove(anchor);
            this.history.add(new HistoryEntry(14, new Serializable[]{dimension.getName()}));
            return dimension;
        }
        throw new IllegalStateException("Dimension " + anchor + " does not exist");
    }

    public MixedMaterial getMixedMaterial(int index) {
        return this.mixedMaterials[index];
    }

    public void setMixedMaterial(int index, MixedMaterial material) {
        if (material == null ? this.mixedMaterials[index] != null : !material.equals(this.mixedMaterials[index])) {
            MixedMaterial oldMaterial = this.mixedMaterials[index];
            this.mixedMaterials[index] = material;
            ++this.changeNo;
            this.propertyChangeSupport.fireIndexedPropertyChange("mixedMaterial", index, oldMaterial, material);
        }
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(int minHeight) {
        if (minHeight != this.minHeight) {
            int oldMinHeight = this.minHeight;
            this.minHeight = minHeight;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("minHeight", oldMinHeight, minHeight);
        }
    }

    public int getMaxHeight() {
        return this.maxheight;
    }

    public void setMaxHeight(int maxHeight) {
        if (maxHeight != this.maxheight) {
            int oldMaxHeight = this.maxheight;
            this.maxheight = maxHeight;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("maxHeight", oldMaxHeight, maxHeight);
        }
    }

    @Deprecated
    public Generator getGenerator() {
        return this.dimensionsByAnchor.get(Dimension.Anchor.NORMAL_DETAIL).getGenerator().getType();
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        if (platform == null) {
            throw new NullPointerException();
        }
        if (platform != this.platform) {
            Platform oldPlatform = this.platform;
            this.platform = platform;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("platform", oldPlatform, platform);
        }
    }

    public boolean isAskToConvertToAnvil() {
        return !this.dontAskToConvertToAnvil;
    }

    public void setAskToConvertToAnvil(boolean askToConvertToAnvil) {
        if (askToConvertToAnvil == this.dontAskToConvertToAnvil) {
            this.dontAskToConvertToAnvil = !askToConvertToAnvil;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("askToConvertToAnvil", askToConvertToAnvil, !askToConvertToAnvil);
        }
    }

    public boolean isAskToRotate() {
        return this.askToRotate;
    }

    public void setAskToRotate(boolean askToRotate) {
        if (askToRotate != this.askToRotate) {
            this.askToRotate = askToRotate;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("askToRotate", !askToRotate, askToRotate);
        }
    }

    public Direction getUpIs() {
        return this.upIs;
    }

    public void setUpIs(Direction upIs) {
        if (upIs != this.upIs) {
            Direction oldUpIs = this.upIs;
            this.upIs = upIs;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("upIs", (Object)oldUpIs, (Object)upIs);
        }
    }

    public boolean isAllowMerging() {
        return this.allowMerging;
    }

    public void setAllowMerging(boolean allowMerging) {
        this.allowMerging = allowMerging;
    }

    public boolean isAllowCheats() {
        return this.allowCheats;
    }

    public void setAllowCheats(boolean allowCheats) {
        if (allowCheats != this.allowCheats) {
            this.allowCheats = allowCheats;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("allowCheats", !allowCheats, allowCheats);
        }
    }

    @Deprecated
    public String getGeneratorOptions() {
        return this.dimensionsByAnchor.get(Dimension.Anchor.NORMAL_DETAIL).getGenerator() instanceof CustomGenerator ? ((CustomGenerator)this.dimensionsByAnchor.get(Dimension.Anchor.NORMAL_DETAIL).getGenerator()).getName() : null;
    }

    public boolean isExtendedBlockIds() {
        return this.extendedBlockIds;
    }

    public void setExtendedBlockIds(boolean extendedBlockIds) {
        if (extendedBlockIds != this.extendedBlockIds) {
            this.extendedBlockIds = extendedBlockIds;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("extendedBlockIds", !extendedBlockIds, extendedBlockIds);
        }
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(int difficulty) {
        if (difficulty != this.difficulty) {
            int oldDifficulty = this.difficulty;
            this.difficulty = difficulty;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("difficulty", oldDifficulty, difficulty);
        }
    }

    public WorldExportSettings getExportSettings() {
        return this.exportSettings;
    }

    public void setExportSettings(WorldExportSettings exportSettings) {
        if (!Objects.equals(exportSettings, this.exportSettings)) {
            WorldExportSettings oldExportSettings = this.exportSettings;
            this.exportSettings = exportSettings;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("exportSettings", oldExportSettings, exportSettings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HistoryEntry> getHistory() {
        List<HistoryEntry> list = this.history;
        synchronized (list) {
            return this.history;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistoryEntry(int key, Serializable ... args) {
        List<HistoryEntry> list = this.history;
        synchronized (list) {
            this.history.add(new HistoryEntry(key, args));
        }
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public BorderSettings getBorderSettings() {
        return this.borderSettings;
    }

    public File getMergedWith() {
        return this.mergedWith;
    }

    public void setMergedWith(File mergedWith) {
        if (mergedWith == null ? this.mergedWith != null : !mergedWith.equals(this.mergedWith)) {
            File oldMergedWith = this.mergedWith;
            this.mergedWith = mergedWith;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("mergedWith", oldMergedWith, mergedWith);
        }
    }

    public List<File> getDataPacks() {
        return this.dataPacks;
    }

    public void setDataPacks(List<File> dataPacks) {
        if (!Objects.equals(dataPacks, this.dataPacks)) {
            List<File> oldDataPacks = this.dataPacks;
            this.dataPacks = dataPacks;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("dataPacks", oldDataPacks, dataPacks);
        }
    }

    public <T> Optional<T> getAttribute(AttributeKey<T> key) {
        return Optional.ofNullable(this.attributes != null ? (this.attributes.containsKey(key.key) ? this.attributes.get(key.key) : key.defaultValue) : key.defaultValue);
    }

    public <T> void setAttribute(AttributeKey<T> key, T value) {
        if (value != null ? value.equals(key.defaultValue) : key.defaultValue == null) {
            this.attributes.remove(key.key);
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
        } else {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
            this.attributes.put(key.key, value);
        }
        ++this.changeNo;
    }

    public void transform(CoordinateTransform transform, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        int dimCount = this.dimensionsByAnchor.size();
        int dim = 0;
        for (Dimension dimension : this.dimensionsByAnchor.values()) {
            dimension.transform(transform, (ProgressReceiver)(progressReceiver != null ? new SubProgressReceiver(progressReceiver, (float)dim / (float)dimCount, 1.0f / (float)dimCount) : null));
            ++dim;
        }
        Point oldSpawnPoint = this.spawnPoint;
        this.spawnPoint = transform.transform(this.spawnPoint);
        this.propertyChangeSupport.firePropertyChange("spawnPoint", oldSpawnPoint, this.spawnPoint);
        Direction oldUpIs = this.upIs;
        this.upIs = transform.inverseTransform(this.upIs);
        this.propertyChangeSupport.firePropertyChange("upIs", (Object)oldUpIs, (Object)this.upIs);
        ++this.changeNo;
    }

    public void transform(Dimension.Anchor anchor, CoordinateTransform transform, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        this.dimensionsByAnchor.get(anchor).transform(transform, progressReceiver);
        if (anchor.equals(Dimension.Anchor.NORMAL_DETAIL)) {
            Point oldSpawnPoint = this.spawnPoint;
            this.spawnPoint = transform.transform(this.spawnPoint);
            this.propertyChangeSupport.firePropertyChange("spawnPoint", oldSpawnPoint, this.spawnPoint);
            Direction oldUpIs = this.upIs;
            this.upIs = transform.inverseTransform(this.upIs);
            this.propertyChangeSupport.firePropertyChange("upIs", (Object)oldUpIs, (Object)this.upIs);
        }
        ++this.changeNo;
    }

    public void clearLayerData(Layer layer) {
        for (Dimension dimension : this.dimensionsByAnchor.values()) {
            dimension.clearLayerData(layer);
        }
    }

    public long measureSize() {
        this.dimensionsByAnchor.values().forEach(Dimension::ensureAllReadable);
        return MemoryUtils.getSize((Object)this, new HashSet<Class>(Arrays.asList(UndoManager.class, Dimension.Listener.class, PropertyChangeSupport.class, Layer.class, Terrain.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save(ZipOutputStream out) throws IOException {
        out.putNextEntry(new ZipEntry("world-data.bin"));
        try {
            Map<Dimension.Anchor, Dimension> savedDimensions = this.dimensionsByAnchor;
            try {
                this.dimensionsByAnchor = null;
                ObjectOutputStream dataout = new ObjectOutputStream(out);
                dataout.writeObject(this);
                dataout.flush();
            }
            finally {
                this.dimensionsByAnchor = savedDimensions;
            }
        }
        finally {
            out.closeEntry();
        }
        for (Dimension dimension : this.dimensionsByAnchor.values()) {
            dimension.save(out);
        }
    }

    Set<Warning> getWarnings() {
        return this.warnings;
    }

    private void addWarning(Warning warning) {
        if (this.warnings == null) {
            this.warnings = EnumSet.of(warning);
        } else {
            this.warnings.add(warning);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.dataPacks = (List)FileUtils.absolutise(this.dataPacks);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        if (this.dimensionsByAnchor == null) {
            this.dimensionsByAnchor = new HashMap<Dimension.Anchor, Dimension>();
        }
        if (this.wpVersion < 1) {
            Dimension dim;
            if (this.maxheight == 0) {
                this.maxheight = 128;
            }
            if (this.generator == null) {
                this.generator = Generator.DEFAULT;
                if (this.generatorName != null && this.generatorName.equals("FLAT")) {
                    this.generator = Generator.FLAT;
                } else {
                    TileFactory tileFactory;
                    TileFactory tileFactory2 = tileFactory = this.dimensions.containsKey(0) ? ((Dimension)this.dimensions.get(0)).getTileFactory() : null;
                    if (tileFactory instanceof HeightMapTileFactory && ((HeightMapTileFactory)tileFactory).getWaterHeight() < 32) {
                        this.generator = Generator.FLAT;
                    }
                }
            }
            if (this.biomeAlgorithm == 6) {
                this.customBiomes = true;
            }
            if (this.upIs == null) {
                this.upIs = Direction.WEST;
                this.askToRotate = true;
            }
            if (!this.allowMerging && this.biomeAlgorithm != -1) {
                this.customBiomes = false;
            }
            if (this.mixedMaterials == null) {
                this.mixedMaterials = new MixedMaterial[96];
                if (this.customMaterials != null) {
                    for (int i = 0; i < this.customMaterials.length; ++i) {
                        if (this.customMaterials[i] == null) continue;
                        this.mixedMaterials[i] = MixedMaterial.create(DefaultPlugin.JAVA_ANVIL, this.customMaterials[i]);
                    }
                    this.customMaterials = null;
                }
            }
            if ((dim = (Dimension)this.dimensions.get(0)) != null) {
                if (this.biomeAlgorithm == 7) {
                    this.addWarning(Warning.AUTO_BIOMES_DISABLED);
                } else if (this.customBiomes) {
                    boolean tilesWithBiomesFound = false;
                    boolean tilesWithoutBiomesFound = false;
                    for (Tile tile : dim.getTiles()) {
                        if (tile.hasLayer(Biome.INSTANCE)) {
                            tilesWithBiomesFound = true;
                            continue;
                        }
                        tilesWithoutBiomesFound = true;
                    }
                    if (tilesWithBiomesFound) {
                        if (tilesWithoutBiomesFound) {
                            for (Tile tile : dim.getTiles()) {
                                if (tile.hasLayer(Biome.INSTANCE)) continue;
                                for (int x = 0; x < 128; ++x) {
                                    for (int y = 0; y < 128; ++y) {
                                        tile.setLayerValue(Biome.INSTANCE, x, y, 0);
                                    }
                                }
                            }
                        }
                    } else if (tilesWithoutBiomesFound) {
                        this.addWarning(Warning.AUTO_BIOMES_ENABLED);
                    }
                } else {
                    dim.clearLayerData(Biome.INSTANCE);
                    this.addWarning(Warning.AUTO_BIOMES_ENABLED);
                }
            }
        }
        if (this.wpVersion < 2) {
            this.difficulty = this.gameType == 3 ? 3 : 2;
        }
        if (this.wpVersion < 3) {
            this.history = new ArrayList<HistoryEntry>();
            this.history.add(new HistoryEntry(2, new Serializable[0]));
        }
        if (this.wpVersion < 4) {
            this.borderSettings = new BorderSettings();
        }
        if (this.wpVersion < 5) {
            this.dimensionsToExport = this.tilesToExport != null ? Collections.singleton(this.dimensionToExport) : null;
            this.dimensionToExport = -1;
        }
        if (this.wpVersion < 6) {
            switch (this.version) {
                case 19132: {
                    this.platform = DefaultPlugin.JAVA_MCREGION;
                    break;
                }
                case 19133: {
                    this.platform = DefaultPlugin.JAVA_ANVIL;
                    break;
                }
                default: {
                    this.platform = this.maxheight == 256 ? DefaultPlugin.JAVA_ANVIL : DefaultPlugin.JAVA_MCREGION;
                }
            }
            this.version = -1;
            if (this.gameType == -1) {
                this.addWarning(Warning.GAME_TYPE_RESET);
                this.gameTypeObj = GameType.SURVIVAL;
            } else {
                this.gameTypeObj = GameType.values()[this.gameType];
                this.gameType = -1;
            }
        }
        if (this.wpVersion < 7 && this.generatorOptions != null && !this.generatorOptions.trim().isEmpty()) {
            try {
                this.superflatPreset = SuperflatPreset.fromMinecraft1_12_2(this.generatorOptions.trim());
                this.generatorOptions = null;
            }
            catch (IllegalArgumentException e) {
                try {
                    CompoundTag tag = (CompoundTag)XMLTransformer.fromXML((Reader)new StringReader(this.generatorOptions));
                    this.superflatPreset = SuperflatPreset.fromMinecraft1_15_2(tag);
                    this.generatorOptions = null;
                }
                catch (IOException | ClassCastException exception) {
                    // empty catch block
                }
            }
        }
        if (this.wpVersion < 8) {
            BitSet customTerrainsInUse = new BitSet();
            for (Dimension dimension2 : this.dimensions.values()) {
                for (Terrain terrain : dimension2.getAllTerrains()) {
                    if (!terrain.isCustom()) continue;
                    customTerrainsInUse.set(terrain.getCustomTerrainIndex());
                }
            }
            customTerrainsInUse.stream().forEach(index -> {
                if (this.getMixedMaterial(index) == null) {
                    logger.error("Mixed material {} was missing; replaced with magenta wool", (Object)index);
                    MixedMaterial replacementMaterial = new MixedMaterial("Missing Custom Terrain " + index, new MixedMaterial.Row(Material.WOOL_MAGENTA, 1, 1.0f), 1, null);
                    this.setMixedMaterial(index, replacementMaterial);
                    this.addWarning(Warning.MISSING_CUSTOM_TERRAINS);
                }
            });
        }
        if (this.wpVersion < 9) {
            this.dimensions.values().forEach(dimension -> {
                switch (dimension.getAnchor().dim) {
                    case 0: {
                        MapGenerator generator = MapGenerator.fromLegacySettings(this.generator, dimension.getMinecraftSeed(), this.generatorName, this.generatorOptions, this.platform, this::addWarning);
                        dimension.setGenerator(generator);
                        break;
                    }
                    case 1: {
                        dimension.setGenerator(new SeededGenerator(Generator.NETHER, dimension.getSeed()));
                        break;
                    }
                    case 2: {
                        dimension.setGenerator(new SeededGenerator(Generator.END, dimension.getSeed()));
                    }
                }
            });
            this.generator = null;
            this.generatorName = null;
            this.generatorOptions = null;
        }
        if (this.wpVersion < 10) {
            this.dimensions.values().forEach(dimension -> this.dimensionsByAnchor.put(dimension.getAnchor(), (Dimension)dimension));
            this.dimensions = null;
        }
        if (this.wpVersion < 11) {
            if (this.dimensionsToExport != null && !this.dimensionsToExport.isEmpty() || this.tilesToExport != null && !this.tilesToExport.isEmpty()) {
                this.exportSettings = new WorldExportSettings(this.dimensionsToExport != null && !this.dimensionsToExport.isEmpty() ? this.dimensionsToExport : null, this.tilesToExport != null && !this.tilesToExport.isEmpty() ? this.tilesToExport : null, null);
            }
            this.dimensionsToExport = null;
            this.tilesToExport = null;
        }
        if (this.wpVersion < 12) {
            this.minHeight = this.platform.minZ;
        }
        this.wpVersion = 12;
        if (this.mixedMaterials.length != 96) {
            this.mixedMaterials = Arrays.copyOf(this.mixedMaterials, 96);
        }
    }

    public static class BorderSettings
    implements Serializable,
    Cloneable<BorderSettings> {
        private int centreX;
        private int centreY;
        private int size = 60000000;
        private int safeZone = 5;
        private int warningBlocks = 5;
        private int warningTime = 15;
        private int sizeLerpTarget = 60000000;
        private int sizeLerpTime;
        private float damagePerBlock = 0.2f;
        private transient long changeNo;
        private static final long serialVersionUID = 1L;

        public int getCentreX() {
            return this.centreX;
        }

        public void setCentreX(int centreX) {
            if (centreX != this.centreX) {
                this.centreX = centreX;
                ++this.changeNo;
            }
        }

        public int getCentreY() {
            return this.centreY;
        }

        public void setCentreY(int centreY) {
            if (centreY != this.centreY) {
                this.centreY = centreY;
                ++this.changeNo;
            }
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            if (size != this.size) {
                this.size = size;
                ++this.changeNo;
            }
        }

        public int getSafeZone() {
            return this.safeZone;
        }

        public void setSafeZone(int safeZone) {
            if (safeZone != this.safeZone) {
                this.safeZone = safeZone;
                ++this.changeNo;
            }
        }

        public int getWarningBlocks() {
            return this.warningBlocks;
        }

        public void setWarningBlocks(int warningBlocks) {
            if (warningBlocks != this.warningBlocks) {
                this.warningBlocks = warningBlocks;
                ++this.changeNo;
            }
        }

        public int getWarningTime() {
            return this.warningTime;
        }

        public void setWarningTime(int warningTime) {
            if (warningTime != this.warningTime) {
                this.warningTime = warningTime;
                ++this.changeNo;
            }
        }

        public int getSizeLerpTarget() {
            return this.sizeLerpTarget;
        }

        public void setSizeLerpTarget(int sizeLerpTarget) {
            if (sizeLerpTarget != this.sizeLerpTarget) {
                this.sizeLerpTarget = sizeLerpTarget;
                ++this.changeNo;
            }
        }

        public int getSizeLerpTime() {
            return this.sizeLerpTime;
        }

        public void setSizeLerpTime(int sizeLerpTime) {
            if (sizeLerpTime != this.sizeLerpTime) {
                this.sizeLerpTime = sizeLerpTime;
                ++this.changeNo;
            }
        }

        public float getDamagePerBlock() {
            return this.damagePerBlock;
        }

        public void setDamagePerBlock(float damagePerBlock) {
            if (damagePerBlock != this.damagePerBlock) {
                this.damagePerBlock = damagePerBlock;
                ++this.changeNo;
            }
        }

        public long getChangeNo() {
            return this.changeNo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BorderSettings that = (BorderSettings)o;
            if (this.centreX != that.centreX) {
                return false;
            }
            if (this.centreY != that.centreY) {
                return false;
            }
            if (this.size != that.size) {
                return false;
            }
            if (this.safeZone != that.safeZone) {
                return false;
            }
            if (this.warningBlocks != that.warningBlocks) {
                return false;
            }
            if (this.warningTime != that.warningTime) {
                return false;
            }
            if (this.sizeLerpTarget != that.sizeLerpTarget) {
                return false;
            }
            if (this.sizeLerpTime != that.sizeLerpTime) {
                return false;
            }
            return Float.compare(that.damagePerBlock, this.damagePerBlock) == 0;
        }

        public int hashCode() {
            int result = this.centreX;
            result = 31 * result + this.centreY;
            result = 31 * result + this.size;
            result = 31 * result + this.safeZone;
            result = 31 * result + this.warningBlocks;
            result = 31 * result + this.warningTime;
            result = 31 * result + this.sizeLerpTarget;
            result = 31 * result + this.sizeLerpTime;
            result = 31 * result + (this.damagePerBlock != 0.0f ? Float.floatToIntBits(this.damagePerBlock) : 0);
            return result;
        }

        public BorderSettings clone() {
            try {
                return (BorderSettings)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }

    public static enum Warning {
        AUTO_BIOMES_ENABLED,
        AUTO_BIOMES_DISABLED,
        MISSING_CUSTOM_TERRAINS,
        SUPERFLAT_SETTINGS_RESET,
        GAME_TYPE_RESET;

    }
}

