/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.pepsoft.util.swing.TileListener;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Overlay;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileProvider;
import org.pepsoft.worldpainter.TileRenderer;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.renderers.VoidRenderer;
import org.pepsoft.worldpainter.ramps.ColourRamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WPTileProvider
implements org.pepsoft.util.swing.TileProvider,
Dimension.Listener,
Tile.Listener {
    private final TileProvider tileProvider;
    private final ColourScheme colourScheme;
    private final Set<Layer> hiddenLayers;
    private final boolean contourLines;
    private final boolean active;
    private final boolean transparentVoid;
    private final int contourSeparation;
    private final TileRenderer.LightOrigin lightOrigin;
    private final List<TileListener> listeners = new ArrayList<TileListener>();
    private final CustomBiomeManager customBiomeManager;
    private final Effect effect;
    private final ColourRamp colourRamp;
    private int zoom = 0;
    private boolean hideAllLayers;
    private volatile ThreadLocal<TileRenderer> tileRendererRef;
    private static final Logger logger = LoggerFactory.getLogger(WPTileProvider.class);
    public static final Set<Layer> HIDE_ALL_LAYERS = Collections.emptySet();

    public WPTileProvider(TileProvider tileProvider, ColourScheme colourScheme, CustomBiomeManager customBiomeManager, Set<Layer> hiddenLayers, boolean contourLines, int contourSeparation, TileRenderer.LightOrigin lightOrigin, boolean active, Effect effect, boolean transparentVoid, ColourRamp colourRamp) {
        this.tileProvider = tileProvider;
        this.colourScheme = colourScheme;
        this.hiddenLayers = hiddenLayers != null && hiddenLayers != HIDE_ALL_LAYERS ? new HashSet<Layer>(hiddenLayers) : null;
        this.hideAllLayers = hiddenLayers == HIDE_ALL_LAYERS;
        this.contourLines = contourLines;
        this.contourSeparation = contourSeparation;
        this.lightOrigin = lightOrigin;
        this.active = active;
        this.customBiomeManager = customBiomeManager;
        this.tileRendererRef = this.createNewTileRendererRef();
        this.effect = effect;
        this.transparentVoid = transparentVoid;
        this.colourRamp = colourRamp;
    }

    public WPTileProvider(TileProvider tileProvider, ColourScheme colourScheme, CustomBiomeManager customBiomeManager, Set<Layer> hiddenLayers, boolean contourLines, int contourSeparation, TileRenderer.LightOrigin lightOrigin, ColourRamp colourRamp) {
        this(tileProvider, colourScheme, customBiomeManager, hiddenLayers, contourLines, contourSeparation, lightOrigin, false, null, true, colourRamp);
    }

    public synchronized void setHiddenLayers(Set<Layer> hiddenLayers) {
        if (this.hideAllLayers) {
            throw new IllegalStateException("Cannot set hiddenLayers when hideAllLayers is set");
        }
        this.hiddenLayers.clear();
        if (hiddenLayers != null) {
            this.hiddenLayers.addAll(hiddenLayers);
        }
        this.tileRendererRef = this.createNewTileRendererRef();
    }

    public synchronized Set<Layer> getHiddenLayers() {
        return Collections.unmodifiableSet(this.hiddenLayers);
    }

    public boolean isHideAllLayers() {
        return this.hideAllLayers;
    }

    public void setHideAllLayers(boolean hideAllLayers) {
        if (hideAllLayers != this.hideAllLayers) {
            this.hideAllLayers = hideAllLayers;
            this.tileRendererRef = this.createNewTileRendererRef();
        }
    }

    public int getTileSize() {
        return 128;
    }

    public boolean isTilePresent(int x, int y) {
        if (this.zoom == 0) {
            return this.isUnzoomedTilePresent(x, y);
        }
        int scale = 1 << -this.zoom;
        for (int dx = 0; dx < scale; ++dx) {
            for (int dy = 0; dy < scale; ++dy) {
                if (!this.isUnzoomedTilePresent(x * scale + dx, y * scale + dy)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean paintTile(Image tileImage, int x, int y, int imageX, int imageY) {
        try {
            if (this.zoom == 0) {
                return this.paintUnzoomedTile(tileImage, x, y, imageX, imageY);
            }
            Graphics2D g2 = (Graphics2D)tileImage.getGraphics();
            try {
                g2.setComposite(AlphaComposite.Src);
                g2.setBackground(new Color(0xFFFFFF & VoidRenderer.getColour(), true));
                int scale = 1 << -this.zoom;
                int subSize = 128 / scale;
                for (int dx = 0; dx < scale; ++dx) {
                    for (int dy = 0; dy < scale; ++dy) {
                        if (this.isUnzoomedTilePresent(x * scale + dx, y * scale + dy)) {
                            Tile tile = this.tileProvider.getTile(x * scale + dx, y * scale + dy);
                            TileRenderer tileRenderer = this.tileRendererRef.get();
                            tileRenderer.renderTile(tile, tileImage, dx * subSize, dy * subSize);
                            continue;
                        }
                        g2.clearRect(imageX + dx * subSize, imageY + dy * subSize, subSize, subSize);
                    }
                }
                this.applyEffects(g2);
            }
            finally {
                g2.dispose();
            }
            return true;
        }
        catch (Throwable e) {
            logger.error("Exception while generating image for tile at {}, {}", new Object[]{x, y, e});
            return false;
        }
    }

    public int getTilePriority(int x, int y) {
        if (this.zoom == 0) {
            return this.isUnzoomedTilePresent(x, y) ? 1 : 0;
        }
        int scale = 1 << -this.zoom;
        for (int dx = 0; dx < scale; ++dx) {
            for (int dy = 0; dy < scale; ++dy) {
                if (!this.isUnzoomedTilePresent(x * scale + dx, y * scale + dy)) continue;
                return 1;
            }
        }
        return 0;
    }

    public Rectangle getExtent() {
        return this.tileProvider.getExtent();
    }

    public void addTileListener(TileListener tileListener) {
        if (this.active && this.listeners.isEmpty()) {
            ((Dimension)this.tileProvider).addDimensionListener(this);
            for (Tile tile : ((Dimension)this.tileProvider).getTiles()) {
                tile.addListener(this);
            }
        }
        if (!this.listeners.contains(tileListener)) {
            this.listeners.add(tileListener);
        }
    }

    public void removeTileListener(TileListener tileListener) {
        this.listeners.remove(tileListener);
        if (this.active && this.listeners.isEmpty()) {
            for (Tile tile : ((Dimension)this.tileProvider).getTiles()) {
                tile.removeListener(this);
            }
            ((Dimension)this.tileProvider).removeDimensionListener(this);
        }
    }

    public boolean isZoomSupported() {
        return true;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        if (zoom != this.zoom) {
            if (zoom > 0) {
                throw new UnsupportedOperationException("Zooming in not supported");
            }
            this.zoom = zoom;
            this.tileRendererRef = this.createNewTileRendererRef();
        }
    }

    @Override
    public void tilesAdded(Dimension dimension, Set<Tile> tiles) {
        for (Tile tile : tiles) {
            tile.addListener(this);
        }
        this.fireTilesChanged(tiles);
    }

    @Override
    public void tilesRemoved(Dimension dimension, Set<Tile> tiles) {
        for (Tile tile : tiles) {
            tile.removeListener(this);
        }
        this.fireTilesChanged(tiles);
    }

    @Override
    public void overlayAdded(Dimension dimension, int index, Overlay overlay) {
    }

    @Override
    public void overlayRemoved(Dimension dimension, int index, Overlay overlay) {
    }

    @Override
    public void heightMapChanged(Tile tile) {
        this.fireTileChanged(tile);
    }

    @Override
    public void terrainChanged(Tile tile) {
        this.fireTileChanged(tile);
    }

    @Override
    public void waterLevelChanged(Tile tile) {
        this.fireTileChanged(tile);
    }

    @Override
    public void layerDataChanged(Tile tile, Set<Layer> changedLayers) {
        this.fireTileChanged(tile);
    }

    @Override
    public void allBitLayerDataChanged(Tile tile) {
        this.fireTileChanged(tile);
    }

    @Override
    public void allNonBitlayerDataChanged(Tile tile) {
        this.fireTileChanged(tile);
    }

    @Override
    public void seedsChanged(Tile tile) {
        this.fireTileChanged(tile);
    }

    private boolean isUnzoomedTilePresent(int x, int y) {
        return this.tileProvider.isTilePresent(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean paintUnzoomedTile(Image tileImage, int x, int y, int dx, int dy) {
        if (this.isUnzoomedTilePresent(x, y)) {
            this.tileRendererRef.get().renderTile(this.tileProvider.getTile(x, y), tileImage, dx, dy);
            if (this.effect != null) {
                Graphics2D g2 = (Graphics2D)tileImage.getGraphics();
                try {
                    this.applyEffects(g2);
                }
                finally {
                    g2.dispose();
                }
            }
            return true;
        }
        return false;
    }

    private void fireTileChanged(Tile tile) {
        Point coords = this.getTileCoordinates(tile);
        for (TileListener listener : this.listeners) {
            listener.tileChanged((org.pepsoft.util.swing.TileProvider)this, coords.x, coords.y);
        }
    }

    private void fireTilesChanged(Set<Tile> tiles) {
        Set coords = tiles.stream().map(this::getTileCoordinates).collect(Collectors.toSet());
        for (TileListener listener : this.listeners) {
            listener.tilesChanged((org.pepsoft.util.swing.TileProvider)this, coords);
        }
    }

    private Point getTileCoordinates(Tile tile) {
        return this.getTileCoordinates(tile.getX(), tile.getY());
    }

    private Point getTileCoordinates(int tileX, int tileY) {
        if (this.zoom == 0) {
            return new Point(tileX, tileY);
        }
        if (this.zoom < 0) {
            return new Point(tileX >> -this.zoom, tileY >> -this.zoom);
        }
        return new Point(tileX << this.zoom, tileY << this.zoom);
    }

    @NotNull
    private ThreadLocal<TileRenderer> createNewTileRendererRef() {
        return ThreadLocal.withInitial(() -> {
            TileRenderer tileRenderer = new TileRenderer(this.tileProvider, this.colourScheme, this.customBiomeManager, this.zoom, this.transparentVoid, this.colourRamp);
            WPTileProvider wPTileProvider = this;
            synchronized (wPTileProvider) {
                if (this.hideAllLayers) {
                    tileRenderer.setHideAllLayers(true);
                } else if (this.hiddenLayers != null) {
                    tileRenderer.addHiddenLayers(this.hiddenLayers);
                }
            }
            tileRenderer.setContourLines(this.contourLines);
            tileRenderer.setContourSeparation(this.contourSeparation);
            tileRenderer.setLightOrigin(this.lightOrigin);
            return tileRenderer;
        });
    }

    private void applyEffects(Graphics2D g2) {
        if (this.effect == null) {
            return;
        }
        switch (this.effect) {
            case FADE_TO_FIFTY_PERCENT: {
                g2.setComposite(AlphaComposite.SrcOver.derive(0.5f));
                g2.setColor(Color.WHITE);
                g2.fillRect(0, 0, 128, 128);
                break;
            }
            case FADE_TO_TWENTYFIVE_PERCENT: {
                g2.setComposite(AlphaComposite.SrcOver.derive(0.75f));
                g2.setColor(Color.WHITE);
                g2.fillRect(0, 0, 128, 128);
            }
        }
    }

    public static enum Effect {
        FADE_TO_FIFTY_PERCENT,
        FADE_TO_TWENTYFIVE_PERCENT;

    }
}

