/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.util.BitSet;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.pepsoft.util.undo.BufferKey;
import org.pepsoft.util.undo.Snapshot;
import org.pepsoft.util.undo.UndoManager;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.layers.Layer;

public final class TileSnapshot
extends Tile {
    private final Snapshot snapshot;
    private final Set<Tile.TileBuffer> readableBuffers = EnumSet.noneOf(Tile.TileBuffer.class);
    private transient BufferKey<short[]> HEIGHTMAP_BUFFER_KEY;
    private transient BufferKey<byte[]> TERRAIN_BUFFER_KEY;
    private transient BufferKey<byte[]> WATERLEVEL_BUFFER_KEY;
    private transient BufferKey<Map<Layer, byte[]>> LAYER_DATA_BUFFER_KEY;
    private transient BufferKey<Map<Layer, BitSet>> BIT_LAYER_DATA_BUFFER_KEY;
    private static final long serialVersionUID = 2011101501L;

    public TileSnapshot(Tile tile, Snapshot snapshot) {
        super(tile.getX(), tile.getY(), tile.getMinHeight(), tile.getMaxHeight());
        this.snapshot = snapshot;
        this.HEIGHTMAP_BUFFER_KEY = new Tile.TileUndoBufferKey<short[]>(tile, Tile.TileBuffer.HEIGHTMAP);
        this.TERRAIN_BUFFER_KEY = new Tile.TileUndoBufferKey<byte[]>(tile, Tile.TileBuffer.TERRAIN);
        this.WATERLEVEL_BUFFER_KEY = new Tile.TileUndoBufferKey<byte[]>(tile, Tile.TileBuffer.WATERLEVEL);
        this.LAYER_DATA_BUFFER_KEY = new Tile.TileUndoBufferKey<Map<Layer, byte[]>>(tile, Tile.TileBuffer.LAYER_DATA);
        this.BIT_LAYER_DATA_BUFFER_KEY = new Tile.TileUndoBufferKey<Map<Layer, BitSet>>(tile, Tile.TileBuffer.BIT_LAYER_DATA);
    }

    @Override
    public void addListener(Tile.Listener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unregister() {
    }

    @Override
    protected void ensureReadable(Tile.TileBuffer buffer) {
        if (!this.readableBuffers.contains((Object)buffer)) {
            switch (buffer) {
                case HEIGHTMAP: {
                    this.heightMap = (short[])this.snapshot.getBuffer(this.HEIGHTMAP_BUFFER_KEY);
                    break;
                }
                case TERRAIN: {
                    this.terrain = (byte[])this.snapshot.getBuffer(this.TERRAIN_BUFFER_KEY);
                    break;
                }
                case WATERLEVEL: {
                    this.waterLevel = (byte[])this.snapshot.getBuffer(this.WATERLEVEL_BUFFER_KEY);
                    break;
                }
                case LAYER_DATA: {
                    this.layerData = (Map)this.snapshot.getBuffer(this.LAYER_DATA_BUFFER_KEY);
                    break;
                }
                case BIT_LAYER_DATA: {
                    this.bitLayerData = (Map)this.snapshot.getBuffer(this.BIT_LAYER_DATA_BUFFER_KEY);
                }
            }
            this.readableBuffers.add(buffer);
        }
    }

    @Override
    public boolean isEventsInhibited() {
        return false;
    }

    @Override
    public void register(UndoManager undoManager) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBitLayerValue(Layer layer, int x, int y, boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void inhibitEvents() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void releaseEvents() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHeight(int x, int y, float height) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLayerValue(Layer layer, int x, int y, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTerrain(int x, int y, Terrain terrain) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setWaterLevel(int x, int y, int waterLevel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "TileSnapshot[x=" + this.getX() + ",y=" + this.getY() + "]";
    }
}

