/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Point;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.pepsoft.util.CollectionUtils;
import org.pepsoft.util.MathUtils;
import org.pepsoft.util.ObjectUtils;
import org.pepsoft.util.undo.BufferKey;
import org.pepsoft.util.undo.UndoListener;
import org.pepsoft.util.undo.UndoManager;
import org.pepsoft.worldpainter.CoordinateTransform;
import org.pepsoft.worldpainter.HeightTransform;
import org.pepsoft.worldpainter.InstanceKeeper;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.gardenofeden.Seed;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.FloodWithLava;
import org.pepsoft.worldpainter.layers.Layer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tile
extends InstanceKeeper
implements Serializable,
UndoListener,
Cloneable {
    private final int x;
    private final int y;
    private int minHeight;
    private int maxHeight;
    private boolean tall;
    protected short[] heightMap;
    protected int[] tallHeightMap;
    protected byte[] terrain;
    protected byte[] waterLevel;
    protected short[] tallWaterLevel;
    protected Map<Layer, byte[]> layerData;
    protected Map<Layer, BitSet> bitLayerData;
    private HashSet<Seed> seeds;
    private transient List<Listener> listeners;
    private volatile transient boolean heightMapDirty;
    private volatile transient boolean terrainDirty;
    private volatile transient boolean waterLevelDirty;
    private volatile transient boolean seedsDirty;
    private volatile transient boolean bitLayersDirty;
    private volatile transient boolean nonBitLayersDirty;
    private transient Set<TileBuffer> readableBuffers;
    private transient Set<TileBuffer> writeableBuffers;
    private transient UndoManager undoManager;
    private transient List<Layer> cachedLayers;
    private volatile transient Set<Layer> dirtyLayers;
    private transient int maxY;
    private volatile transient int eventInhibitionCounter;
    private transient BufferKey<short[]> HEIGHTMAP_BUFFER_KEY;
    private transient BufferKey<int[]> TALL_HEIGHTMAP_BUFFER_KEY;
    private transient BufferKey<byte[]> TERRAIN_BUFFER_KEY;
    private transient BufferKey<byte[]> WATERLEVEL_BUFFER_KEY;
    private transient BufferKey<short[]> TALL_WATERLEVEL_BUFFER_KEY;
    private transient BufferKey<Map<Layer, byte[]>> LAYER_DATA_BUFFER_KEY;
    private transient BufferKey<Map<Layer, BitSet>> BIT_LAYER_DATA_BUFFER_KEY;
    private transient BufferKey<HashSet<Seed>> SEEDS_BUFFER_KEY;
    private static final Terrain[] TERRAIN_VALUES = Terrain.values();
    private static final float SQRT_OF_EIGHT = (float)Math.sqrt(8.0);
    private static final Logger logger = LoggerFactory.getLogger(Tile.class);
    private static final long serialVersionUID = 2011040101L;

    public Tile(int x, int y, int minHeight, int maxHeight) {
        this(x, y, minHeight, maxHeight, true);
    }

    protected Tile(int x, int y, int minHeight, int maxHeight, boolean init) {
        this.x = x;
        this.y = y;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        if (maxHeight - minHeight > 256) {
            this.tall = true;
        }
        if (init) {
            this.terrain = new byte[16384];
            if (this.tall) {
                this.tallHeightMap = new int[16384];
                this.tallWaterLevel = new short[16384];
            } else {
                this.heightMap = new short[16384];
                this.waterLevel = new byte[16384];
            }
            this.layerData = new HashMap<Layer, byte[]>();
            this.bitLayerData = new HashMap<Layer, BitSet>();
            this.init();
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public synchronized int getMinHeight() {
        return this.minHeight;
    }

    public synchronized int getMaxHeight() {
        return this.maxHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinMaxHeight(int minHeight, int maxHeight, HeightTransform heightTransform) {
        this.inhibitEvents();
        try {
            Tile tile = this;
            synchronized (tile) {
                if (maxHeight != this.maxHeight || minHeight != this.minHeight) {
                    boolean newTall;
                    int oldMinHeight = this.minHeight;
                    int minHeightDelta = oldMinHeight - minHeight;
                    this.minHeight = minHeight;
                    this.maxHeight = maxHeight;
                    this.maxY = maxHeight - 1;
                    boolean bl = newTall = maxHeight - minHeight > 256;
                    if (newTall == this.tall) {
                        if (!heightTransform.isIdentity()) {
                            for (int x = 0; x < 128; ++x) {
                                for (int y = 0; y < 128; ++y) {
                                    this.setHeight(x, y, this.clamp(heightTransform.transformHeight(this.getHeight(x, y) + (float)minHeightDelta)));
                                    this.setWaterLevel(x, y, this.clamp(heightTransform.transformHeight(this.getWaterLevel(x, y) + minHeightDelta)));
                                }
                            }
                        } else {
                            for (int x = 0; x < 128; ++x) {
                                for (int y = 0; y < 128; ++y) {
                                    this.setHeight(x, y, this.clamp(this.getHeight(x, y) + (float)minHeightDelta));
                                    this.setWaterLevel(x, y, this.clamp(this.getWaterLevel(x, y) + minHeightDelta));
                                }
                            }
                        }
                    } else if (this.tall) {
                        this.heightMap = new short[16384];
                        this.waterLevel = new byte[16384];
                        if (this.undoManager != null) {
                            this.undoManager.addBuffer(this.HEIGHTMAP_BUFFER_KEY, (Object)this.heightMap, (UndoListener)this);
                            this.undoManager.addBuffer(this.WATERLEVEL_BUFFER_KEY, (Object)this.waterLevel, (UndoListener)this);
                            this.readableBuffers.add(TileBuffer.HEIGHTMAP);
                            this.readableBuffers.add(TileBuffer.WATERLEVEL);
                            this.writeableBuffers.add(TileBuffer.HEIGHTMAP);
                            this.writeableBuffers.add(TileBuffer.WATERLEVEL);
                        }
                        this.tall = false;
                        for (int x = 0; x < 128; ++x) {
                            for (int y = 0; y < 128; ++y) {
                                this.setHeight(x, y, this.clamp(heightTransform.transformHeight((float)this.tallHeightMap[x | y << 7] / 256.0f + (float)oldMinHeight)));
                                this.setWaterLevel(x, y, this.clamp(heightTransform.transformHeight(this.tallWaterLevel[x | y << 7] + oldMinHeight)));
                            }
                        }
                        if (this.undoManager != null) {
                            this.undoManager.removeBuffer(this.TALL_HEIGHTMAP_BUFFER_KEY);
                            this.undoManager.removeBuffer(this.TALL_WATERLEVEL_BUFFER_KEY);
                            this.readableBuffers.remove((Object)TileBuffer.TALL_HEIGHTMAP);
                            this.readableBuffers.remove((Object)TileBuffer.TALL_WATERLEVEL);
                            this.writeableBuffers.remove((Object)TileBuffer.TALL_HEIGHTMAP);
                            this.writeableBuffers.remove((Object)TileBuffer.TALL_WATERLEVEL);
                        }
                        this.tallHeightMap = null;
                        this.tallWaterLevel = null;
                    } else {
                        this.tallHeightMap = new int[16384];
                        this.tallWaterLevel = new short[16384];
                        if (this.undoManager != null) {
                            this.undoManager.addBuffer(this.TALL_HEIGHTMAP_BUFFER_KEY, (Object)this.tallHeightMap, (UndoListener)this);
                            this.undoManager.addBuffer(this.TALL_WATERLEVEL_BUFFER_KEY, (Object)this.tallWaterLevel, (UndoListener)this);
                            this.readableBuffers.add(TileBuffer.TALL_HEIGHTMAP);
                            this.readableBuffers.add(TileBuffer.TALL_WATERLEVEL);
                            this.writeableBuffers.add(TileBuffer.TALL_HEIGHTMAP);
                            this.writeableBuffers.add(TileBuffer.TALL_WATERLEVEL);
                        }
                        this.tall = true;
                        for (int x = 0; x < 128; ++x) {
                            for (int y = 0; y < 128; ++y) {
                                this.setHeight(x, y, this.clamp(heightTransform.transformHeight((float)(this.heightMap[x | y << 7] & 0xFFFF) / 256.0f + (float)oldMinHeight)));
                                this.setWaterLevel(x, y, this.clamp(heightTransform.transformHeight((this.waterLevel[x | y << 7] & 0xFF) + oldMinHeight)));
                            }
                        }
                        if (this.undoManager != null) {
                            this.undoManager.removeBuffer(this.HEIGHTMAP_BUFFER_KEY);
                            this.undoManager.removeBuffer(this.WATERLEVEL_BUFFER_KEY);
                            this.readableBuffers.remove((Object)TileBuffer.HEIGHTMAP);
                            this.readableBuffers.remove((Object)TileBuffer.WATERLEVEL);
                            this.writeableBuffers.remove((Object)TileBuffer.HEIGHTMAP);
                            this.writeableBuffers.remove((Object)TileBuffer.WATERLEVEL);
                        }
                        this.heightMap = null;
                        this.waterLevel = null;
                    }
                } else if (!heightTransform.isIdentity()) {
                    for (int x = 0; x < 128; ++x) {
                        for (int y = 0; y < 128; ++y) {
                            this.setHeight(x, y, this.clamp(heightTransform.transformHeight(this.getHeight(x, y))));
                            this.setWaterLevel(x, y, this.clamp(heightTransform.transformHeight(this.getWaterLevel(x, y))));
                        }
                    }
                }
            }
        }
        finally {
            this.releaseEvents();
        }
    }

    public int getIntHeight(int x, int y) {
        return Math.round(this.getHeight(x, y));
    }

    public int getLowestIntHeight() {
        return Math.round((float)this.getLowestRawHeight() / 256.0f + (float)this.minHeight);
    }

    public int getHighestIntHeight() {
        return Math.round((float)this.getHighestRawHeight() / 256.0f + (float)this.minHeight);
    }

    public synchronized float getHeight(int x, int y) {
        if (this.tall) {
            this.ensureReadable(TileBuffer.TALL_HEIGHTMAP);
            return (float)this.tallHeightMap[x | y << 7] / 256.0f + (float)this.minHeight;
        }
        this.ensureReadable(TileBuffer.HEIGHTMAP);
        return (float)(this.heightMap[x | y << 7] & 0xFFFF) / 256.0f + (float)this.minHeight;
    }

    public float getLowestHeight() {
        return (float)this.getLowestRawHeight() / 256.0f + (float)this.minHeight;
    }

    public float getHighestHeight() {
        return (float)this.getHighestRawHeight() / 256.0f + (float)this.minHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeight(int x, int y, float height) {
        Tile tile = this;
        synchronized (tile) {
            if (this.tall) {
                this.ensureWriteable(TileBuffer.TALL_HEIGHTMAP);
                this.tallHeightMap[x | y << 7] = (int)((height - (float)this.minHeight) * 256.0f);
            } else {
                this.ensureWriteable(TileBuffer.HEIGHTMAP);
                this.heightMap[x | y << 7] = (short)((height - (float)this.minHeight) * 256.0f);
            }
        }
        this.heightMapChanged();
    }

    public synchronized int getRawHeight(int x, int y) {
        if (this.tall) {
            this.ensureReadable(TileBuffer.TALL_HEIGHTMAP);
            return this.tallHeightMap[x | y << 7];
        }
        this.ensureReadable(TileBuffer.HEIGHTMAP);
        return this.heightMap[x | y << 7] & 0xFFFF;
    }

    public synchronized int getLowestRawHeight() {
        int lowestRawHeight = Integer.MAX_VALUE;
        if (this.tall) {
            this.ensureReadable(TileBuffer.TALL_HEIGHTMAP);
            for (int height : this.tallHeightMap) {
                if (height < lowestRawHeight) {
                    lowestRawHeight = height;
                }
                if (lowestRawHeight > 0) continue;
                return 0;
            }
        } else {
            this.ensureReadable(TileBuffer.HEIGHTMAP);
            for (short height : this.heightMap) {
                if ((height & 0xFFFF) < lowestRawHeight) {
                    lowestRawHeight = height & 0xFFFF;
                }
                if (lowestRawHeight > 0) continue;
                return 0;
            }
        }
        return lowestRawHeight;
    }

    public synchronized int getHighestRawHeight() {
        int highestRawHeight = Integer.MIN_VALUE;
        int maxRawHeight = (this.maxHeight - 1 - this.minHeight) * 256;
        if (this.tall) {
            this.ensureReadable(TileBuffer.TALL_HEIGHTMAP);
            for (int height : this.tallHeightMap) {
                if (height <= highestRawHeight || (highestRawHeight = height) < maxRawHeight) continue;
                return maxRawHeight;
            }
        } else {
            this.ensureReadable(TileBuffer.HEIGHTMAP);
            for (short height : this.heightMap) {
                if ((height & 0xFFFF) <= highestRawHeight || (highestRawHeight = height & 0xFFFF) < maxRawHeight) continue;
                return maxRawHeight;
            }
        }
        return highestRawHeight;
    }

    public synchronized int[] getRawHeightRange() {
        int lowestRawHeight = Integer.MAX_VALUE;
        int highestRawHeight = Integer.MIN_VALUE;
        int maxRawHeight = (this.maxHeight - 1 - this.minHeight) * 256;
        if (this.tall) {
            this.ensureReadable(TileBuffer.TALL_HEIGHTMAP);
            for (int height : this.tallHeightMap) {
                if (height < lowestRawHeight) {
                    lowestRawHeight = height;
                }
                if (height > highestRawHeight) {
                    highestRawHeight = height;
                }
                if (lowestRawHeight > 0 || highestRawHeight < maxRawHeight) continue;
                return new int[]{0, maxRawHeight};
            }
        } else {
            this.ensureReadable(TileBuffer.HEIGHTMAP);
            for (short height : this.heightMap) {
                if ((height & 0xFFFF) < lowestRawHeight) {
                    lowestRawHeight = height & 0xFFFF;
                }
                if ((height & 0xFFFF) > highestRawHeight) {
                    highestRawHeight = height & 0xFFFF;
                }
                if (lowestRawHeight > 0 || highestRawHeight < maxRawHeight) continue;
                return new int[]{0, maxRawHeight};
            }
        }
        return new int[]{lowestRawHeight, highestRawHeight};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRawHeight(int x, int y, int rawHeight) {
        Tile tile = this;
        synchronized (tile) {
            if (this.tall) {
                this.ensureWriteable(TileBuffer.TALL_HEIGHTMAP);
                this.tallHeightMap[x | y << 7] = rawHeight;
            } else {
                this.ensureWriteable(TileBuffer.HEIGHTMAP);
                this.heightMap[x | y << 7] = (short)rawHeight;
            }
        }
        this.heightMapChanged();
    }

    public float getSlope(int x, int y) {
        return this.doGetSlope(x, y);
    }

    protected final synchronized float doGetSlope(int x, int y) {
        return Math.max(Math.max(Math.abs(this.getHeight(x + 1, y) - this.getHeight(x - 1, y)) / 2.0f, Math.abs(this.getHeight(x + 1, y + 1) - this.getHeight(x - 1, y - 1)) / SQRT_OF_EIGHT), Math.max(Math.abs(this.getHeight(x, y + 1) - this.getHeight(x, y - 1)) / 2.0f, Math.abs(this.getHeight(x - 1, y + 1) - this.getHeight(x + 1, y - 1)) / SQRT_OF_EIGHT));
    }

    public synchronized Terrain getTerrain(int x, int y) {
        this.ensureReadable(TileBuffer.TERRAIN);
        return TERRAIN_VALUES[this.terrain[x | y << 7] & 0xFF];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTerrain(int x, int y, Terrain terrain) {
        Tile tile = this;
        synchronized (tile) {
            this.ensureWriteable(TileBuffer.TERRAIN);
            if (this.terrain == null) {
                throw new NullPointerException("setTerrain(" + x + ", " + y + ", " + (Object)((Object)terrain) + "): this.terrain is null for tile @ " + this.x + "," + this.y);
            }
            if (terrain == null) {
                throw new NullPointerException("setTerrain(" + x + ", " + y + ", null): terrain parameter is null for tile @ " + this.x + "," + this.y);
            }
            this.terrain[x | y << 7] = (byte)terrain.ordinal();
        }
        this.terrainChanged();
    }

    public synchronized Set<Terrain> getAllTerrains() {
        this.ensureReadable(TileBuffer.TERRAIN);
        BitSet terrainIndices = new BitSet(256);
        for (byte terrainIndex : this.terrain) {
            terrainIndices.set(terrainIndex & 0xFF);
        }
        return terrainIndices.stream().mapToObj(i -> TERRAIN_VALUES[i]).collect(Collectors.toSet());
    }

    public synchronized int getWaterLevel(int x, int y) {
        if (this.tall) {
            this.ensureReadable(TileBuffer.TALL_WATERLEVEL);
            return (this.tallWaterLevel[x | y << 7] & 0xFFFF) + this.minHeight;
        }
        this.ensureReadable(TileBuffer.WATERLEVEL);
        return (this.waterLevel[x | y << 7] & 0xFF) + this.minHeight;
    }

    public synchronized int getHighestWaterLevel() {
        if (this.tall) {
            this.ensureReadable(TileBuffer.TALL_WATERLEVEL);
            return CollectionUtils.unsignedMax((short[])this.tallWaterLevel) + this.minHeight;
        }
        this.ensureReadable(TileBuffer.WATERLEVEL);
        return CollectionUtils.unsignedMax((byte[])this.waterLevel) + this.minHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWaterLevel(int x, int y, int waterLevel) {
        Tile tile = this;
        synchronized (tile) {
            if (this.tall) {
                this.ensureWriteable(TileBuffer.TALL_WATERLEVEL);
                this.tallWaterLevel[x | y << 7] = (short)(waterLevel - this.minHeight);
            } else {
                this.ensureWriteable(TileBuffer.WATERLEVEL);
                this.waterLevel[x | y << 7] = (byte)(waterLevel - this.minHeight);
            }
        }
        this.waterLevelChanged();
    }

    public synchronized List<Layer> getLayers() {
        if (this.cachedLayers == null) {
            this.ensureReadable(TileBuffer.LAYER_DATA);
            this.ensureReadable(TileBuffer.BIT_LAYER_DATA);
            ArrayList<Layer> layers = new ArrayList<Layer>();
            layers.addAll(this.layerData.keySet());
            layers.addAll(this.bitLayerData.keySet());
            Collections.sort(layers);
            this.cachedLayers = Collections.unmodifiableList(layers);
        }
        return this.cachedLayers;
    }

    public synchronized boolean hasLayer(Layer layer) {
        Layer.DataSize dataSize = layer.getDataSize();
        if (dataSize == Layer.DataSize.BIT || dataSize == Layer.DataSize.BIT_PER_CHUNK) {
            this.ensureReadable(TileBuffer.BIT_LAYER_DATA);
            return this.bitLayerData.containsKey(layer);
        }
        this.ensureReadable(TileBuffer.LAYER_DATA);
        return this.layerData.containsKey(layer);
    }

    public synchronized List<Layer> getActiveLayers(int x, int y) {
        Layer.DataSize dataSize;
        Layer layer;
        this.ensureReadable(TileBuffer.BIT_LAYER_DATA);
        this.ensureReadable(TileBuffer.LAYER_DATA);
        ArrayList<Layer> activeLayers = new ArrayList<Layer>(this.bitLayerData.size() + this.layerData.size());
        for (Map.Entry<Layer, BitSet> entry : this.bitLayerData.entrySet()) {
            layer = entry.getKey();
            dataSize = layer.getDataSize();
            if ((dataSize != Layer.DataSize.BIT || !this.getBitPerBlockLayerValue(entry.getValue(), x, y)) && (dataSize != Layer.DataSize.BIT_PER_CHUNK || !this.getBitPerChunkLayerValue(entry.getValue(), x, y))) continue;
            activeLayers.add(layer);
        }
        for (Map.Entry<Layer, BitSet> entry : this.layerData.entrySet()) {
            layer = entry.getKey();
            dataSize = layer.getDataSize();
            int defaultValue = layer.getDefaultValue();
            if (dataSize == Layer.DataSize.NIBBLE) {
                int byteOffset = x | y << 7;
                byte _byte = ((byte[])entry.getValue())[byteOffset / 2];
                if (!(byteOffset % 2 == 0 ? (_byte & 0xF) != defaultValue : (_byte & 0xF0) >> 4 != defaultValue)) continue;
                activeLayers.add(layer);
                continue;
            }
            if ((((byte[])entry.getValue())[x | y << 7] & 0xFF) == defaultValue) continue;
            activeLayers.add(layer);
        }
        return activeLayers;
    }

    public List<Layer> getLayers(Set<Layer> additionalLayers) {
        return this.doGetLayers(additionalLayers);
    }

    protected final synchronized List<Layer> doGetLayers(Set<Layer> additionalLayers) {
        TreeSet<Layer> layers = new TreeSet<Layer>(additionalLayers);
        layers.addAll(this.getLayers());
        return new ArrayList<Layer>(layers);
    }

    public synchronized boolean getBitLayerValue(Layer layer, int x, int y) {
        if (layer.getDataSize() != Layer.DataSize.BIT && layer.getDataSize() != Layer.DataSize.BIT_PER_CHUNK) {
            throw new IllegalArgumentException("Layer is not bit sized");
        }
        this.ensureReadable(TileBuffer.BIT_LAYER_DATA);
        BitSet bitSet = this.bitLayerData.get(layer);
        if (bitSet == null) {
            return false;
        }
        if (layer.getDataSize() == Layer.DataSize.BIT) {
            return this.getBitPerBlockLayerValue(bitSet, x, y);
        }
        return this.getBitPerChunkLayerValue(bitSet, x, y);
    }

    public synchronized int getBitLayerCount(Layer layer, int x, int y, int r) {
        if (layer.getDataSize() != Layer.DataSize.BIT && layer.getDataSize() != Layer.DataSize.BIT_PER_CHUNK) {
            throw new IllegalArgumentException("Layer is not bit sized");
        }
        if (x - r < 0 || x + r >= 128 || y - r < 0 || y + r >= 128) {
            throw new IllegalArgumentException("Requested area not contained entirely on tile");
        }
        this.ensureReadable(TileBuffer.BIT_LAYER_DATA);
        BitSet bitSet = this.bitLayerData.get(layer);
        if (bitSet == null) {
            return 0;
        }
        boolean bitPerChunk = layer.getDataSize() == Layer.DataSize.BIT_PER_CHUNK;
        int count = 0;
        for (int dx = -r; dx <= r; ++dx) {
            for (int dy = -r; dy <= r; ++dy) {
                int bitOffset = bitPerChunk ? (x + dx) / 16 + (y + dy) / 16 * 8 : x + dx + (y + dy) * 128;
                if (!bitSet.get(bitOffset)) continue;
                ++count;
            }
        }
        return count;
    }

    public synchronized Map<Layer, Integer> getLayersAt(int x, int y) {
        int value;
        Object layerValues;
        Layer layer;
        HashMap<Layer, Integer> layers = null;
        this.ensureReadable(TileBuffer.LAYER_DATA);
        for (Map.Entry<Layer, byte[]> entry : this.layerData.entrySet()) {
            layer = entry.getKey();
            layerValues = entry.getValue();
            if (layer.getDataSize() == Layer.DataSize.NIBBLE) {
                int byteOffset = x | y << 7;
                byte _byte = layerValues[byteOffset / 2];
                value = byteOffset % 2 == 0 ? _byte & 0xF : (_byte & 0xF0) >> 4;
            } else {
                value = layerValues[x | y << 7] & 0xFF;
            }
            if (value == layer.getDefaultValue()) continue;
            if (layers == null) {
                layers = new HashMap<Layer, Integer>();
            }
            layers.put(layer, value);
        }
        this.ensureReadable(TileBuffer.BIT_LAYER_DATA);
        for (Map.Entry<Layer, Object> entry : this.bitLayerData.entrySet()) {
            layer = entry.getKey();
            layerValues = (BitSet)entry.getValue();
            if (layer.getDataSize() == Layer.DataSize.BIT) {
                value = ((BitSet)layerValues).get(x | y << 7) ? 1 : 0;
            } else {
                int n = value = ((BitSet)layerValues).get((x >> 4) + (y >> 4) * 8) ? 1 : 0;
            }
            if (value == layer.getDefaultValue()) continue;
            if (layers == null) {
                layers = new HashMap();
            }
            layers.put(layer, value);
        }
        return layers;
    }

    public synchronized int getFloodedCount(int x, int y, int r, boolean lava) {
        if (x - r < 0 || x + r >= 128 || y - r < 0 || y + r >= 128) {
            throw new IllegalArgumentException("Requested area not contained entirely on tile");
        }
        if (this.tall) {
            this.ensureReadable(TileBuffer.TALL_HEIGHTMAP);
            this.ensureReadable(TileBuffer.TALL_WATERLEVEL);
            this.ensureReadable(TileBuffer.BIT_LAYER_DATA);
            BitSet floodWithLava = this.bitLayerData.get(FloodWithLava.INSTANCE);
            int count = 0;
            for (int dx = -r; dx <= r; ++dx) {
                for (int dy = -r; dy <= r; ++dy) {
                    int xx = x + dx;
                    int yy = y + dy;
                    if (this.tallWaterLevel[xx + yy * 128] <= Math.round((float)this.tallHeightMap[xx + yy * 128] / 256.0f) || !(lava ? floodWithLava != null && this.getBitPerBlockLayerValue(floodWithLava, xx, yy) : floodWithLava == null || !this.getBitPerBlockLayerValue(floodWithLava, xx, yy))) continue;
                    ++count;
                }
            }
            return count;
        }
        this.ensureReadable(TileBuffer.HEIGHTMAP);
        this.ensureReadable(TileBuffer.WATERLEVEL);
        this.ensureReadable(TileBuffer.BIT_LAYER_DATA);
        BitSet floodWithLava = this.bitLayerData.get(FloodWithLava.INSTANCE);
        int count = 0;
        for (int dx = -r; dx <= r; ++dx) {
            for (int dy = -r; dy <= r; ++dy) {
                int xx = x + dx;
                int yy = y + dy;
                if ((this.waterLevel[xx + yy * 128] & 0xFF) <= Math.round((float)(this.heightMap[xx + yy * 128] & 0xFFFF) / 256.0f) || !(lava ? floodWithLava != null && this.getBitPerBlockLayerValue(floodWithLava, xx, yy) : floodWithLava == null || !this.getBitPerBlockLayerValue(floodWithLava, xx, yy))) continue;
                ++count;
            }
        }
        return count;
    }

    public synchronized float getDistanceToEdge(Layer layer, int x, int y, float maxDistance) {
        if (layer.getDataSize() != Layer.DataSize.BIT && layer.getDataSize() != Layer.DataSize.BIT_PER_CHUNK) {
            throw new IllegalArgumentException("Layer is not bit sized");
        }
        int r = (int)Math.ceil(maxDistance);
        if (x - r < 0 || x + r >= 128 || y - r < 0 || y + r >= 128) {
            throw new IllegalArgumentException("Requested area not contained entirely on tile");
        }
        this.ensureReadable(TileBuffer.BIT_LAYER_DATA);
        BitSet bitSet = this.bitLayerData.get(layer);
        if (bitSet == null) {
            return 0.0f;
        }
        float distance = maxDistance;
        if (layer.getDataSize() == Layer.DataSize.BIT) {
            if (!this.getBitPerBlockLayerValue(bitSet, x, y)) {
                return 0.0f;
            }
            block0: for (int i = 1; i <= r; ++i) {
                if (!(this.getBitPerBlockLayerValue(bitSet, x - i, y) && this.getBitPerBlockLayerValue(bitSet, x + i, y) && this.getBitPerBlockLayerValue(bitSet, x, y - i) && this.getBitPerBlockLayerValue(bitSet, x, y + i) || !((float)i < distance))) {
                    return i;
                }
                for (int d = 1; d <= i; ++d) {
                    if (this.getBitPerBlockLayerValue(bitSet, x - i, y - d) && this.getBitPerBlockLayerValue(bitSet, x + d, y - i) && this.getBitPerBlockLayerValue(bitSet, x + i, y + d) && this.getBitPerBlockLayerValue(bitSet, x - d, y + i) && (d >= i || this.getBitPerBlockLayerValue(bitSet, x - i, y + d) && this.getBitPerBlockLayerValue(bitSet, x - d, y - i) && this.getBitPerBlockLayerValue(bitSet, x + i, y - d) && this.getBitPerBlockLayerValue(bitSet, x + d, y + i))) continue;
                    float tDistance = MathUtils.getDistance((int)i, (int)d);
                    if (!(tDistance < distance)) continue block0;
                    distance = tDistance;
                    continue block0;
                }
            }
        } else {
            if (!this.getBitPerChunkLayerValue(bitSet, x, y)) {
                return 0.0f;
            }
            block2: for (int i = 1; i <= r; ++i) {
                if (!(this.getBitPerChunkLayerValue(bitSet, x - i, y) && this.getBitPerChunkLayerValue(bitSet, x + i, y) && this.getBitPerChunkLayerValue(bitSet, x, y - i) && this.getBitPerChunkLayerValue(bitSet, x, y + i) || !((float)i < distance))) {
                    return i;
                }
                for (int d = 1; d <= i; ++d) {
                    if (this.getBitPerChunkLayerValue(bitSet, x - i, y - d) && this.getBitPerChunkLayerValue(bitSet, x + d, y - i) && this.getBitPerChunkLayerValue(bitSet, x + i, y + d) && this.getBitPerChunkLayerValue(bitSet, x - d, y + i) && (d >= i || this.getBitPerChunkLayerValue(bitSet, x - i, y + d) && this.getBitPerChunkLayerValue(bitSet, x - d, y - i) && this.getBitPerChunkLayerValue(bitSet, x + i, y - d) && this.getBitPerChunkLayerValue(bitSet, x + d, y + i))) continue;
                    float tDistance = MathUtils.getDistance((int)i, (int)d);
                    if (!(tDistance < distance)) continue block2;
                    distance = tDistance;
                    continue block2;
                }
            }
        }
        return distance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBitLayerValue(Layer layer, int x, int y, boolean value) {
        if (layer.getDataSize() != Layer.DataSize.BIT && layer.getDataSize() != Layer.DataSize.BIT_PER_CHUNK) {
            throw new IllegalArgumentException("Layer is not bit sized");
        }
        Tile tile = this;
        synchronized (tile) {
            this.ensureWriteable(TileBuffer.BIT_LAYER_DATA);
            BitSet bitSet = this.bitLayerData.get(layer);
            if (bitSet == null) {
                if (value) {
                    this.cachedLayers = null;
                    bitSet = layer.getDataSize() == Layer.DataSize.BIT ? new BitSet(16384) : new BitSet(64);
                    this.bitLayerData.put(layer, bitSet);
                } else {
                    return;
                }
            }
            int bitOffset = layer.getDataSize() == Layer.DataSize.BIT ? x | y << 7 : x / 16 + y / 16 * 8;
            bitSet.set(bitOffset, value);
        }
        this.layerDataChanged(layer);
    }

    public synchronized int getLayerValue(Layer layer, int x, int y) {
        this.ensureReadable(TileBuffer.LAYER_DATA);
        byte[] layerValues = this.layerData.get(layer);
        if (layerValues == null) {
            return layer.getDefaultValue();
        }
        switch (layer.getDataSize()) {
            case BIT: 
            case BIT_PER_CHUNK: {
                throw new IllegalArgumentException("Can't get bits using this method");
            }
            case NIBBLE: {
                int byteOffset = x | y << 7;
                byte _byte = layerValues[byteOffset / 2];
                if (byteOffset % 2 == 0) {
                    return _byte & 0xF;
                }
                return (_byte & 0xF0) >> 4;
            }
            case BYTE: {
                int byteOffset = x | y << 7;
                return layerValues[byteOffset] & 0xFF;
            }
        }
        throw new InternalError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayerValue(Layer layer, int x, int y, int value) {
        Tile tile = this;
        synchronized (tile) {
            this.ensureWriteable(TileBuffer.LAYER_DATA);
            byte[] layerValues = this.layerData.get(layer);
            if (layerValues == null) {
                if (value == layer.getDefaultValue()) {
                    return;
                }
                this.cachedLayers = null;
                switch (layer.getDataSize()) {
                    case BIT: 
                    case BIT_PER_CHUNK: {
                        throw new IllegalArgumentException("Can't set bits using this method");
                    }
                    case NIBBLE: {
                        layerValues = new byte[8192];
                        if (layer.getDefaultValue() == 0) break;
                        byte defaultValue = (byte)(layer.getDefaultValue() << 4 | layer.getDefaultValue());
                        Arrays.fill(layerValues, defaultValue);
                        break;
                    }
                    case BYTE: {
                        layerValues = new byte[16384];
                        if (layer.getDefaultValue() == 0) break;
                        byte defaultValue = (byte)layer.getDefaultValue();
                        Arrays.fill(layerValues, defaultValue);
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                this.layerData.put(layer, layerValues);
            }
            switch (layer.getDataSize()) {
                case BIT: 
                case BIT_PER_CHUNK: {
                    throw new IllegalArgumentException("Can't set bits using this method");
                }
                case NIBBLE: {
                    if (value < 0 || value > 15) {
                        throw new IllegalArgumentException("Illegal value " + value + " for nibble sized layer " + layer);
                    }
                    int byteOffset = x | y << 7;
                    byte _byte = layerValues[byteOffset / 2];
                    if (byteOffset % 2 == 0) {
                        _byte = (byte)(_byte & 0xF0);
                        _byte = (byte)(_byte | value);
                    } else {
                        _byte = (byte)(_byte & 0xF);
                        _byte = (byte)(_byte | value << 4);
                    }
                    layerValues[byteOffset / 2] = _byte;
                    break;
                }
                case BYTE: {
                    if (value < 0 || value > 255) {
                        throw new IllegalArgumentException("Illegal value " + value + " for byte sized layer " + layer);
                    }
                    int byteOffset = x | y << 7;
                    layerValues[byteOffset] = (byte)value;
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }
        this.layerDataChanged(layer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLayerData(Layer layer) {
        HashSet<Layer> changedLayers = new HashSet<Layer>();
        Tile tile = this;
        synchronized (tile) {
            if (layer.getDataSize() == Layer.DataSize.BIT || layer.getDataSize() == Layer.DataSize.BIT_PER_CHUNK) {
                this.ensureReadable(TileBuffer.BIT_LAYER_DATA);
                if (this.bitLayerData.containsKey(layer)) {
                    this.ensureWriteable(TileBuffer.BIT_LAYER_DATA);
                    this.bitLayerData.remove(layer);
                    changedLayers.add(layer);
                    this.cachedLayers = null;
                }
            } else {
                this.ensureReadable(TileBuffer.LAYER_DATA);
                if (this.layerData.containsKey(layer)) {
                    this.ensureWriteable(TileBuffer.LAYER_DATA);
                    this.layerData.remove(layer);
                    changedLayers.add(layer);
                    this.cachedLayers = null;
                }
            }
        }
        if (!changedLayers.isEmpty()) {
            changedLayers.forEach(this::layerDataChanged);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLayerData(int x, int y, Set<Layer> excludedLayers) {
        HashSet<Layer> changedLayers = new HashSet<Layer>();
        Tile tile = this;
        synchronized (tile) {
            Layer layer;
            this.ensureWriteable(TileBuffer.BIT_LAYER_DATA);
            for (Map.Entry<Layer, BitSet> entry : this.bitLayerData.entrySet()) {
                layer = entry.getKey();
                if (excludedLayers != null && excludedLayers.contains(layer)) continue;
                int bitOffset = layer.getDataSize() == Layer.DataSize.BIT ? x | y << 7 : x / 16 + y / 16 * 8;
                entry.getValue().set(bitOffset, layer.getDefaultValue() != 0);
                changedLayers.add(layer);
            }
            this.ensureWriteable(TileBuffer.LAYER_DATA);
            for (Map.Entry<Layer, BitSet> entry : this.layerData.entrySet()) {
                layer = entry.getKey();
                if (excludedLayers != null && excludedLayers.contains(layer)) continue;
                byte[] layerValues = (byte[])entry.getValue();
                switch (layer.getDataSize()) {
                    case NIBBLE: {
                        int byteOffset = x | y << 7;
                        byte _byte = layerValues[byteOffset / 2];
                        if (byteOffset % 2 == 0) {
                            _byte = (byte)(_byte & 0xF0);
                            _byte = (byte)(_byte | layer.getDefaultValue());
                        } else {
                            _byte = (byte)(_byte & 0xF);
                            _byte = (byte)(_byte | layer.getDefaultValue() << 4);
                        }
                        layerValues[byteOffset / 2] = _byte;
                        break;
                    }
                    case BYTE: {
                        int byteOffset = x | y << 7;
                        layerValues[byteOffset] = (byte)layer.getDefaultValue();
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                changedLayers.add(layer);
            }
        }
        if (!changedLayers.isEmpty()) {
            changedLayers.forEach(this::layerDataChanged);
        }
    }

    public synchronized HashSet<Seed> getSeeds() {
        if (this.seeds != null) {
            this.ensureReadable(TileBuffer.SEEDS);
            return this.seeds;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean plantSeed(Seed seed) {
        Tile tile = this;
        synchronized (tile) {
            if (this.seeds == null) {
                this.seeds = new HashSet();
                if (this.undoManager != null) {
                    this.undoManager.addBuffer(this.SEEDS_BUFFER_KEY, this.seeds, (UndoListener)this);
                    this.readableBuffers.add(TileBuffer.SEEDS);
                    this.writeableBuffers.add(TileBuffer.SEEDS);
                }
            } else {
                this.ensureWriteable(TileBuffer.SEEDS);
            }
            this.seeds.add(seed);
        }
        this.seedsChanged();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSeed(Seed seed) {
        Tile tile = this;
        synchronized (tile) {
            if (this.seeds == null) {
                this.seeds = new HashSet();
                if (this.undoManager != null) {
                    this.undoManager.addBuffer(this.SEEDS_BUFFER_KEY, this.seeds, (UndoListener)this);
                    this.readableBuffers.add(TileBuffer.SEEDS);
                    this.writeableBuffers.add(TileBuffer.SEEDS);
                }
            } else {
                this.ensureWriteable(TileBuffer.SEEDS);
            }
            this.seeds.remove(seed);
        }
        this.seedsChanged();
    }

    public synchronized void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public boolean isEventsInhibited() {
        return this.eventInhibitionCounter != 0;
    }

    public void inhibitEvents() {
        ++this.eventInhibitionCounter;
    }

    public void releaseEvents() {
        if (this.eventInhibitionCounter > 0) {
            --this.eventInhibitionCounter;
            if (this.eventInhibitionCounter == 0) {
                Layer.DataSize dataSize;
                Iterator<Layer> i;
                if (this.heightMapDirty) {
                    this.heightMapChanged();
                    this.heightMapDirty = false;
                }
                if (this.terrainDirty) {
                    this.terrainChanged();
                    this.terrainDirty = false;
                }
                if (this.waterLevelDirty) {
                    this.waterLevelChanged();
                    this.waterLevelDirty = false;
                }
                if (this.bitLayersDirty) {
                    this.allBitLayerDataChanged();
                    this.bitLayersDirty = false;
                    i = this.dirtyLayers.iterator();
                    while (i.hasNext()) {
                        dataSize = i.next().getDataSize();
                        if (dataSize != Layer.DataSize.BIT && dataSize != Layer.DataSize.BIT_PER_CHUNK) continue;
                        i.remove();
                    }
                }
                if (this.nonBitLayersDirty) {
                    this.allNonBitLayerDataChanged();
                    this.nonBitLayersDirty = false;
                    i = this.dirtyLayers.iterator();
                    while (i.hasNext()) {
                        dataSize = i.next().getDataSize();
                        if (dataSize == Layer.DataSize.BIT || dataSize == Layer.DataSize.BIT_PER_CHUNK) continue;
                        i.remove();
                    }
                }
                if (!this.dirtyLayers.isEmpty()) {
                    Set<Layer> changedLayers = Collections.unmodifiableSet(this.dirtyLayers);
                    for (Listener listener : this.listeners) {
                        listener.layerDataChanged(this, changedLayers);
                    }
                    this.dirtyLayers.clear();
                }
                if (this.seedsDirty) {
                    this.seedsChanged();
                    this.seedsDirty = false;
                }
            }
        } else {
            throw new IllegalStateException("Events not inhibited");
        }
    }

    public synchronized void register(UndoManager undoManager) {
        this.undoManager = undoManager;
        this.registerUndoBuffers();
        undoManager.addListener((UndoListener)this);
    }

    public synchronized void unregister() {
        if (this.undoManager != null) {
            this.undoManager.removeListener((UndoListener)this);
            this.unregisterUndoBuffers();
            this.undoManager = null;
        }
    }

    public synchronized Tile transform(CoordinateTransform transform) {
        Tile transformedTile;
        boolean transformContents;
        Point transformedCoords = transform.transform(this.x << 7, this.y << 7);
        boolean bl = transformContents = (transformedCoords.x & 0x7F) != 0 || (transformedCoords.y & 0x7F) != 0;
        if (transformContents) {
            transformedTile = new Tile(transformedCoords.x >> 7, transformedCoords.y >> 7, this.minHeight, this.maxHeight);
            for (int x = 0; x < 128; ++x) {
                for (int y = 0; y < 128; ++y) {
                    transformedCoords.x = x;
                    transformedCoords.y = y;
                    transform.transformInPlace(transformedCoords);
                    transformedCoords.x &= 0x7F;
                    transformedCoords.y &= 0x7F;
                    transformedTile.setTerrain(transformedCoords.x, transformedCoords.y, this.getTerrain(x, y));
                    transformedTile.setRawHeight(transformedCoords.x, transformedCoords.y, this.getRawHeight(x, y));
                    transformedTile.setWaterLevel(transformedCoords.x, transformedCoords.y, this.getWaterLevel(x, y));
                }
            }
            for (Layer layer : this.getLayers()) {
                int y;
                int x;
                if (layer.getDataSize() == Layer.DataSize.BIT || layer.getDataSize() == Layer.DataSize.BIT_PER_CHUNK) {
                    for (x = 0; x < 128; ++x) {
                        for (y = 0; y < 128; ++y) {
                            if (!this.getBitLayerValue(layer, x, y)) continue;
                            transformedCoords.x = x;
                            transformedCoords.y = y;
                            transform.transformInPlace(transformedCoords);
                            transformedCoords.x &= 0x7F;
                            transformedCoords.y &= 0x7F;
                            transformedTile.setBitLayerValue(layer, transformedCoords.x, transformedCoords.y, true);
                        }
                    }
                    continue;
                }
                if (layer.getDataSize() == Layer.DataSize.NONE) continue;
                for (x = 0; x < 128; ++x) {
                    for (y = 0; y < 128; ++y) {
                        int value = this.getLayerValue(layer, x, y);
                        if (value <= 0) continue;
                        transformedCoords.x = x;
                        transformedCoords.y = y;
                        transform.transformInPlace(transformedCoords);
                        transformedCoords.x &= 0x7F;
                        transformedCoords.y &= 0x7F;
                        transformedTile.setLayerValue(layer, transformedCoords.x, transformedCoords.y, value);
                    }
                }
            }
        } else {
            transformedTile = new Tile(transformedCoords.x >> 7, transformedCoords.y >> 7, this.minHeight, this.maxHeight, false);
            transformedTile.heightMap = (short[])ObjectUtils.copyObject((Object)this.heightMap);
            transformedTile.tallHeightMap = (int[])ObjectUtils.copyObject((Object)this.tallHeightMap);
            transformedTile.terrain = (byte[])this.terrain.clone();
            transformedTile.waterLevel = (byte[])ObjectUtils.copyObject((Object)this.waterLevel);
            transformedTile.tallWaterLevel = (short[])ObjectUtils.copyObject((Object)this.tallWaterLevel);
            transformedTile.layerData = (Map)ObjectUtils.copyObject(this.layerData);
            transformedTile.bitLayerData = (Map)ObjectUtils.copyObject(this.bitLayerData);
            transformedTile.init();
        }
        if (this.seeds != null) {
            transformedTile.seeds = new HashSet();
            transformedTile.seeds.addAll(this.seeds);
            for (Seed seed : transformedTile.seeds) {
                seed.transform(transform);
            }
        }
        return transformedTile;
    }

    public synchronized boolean repair(int minHeight, int maxHeight, PrintStream out) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.maxY = maxHeight - 1;
        if (maxHeight > 256) {
            this.tall = true;
            if (this.tallHeightMap == null) {
                out.println("Height map for tile " + this.x + "," + this.y + " lost");
                this.tallHeightMap = new int[16384];
            }
            if (this.tallWaterLevel == null) {
                out.println("Water level map for tile " + this.x + "," + this.y + " lost");
                this.tallWaterLevel = new short[16384];
            }
            this.heightMap = null;
            this.waterLevel = null;
        } else {
            this.tall = false;
            if (this.heightMap == null) {
                out.println("Height map for tile " + this.x + "," + this.y + " lost");
                this.heightMap = new short[16384];
            }
            if (this.waterLevel == null) {
                out.println("Water level map for tile " + this.x + "," + this.y + " lost");
                this.waterLevel = new byte[16384];
            }
            this.tallHeightMap = null;
            this.tallWaterLevel = null;
        }
        if (this.terrain == null) {
            out.println("Terrain type map for tile " + this.x + "," + this.y + " lost");
            this.terrain = new byte[16384];
        }
        if (this.layerData == null) {
            out.println("Non-bit valued layer data for tile " + this.x + "," + this.y + " lost");
            this.layerData = new HashMap<Layer, byte[]>();
        }
        if (this.bitLayerData == null) {
            out.println("Bit valued layer data for tile " + this.x + "," + this.y + " lost");
            this.bitLayerData = new HashMap<Layer, BitSet>();
        }
        this.init();
        return true;
    }

    public synchronized boolean containsOneOf(Layer ... layers) {
        boolean bitLayersAvailable = false;
        boolean nonBitLayersAvailable = false;
        block4: for (Layer layer : layers) {
            switch (layer.getDataSize()) {
                case BIT: 
                case BIT_PER_CHUNK: {
                    if (!bitLayersAvailable) {
                        this.ensureReadable(TileBuffer.BIT_LAYER_DATA);
                        bitLayersAvailable = true;
                    }
                    if (!this.bitLayerData.containsKey(layer)) continue block4;
                    return true;
                }
                case NIBBLE: 
                case BYTE: {
                    if (!nonBitLayersAvailable) {
                        this.ensureReadable(TileBuffer.LAYER_DATA);
                        nonBitLayersAvailable = true;
                    }
                    if (!this.layerData.containsKey(layer)) continue block4;
                    return true;
                }
                default: {
                    throw new IllegalArgumentException("Data size " + (Object)((Object)layer.getDataSize()) + " not supported");
                }
            }
        }
        return false;
    }

    public synchronized void savePointArmed() {
        if (logger.isTraceEnabled()) {
            logger.trace("Save point armed; clearing writable buffers");
        }
        this.writeableBuffers.clear();
    }

    public synchronized void savePointCreated() {
        if (logger.isTraceEnabled()) {
            logger.trace("Save point created; clearing writable buffers");
        }
        this.writeableBuffers.clear();
    }

    public void undoPerformed() {
    }

    public void redoPerformed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bufferChanged(BufferKey<?> key) {
        TileUndoBufferKey tileKey = (TileUndoBufferKey)key;
        if (logger.isTraceEnabled()) {
            logger.trace("Buffer " + key + " changed; clearing buffer cache for type " + (Object)((Object)tileKey.buffer) + " and notifying listeners");
        }
        Tile tile = this;
        synchronized (tile) {
            switch (tileKey.buffer) {
                case BIT_LAYER_DATA: {
                    this.readableBuffers.remove((Object)TileBuffer.BIT_LAYER_DATA);
                    this.writeableBuffers.remove((Object)TileBuffer.BIT_LAYER_DATA);
                    this.cachedLayers = null;
                    break;
                }
                case HEIGHTMAP: {
                    this.readableBuffers.remove((Object)TileBuffer.HEIGHTMAP);
                    this.writeableBuffers.remove((Object)TileBuffer.HEIGHTMAP);
                    break;
                }
                case TALL_HEIGHTMAP: {
                    this.readableBuffers.remove((Object)TileBuffer.TALL_HEIGHTMAP);
                    this.writeableBuffers.remove((Object)TileBuffer.TALL_HEIGHTMAP);
                    break;
                }
                case LAYER_DATA: {
                    this.readableBuffers.remove((Object)TileBuffer.LAYER_DATA);
                    this.writeableBuffers.remove((Object)TileBuffer.LAYER_DATA);
                    this.cachedLayers = null;
                    break;
                }
                case TERRAIN: {
                    this.readableBuffers.remove((Object)TileBuffer.TERRAIN);
                    this.writeableBuffers.remove((Object)TileBuffer.TERRAIN);
                    break;
                }
                case WATERLEVEL: {
                    this.readableBuffers.remove((Object)TileBuffer.WATERLEVEL);
                    this.writeableBuffers.remove((Object)TileBuffer.WATERLEVEL);
                    break;
                }
                case TALL_WATERLEVEL: {
                    this.readableBuffers.remove((Object)TileBuffer.TALL_WATERLEVEL);
                    this.writeableBuffers.remove((Object)TileBuffer.TALL_WATERLEVEL);
                    break;
                }
                case SEEDS: {
                    this.readableBuffers.remove((Object)TileBuffer.SEEDS);
                    this.writeableBuffers.remove((Object)TileBuffer.SEEDS);
                }
            }
        }
        switch (tileKey.buffer) {
            case BIT_LAYER_DATA: {
                this.allBitLayerDataChanged();
                break;
            }
            case HEIGHTMAP: 
            case TALL_HEIGHTMAP: {
                this.heightMapChanged();
                break;
            }
            case LAYER_DATA: {
                this.allNonBitLayerDataChanged();
                break;
            }
            case TERRAIN: {
                this.terrainChanged();
                break;
            }
            case WATERLEVEL: 
            case TALL_WATERLEVEL: {
                this.waterLevelChanged();
                break;
            }
            case SEEDS: {
                this.seedsChanged();
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tile other = (Tile)obj;
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + this.x;
        hash = 17 * hash + this.y;
        return hash;
    }

    public String toString() {
        return "Tile[x=" + this.x + ",y=" + this.y + "]";
    }

    synchronized void ensureAllReadable() {
        if (this.tall) {
            this.ensureReadable(TileBuffer.TALL_HEIGHTMAP);
            this.ensureReadable(TileBuffer.TALL_WATERLEVEL);
        } else {
            this.ensureReadable(TileBuffer.HEIGHTMAP);
            this.ensureReadable(TileBuffer.WATERLEVEL);
        }
        this.ensureReadable(TileBuffer.TERRAIN);
        this.ensureReadable(TileBuffer.LAYER_DATA);
        this.ensureReadable(TileBuffer.BIT_LAYER_DATA);
        this.ensureReadable(TileBuffer.SEEDS);
    }

    synchronized void convertBiomeData() {
        byte[] biomeData = this.layerData.remove(Biome.INSTANCE);
        if (biomeData != null) {
            byte[] newBiomeData = new byte[biomeData.length * 2];
            for (int i = 0; i < biomeData.length; ++i) {
                newBiomeData[i * 2] = (byte)(biomeData[i] & 0xF);
                newBiomeData[i * 2 + 1] = (byte)((biomeData[i] & 0xF0) >> 4);
            }
            this.layerData.put(Biome.INSTANCE, newBiomeData);
        }
    }

    synchronized void prepareForSaving() {
        Map.Entry<Layer, BitSet> entry;
        this.ensureAllReadable();
        Iterator<Map.Entry<Layer, BitSet>> i = this.bitLayerData.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            if (!entry.getValue().isEmpty()) continue;
            i.remove();
            this.cachedLayers = null;
        }
        i = this.layerData.entrySet().iterator();
        block1: while (i.hasNext()) {
            byte defaultByte;
            entry = i.next();
            Layer layer = entry.getKey();
            byte[] buffer = (byte[])entry.getValue();
            if (layer.getDataSize() == Layer.DataSize.NIBBLE) {
                defaultByte = (byte)(layer.getDefaultValue() << 4 | layer.getDefaultValue());
                for (byte bufferByte : buffer) {
                    if (bufferByte != defaultByte) continue block1;
                }
                i.remove();
                this.cachedLayers = null;
                continue;
            }
            if (layer.getDataSize() != Layer.DataSize.BYTE) continue;
            defaultByte = (byte)layer.getDefaultValue();
            for (byte bufferByte : buffer) {
                if (bufferByte != defaultByte) continue block1;
            }
            i.remove();
            this.cachedLayers = null;
        }
    }

    private boolean getBitPerBlockLayerValue(BitSet bitSet, int x, int y) {
        return bitSet.get(x | y << 7);
    }

    private boolean getBitPerChunkLayerValue(BitSet bitSet, int x, int y) {
        return bitSet.get((x >> 4) + (y >> 4) * 8);
    }

    private void registerUndoBuffers() {
        if (this.tall) {
            this.undoManager.addBuffer(this.TALL_HEIGHTMAP_BUFFER_KEY, (Object)this.tallHeightMap, (UndoListener)this);
            this.undoManager.addBuffer(this.TALL_WATERLEVEL_BUFFER_KEY, (Object)this.tallWaterLevel, (UndoListener)this);
            this.readableBuffers = EnumSet.of(TileBuffer.TALL_HEIGHTMAP, TileBuffer.TALL_WATERLEVEL, TileBuffer.TERRAIN, TileBuffer.LAYER_DATA, TileBuffer.BIT_LAYER_DATA);
            this.writeableBuffers = EnumSet.of(TileBuffer.TALL_HEIGHTMAP, TileBuffer.TALL_WATERLEVEL, TileBuffer.TERRAIN, TileBuffer.LAYER_DATA, TileBuffer.BIT_LAYER_DATA);
        } else {
            this.undoManager.addBuffer(this.HEIGHTMAP_BUFFER_KEY, (Object)this.heightMap, (UndoListener)this);
            this.undoManager.addBuffer(this.WATERLEVEL_BUFFER_KEY, (Object)this.waterLevel, (UndoListener)this);
            this.readableBuffers = EnumSet.of(TileBuffer.HEIGHTMAP, TileBuffer.WATERLEVEL, TileBuffer.TERRAIN, TileBuffer.LAYER_DATA, TileBuffer.BIT_LAYER_DATA);
            this.writeableBuffers = EnumSet.of(TileBuffer.HEIGHTMAP, TileBuffer.WATERLEVEL, TileBuffer.TERRAIN, TileBuffer.LAYER_DATA, TileBuffer.BIT_LAYER_DATA);
        }
        this.undoManager.addBuffer(this.TERRAIN_BUFFER_KEY, (Object)this.terrain, (UndoListener)this);
        this.undoManager.addBuffer(this.LAYER_DATA_BUFFER_KEY, this.layerData, (UndoListener)this);
        this.undoManager.addBuffer(this.BIT_LAYER_DATA_BUFFER_KEY, this.bitLayerData, (UndoListener)this);
        if (this.seeds != null) {
            this.undoManager.addBuffer(this.SEEDS_BUFFER_KEY, this.seeds, (UndoListener)this);
            this.readableBuffers.add(TileBuffer.SEEDS);
            this.writeableBuffers.add(TileBuffer.SEEDS);
        }
    }

    private void unregisterUndoBuffers() {
        if (this.tall) {
            this.ensureReadable(TileBuffer.TALL_HEIGHTMAP);
            this.undoManager.removeBuffer(this.TALL_HEIGHTMAP_BUFFER_KEY);
            this.ensureReadable(TileBuffer.TALL_WATERLEVEL);
            this.undoManager.removeBuffer(this.TALL_WATERLEVEL_BUFFER_KEY);
        } else {
            this.ensureReadable(TileBuffer.HEIGHTMAP);
            this.undoManager.removeBuffer(this.HEIGHTMAP_BUFFER_KEY);
            this.ensureReadable(TileBuffer.WATERLEVEL);
            this.undoManager.removeBuffer(this.WATERLEVEL_BUFFER_KEY);
        }
        this.ensureReadable(TileBuffer.TERRAIN);
        this.undoManager.removeBuffer(this.TERRAIN_BUFFER_KEY);
        this.ensureReadable(TileBuffer.LAYER_DATA);
        this.undoManager.removeBuffer(this.LAYER_DATA_BUFFER_KEY);
        this.ensureReadable(TileBuffer.BIT_LAYER_DATA);
        this.undoManager.removeBuffer(this.BIT_LAYER_DATA_BUFFER_KEY);
        if (this.seeds != null) {
            this.ensureReadable(TileBuffer.SEEDS);
            this.undoManager.removeBuffer(this.SEEDS_BUFFER_KEY);
        }
        this.writeableBuffers = null;
        this.readableBuffers = null;
    }

    protected synchronized void ensureReadable(TileBuffer buffer) {
        if (this.undoManager != null && !this.readableBuffers.contains((Object)buffer)) {
            switch (buffer) {
                case HEIGHTMAP: {
                    this.heightMap = (short[])this.undoManager.getBuffer(this.HEIGHTMAP_BUFFER_KEY);
                    break;
                }
                case TALL_HEIGHTMAP: {
                    this.tallHeightMap = (int[])this.undoManager.getBuffer(this.TALL_HEIGHTMAP_BUFFER_KEY);
                    break;
                }
                case TERRAIN: {
                    this.terrain = (byte[])this.undoManager.getBuffer(this.TERRAIN_BUFFER_KEY);
                    break;
                }
                case WATERLEVEL: {
                    this.waterLevel = (byte[])this.undoManager.getBuffer(this.WATERLEVEL_BUFFER_KEY);
                    break;
                }
                case TALL_WATERLEVEL: {
                    this.tallWaterLevel = (short[])this.undoManager.getBuffer(this.TALL_WATERLEVEL_BUFFER_KEY);
                    break;
                }
                case LAYER_DATA: {
                    this.layerData = (Map)this.undoManager.getBuffer(this.LAYER_DATA_BUFFER_KEY);
                    break;
                }
                case BIT_LAYER_DATA: {
                    this.bitLayerData = (Map)this.undoManager.getBuffer(this.BIT_LAYER_DATA_BUFFER_KEY);
                    break;
                }
                case SEEDS: {
                    this.seeds = (HashSet)this.undoManager.getBuffer(this.SEEDS_BUFFER_KEY);
                }
            }
            this.readableBuffers.add(buffer);
        }
    }

    private void ensureWriteable(TileBuffer buffer) {
        if (this.undoManager != null && !this.writeableBuffers.contains((Object)buffer)) {
            switch (buffer) {
                case HEIGHTMAP: {
                    this.heightMap = (short[])this.undoManager.getBufferForEditing(this.HEIGHTMAP_BUFFER_KEY);
                    break;
                }
                case TALL_HEIGHTMAP: {
                    this.tallHeightMap = (int[])this.undoManager.getBufferForEditing(this.TALL_HEIGHTMAP_BUFFER_KEY);
                    break;
                }
                case TERRAIN: {
                    this.terrain = (byte[])this.undoManager.getBufferForEditing(this.TERRAIN_BUFFER_KEY);
                    break;
                }
                case WATERLEVEL: {
                    this.waterLevel = (byte[])this.undoManager.getBufferForEditing(this.WATERLEVEL_BUFFER_KEY);
                    break;
                }
                case TALL_WATERLEVEL: {
                    this.tallWaterLevel = (short[])this.undoManager.getBufferForEditing(this.TALL_WATERLEVEL_BUFFER_KEY);
                    break;
                }
                case LAYER_DATA: {
                    this.layerData = (Map)this.undoManager.getBufferForEditing(this.LAYER_DATA_BUFFER_KEY);
                    break;
                }
                case BIT_LAYER_DATA: {
                    this.bitLayerData = (Map)this.undoManager.getBufferForEditing(this.BIT_LAYER_DATA_BUFFER_KEY);
                    break;
                }
                case SEEDS: {
                    this.seeds = (HashSet)this.undoManager.getBufferForEditing(this.SEEDS_BUFFER_KEY);
                }
            }
            this.readableBuffers.add(buffer);
            this.writeableBuffers.add(buffer);
        }
    }

    private void heightMapChanged() {
        if (this.eventInhibitionCounter != 0) {
            this.heightMapDirty = true;
        } else {
            for (Listener listener : this.listeners) {
                listener.heightMapChanged(this);
            }
        }
    }

    private void terrainChanged() {
        if (this.eventInhibitionCounter != 0) {
            this.terrainDirty = true;
        } else {
            for (Listener listener : this.listeners) {
                listener.terrainChanged(this);
            }
        }
    }

    private void waterLevelChanged() {
        if (this.eventInhibitionCounter != 0) {
            this.waterLevelDirty = true;
        } else {
            for (Listener listener : this.listeners) {
                listener.waterLevelChanged(this);
            }
        }
    }

    private void layerDataChanged(Layer layer) {
        if (this.eventInhibitionCounter != 0) {
            this.dirtyLayers.add(layer);
        } else {
            Set<Layer> changedLayers = Collections.singleton(layer);
            for (Listener listener : this.listeners) {
                listener.layerDataChanged(this, changedLayers);
            }
        }
    }

    private void allBitLayerDataChanged() {
        if (this.eventInhibitionCounter != 0) {
            this.bitLayersDirty = true;
        } else {
            for (Listener listener : this.listeners) {
                listener.allBitLayerDataChanged(this);
            }
        }
    }

    private void allNonBitLayerDataChanged() {
        if (this.eventInhibitionCounter != 0) {
            this.nonBitLayersDirty = true;
        } else {
            for (Listener listener : this.listeners) {
                listener.allNonBitlayerDataChanged(this);
            }
        }
    }

    private void seedsChanged() {
        if (this.eventInhibitionCounter != 0) {
            this.seedsDirty = true;
        } else {
            for (Listener listener : this.listeners) {
                listener.seedsChanged(this);
            }
        }
    }

    private float clamp(float level) {
        if (level < (float)this.minHeight) {
            return this.minHeight;
        }
        if (level > (float)this.maxY) {
            return this.maxY;
        }
        return level;
    }

    private int clamp(int level) {
        if (level < this.minHeight) {
            return this.minHeight;
        }
        if (level > this.maxY) {
            return this.maxY;
        }
        return level;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        this.prepareForSaving();
        out.defaultWriteObject();
    }

    private void init() {
        this.listeners = new ArrayList<Listener>();
        this.HEIGHTMAP_BUFFER_KEY = new TileUndoBufferKey<short[]>(this, TileBuffer.HEIGHTMAP);
        this.TALL_HEIGHTMAP_BUFFER_KEY = new TileUndoBufferKey<int[]>(this, TileBuffer.TALL_HEIGHTMAP);
        this.TERRAIN_BUFFER_KEY = new TileUndoBufferKey<byte[]>(this, TileBuffer.TERRAIN);
        this.WATERLEVEL_BUFFER_KEY = new TileUndoBufferKey<byte[]>(this, TileBuffer.WATERLEVEL);
        this.TALL_WATERLEVEL_BUFFER_KEY = new TileUndoBufferKey<short[]>(this, TileBuffer.TALL_WATERLEVEL);
        this.LAYER_DATA_BUFFER_KEY = new TileUndoBufferKey<Map<Layer, byte[]>>(this, TileBuffer.LAYER_DATA);
        this.BIT_LAYER_DATA_BUFFER_KEY = new TileUndoBufferKey<Map<Layer, BitSet>>(this, TileBuffer.BIT_LAYER_DATA);
        this.SEEDS_BUFFER_KEY = new TileUndoBufferKey<HashSet<Seed>>(this, TileBuffer.SEEDS);
        this.dirtyLayers = new HashSet<Layer>();
        this.maxY = this.maxHeight - 1;
        if (this.maxHeight == 0) {
            this.maxHeight = 128;
            this.tall = false;
        }
        if (this.seeds != null && this.seeds.isEmpty()) {
            this.seeds = null;
        }
    }

    public static enum TileBuffer {
        HEIGHTMAP,
        TERRAIN,
        WATERLEVEL,
        LAYER_DATA,
        BIT_LAYER_DATA,
        TALL_HEIGHTMAP,
        TALL_WATERLEVEL,
        SEEDS;

    }

    static class TileUndoBufferKey<T>
    implements BufferKey<T> {
        final Tile tile;
        final TileBuffer buffer;

        public TileUndoBufferKey(Tile tile, TileBuffer buffer) {
            this.tile = tile;
            this.buffer = buffer;
        }

        public boolean equals(Object obj) {
            return obj instanceof TileUndoBufferKey && this.tile == ((TileUndoBufferKey)obj).tile && this.buffer == ((TileUndoBufferKey)obj).buffer;
        }

        public int hashCode() {
            return (31 + System.identityHashCode(this.tile)) * 31 + this.buffer.hashCode();
        }

        public String toString() {
            return "[" + this.tile.x + ", " + this.tile.y + ", " + (Object)((Object)this.buffer) + "]";
        }
    }

    public static interface Listener {
        public void heightMapChanged(Tile var1);

        public void terrainChanged(Tile var1);

        public void waterLevelChanged(Tile var1);

        public void layerDataChanged(Tile var1, Set<Layer> var2);

        public void allBitLayerDataChanged(Tile var1);

        public void allNonBitlayerDataChanged(Tile var1);

        public void seedsChanged(Tile var1);
    }
}

