/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import com.google.common.collect.ImmutableSet;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.IconUtils;
import org.pepsoft.util.MathUtils;
import org.pepsoft.util.PerlinNoise;
import org.pepsoft.util.RandomField;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.CustomTerrainHelper;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.layers.plants.Plant;
import org.pepsoft.worldpainter.layers.plants.Plants;
import org.pepsoft.worldpainter.objects.GenericObject;
import org.pepsoft.worldpainter.objects.WPObject;

public enum Terrain {
    GRASS("Grass", Material.GRASS_BLOCK, Material.GRASS_BLOCK, "grass with flowers, tall grass and ferns here and there, and seagrass and kelp under water", 1){
        private final PerlinNoise dandelionNoise = new PerlinNoise(0L);
        private final PerlinNoise roseNoise = new PerlinNoise(0L);
        private final PerlinNoise grassNoise = new PerlinNoise(0L);
        private final RandomField flowerTypeField = new RandomField(4, (double)16.411f, 0L);
        private final PerlinNoise tallGrassNoise = new PerlinNoise(0L);
        private final Plant[] FLOWER_TYPES = new Plant[]{Plants.DANDELION, Plants.POPPY, Plants.BLUE_ORCHID, Plants.ALLIUM, Plants.AZURE_BLUET, Plants.TULIP_RED, Plants.TULIP_ORANGE, Plants.TULIP_WHITE, Plants.TULIP_PINK, Plants.OXEYE_DAISY, Plants.SUNFLOWER, Plants.LILAC, Plants.ROSE_BUSH, Plants.PEONY, Plants.DANDELION, Plants.POPPY};
        private static final long DANDELION_SEED_OFFSET = 145351781L;
        private static final long ROSE_SEED_OFFSET = 28286488L;
        private static final long GRASS_SEED_OFFSET = 169191195L;
        private static final long FLOWER_TYPE_FIELD_OFFSET = 65226710L;
        private static final long DOUBLE_TALL_GRASS_SEED_OFFSET = 31695680L;
        private static final int FLOWER_INCIDENCE = 10;

        @Override
        public WPObject getSurfaceObject(Platform platform, long seed, int x, int y, int waterBlocksAbove) {
            Random rnd = new Random(seed + (long)x * 65537L + (long)y * 4099L);
            int rndNr = rnd.nextInt(10);
            if (waterBlocksAbove > 0 && platform.capabilities.contains((Object)Platform.Capability.NAME_BASED)) {
                float grassValue;
                if (this.grassNoise.getSeed() != seed + 169191195L) {
                    this.grassNoise.setSeed(seed + 169191195L);
                    this.tallGrassNoise.setSeed(seed + 31695680L);
                }
                if ((grassValue = this.grassNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), 0.06093474105000496) + (rnd.nextFloat() * 0.3f - 0.15f)) > GRASS_CHANCE) {
                    if (this.tallGrassNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), 0.06093474105000496) > 0.0f) {
                        if (grassValue > DOUBLE_TALL_GRASS_CHANCE) {
                            return Plants.KELP.realise(rnd.nextInt(Math.min(waterBlocksAbove, 26)) + 1, platform);
                        }
                        if (rnd.nextInt(4) == 0 || waterBlocksAbove < 2) {
                            return Plants.SEAGRASS.realise(1, platform);
                        }
                        return Plants.TALL_SEAGRASS.realise(1, platform);
                    }
                    if (grassValue > FERN_CHANCE && waterBlocksAbove >= 2) {
                        return Plants.TALL_SEAGRASS.realise(1, platform);
                    }
                    return Plants.SEAGRASS.realise(1, platform);
                }
            } else if (waterBlocksAbove == 0) {
                if (rndNr == 0) {
                    if (this.dandelionNoise.getSeed() != seed + 145351781L) {
                        this.dandelionNoise.setSeed(seed + 145351781L);
                        this.roseNoise.setSeed(seed + 28286488L);
                        this.flowerTypeField.setSeed(seed + 65226710L);
                    }
                    if (this.dandelionNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), 0.06093474105000496) > FLOWER_CHANCE || this.roseNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), 0.06093474105000496) > FLOWER_CHANCE) {
                        return this.FLOWER_TYPES[this.flowerTypeField.getValue(x, y)].realise(1, platform);
                    }
                } else {
                    float grassValue;
                    if (this.grassNoise.getSeed() != seed + 169191195L) {
                        this.grassNoise.setSeed(seed + 169191195L);
                        this.tallGrassNoise.setSeed(seed + 31695680L);
                    }
                    if ((grassValue = this.grassNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), 0.06093474105000496) + (rnd.nextFloat() * 0.3f - 0.15f)) > GRASS_CHANCE) {
                        if (this.tallGrassNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), 0.06093474105000496) > 0.0f) {
                            if (grassValue > DOUBLE_TALL_GRASS_CHANCE) {
                                if (rnd.nextInt(4) == 0) {
                                    return Plants.LARGE_FERN.realise(1, platform);
                                }
                                return Plants.TALL_GRASS.realise(1, platform);
                            }
                            if (rnd.nextInt(4) == 0) {
                                return Plants.FERN.realise(1, platform);
                            }
                            return Plants.GRASS.realise(1, platform);
                        }
                        if (grassValue > FERN_CHANCE) {
                            return Plants.FERN.realise(1, platform);
                        }
                        return Plants.GRASS.realise(1, platform);
                    }
                }
            }
            return null;
        }
    }
    ,
    DIRT("Dirt", 3, 3, "bare dirt", 1),
    SAND("Sand", 12, 12, "bare sand", 1),
    SANDSTONE("Sandstone", 24, 24, "sandstone", 1),
    STONE("Stone", 1, 1, "bare stone", 1),
    ROCK("Rock", "a mix of stone and cobblestone", 1){
        private final PerlinNoise perlinNoise = new PerlinNoise(0L);
        private static final int STONE_SEED_OFFSET = 188434540;

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            int dz = z - height;
            if (dz > 0) {
                return Material.AIR;
            }
            if (this.perlinNoise.getSeed() != seed + 188434540L) {
                this.perlinNoise.setSeed(seed + 188434540L);
            }
            if (this.perlinNoise.getPerlinNoise((double)((float)x / 4.099f), (double)((float)y / 4.099f), (double)((float)z / 4.099f)) > 0.0f) {
                return Material.STONE;
            }
            return Material.COBBLESTONE;
        }
    }
    ,
    WATER("Water", Material.STATIONARY_WATER, Material.STATIONARY_WATER, "\u26a0 water instead of terrain (NOTE: you may want the Flood tool instead!)", 7),
    LAVA("Lava", Material.STATIONARY_LAVA, Material.STATIONARY_LAVA, "\u26a0 lava instead of terrain (NOTE: you may want the Lava tool instead!)", 1),
    SNOW("Snow on Rock", "[DEPRECATED] a thin layer of snow on a mix of stone and cobblestone", 12, 1){
        private final PerlinNoise perlinNoise = new PerlinNoise(0L);
        private final WPObject OBJECT_SNOW = new GenericObject("Snow", 1, 1, 1, new Material[]{Material.SNOW});
        private static final int STONE_SEED_OFFSET = 188434540;

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            if (this.perlinNoise.getSeed() != seed + 188434540L) {
                this.perlinNoise.setSeed(seed + 188434540L);
            }
            if (this.perlinNoise.getPerlinNoise((double)((float)x / 4.099f), (double)((float)y / 4.099f), (double)((float)z / 4.099f)) > 0.0f) {
                return Material.STONE;
            }
            return Material.COBBLESTONE;
        }

        @Override
        public WPObject getSurfaceObject(Platform platform, long seed, int x, int y, int waterBlocksAbove) {
            return waterBlocksAbove == 0 ? this.OBJECT_SNOW : null;
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return colourScheme.getColour(Material.SNOW);
        }
    }
    ,
    DEEP_SNOW("Deep Snow", 80, 80, "\u26a0 snow blocks instead of terrain (NOTE: you may want the Frost layer instead!)", 12),
    GRAVEL("Gravel", 13, 13, "gravel", 1),
    CLAY("Clay", 82, 82, "clay", 1),
    COBBLESTONE("Cobblestone", 4, 4, "cobblestone", 1),
    MOSSY_COBBLESTONE("Mossy Cobblestone", 48, 48, "mossy cobblestone", 1),
    NETHERRACK("Netherrack", 87, 87, "netherrack", 1),
    SOUL_SAND("Soul Sand", 88, 88, "soul sand", 8),
    OBSIDIAN("Obsidian", 49, 49, "extremely tough volcanic glass", 1),
    BEDROCK("Bedrock", 7, 7, "unbreakable bedrock", 1),
    DESERT("Desert", Material.SAND, Material.SAND, "sand with here and there a cactus or dead shrub", 2){
        private static final int CACTUS_CHANCE = 1000;

        @Override
        public WPObject getSurfaceObject(Platform platform, long seed, int x, int y, int waterBlocksAbove) {
            int cactusHeight;
            if (waterBlocksAbove > 0) {
                return null;
            }
            int rnd = new Random(seed + (long)x * 65537L + (long)y * 4099L).nextInt(1000);
            boolean shrub = false;
            if (rnd < 3) {
                cactusHeight = rnd + 1;
            } else {
                cactusHeight = 0;
                if (rnd < 6) {
                    shrub = true;
                }
            }
            if (shrub) {
                return Plants.DEAD_SHRUB.realise(1, platform);
            }
            if (cactusHeight == 0) {
                return null;
            }
            return Plants.CACTUS.realise(cactusHeight, platform);
        }
    }
    ,
    NETHERLIKE("Netherlike", "netherrack with pockets of lava, soul sand and glowstone and patches of fire on top", 8, 1){
        private final PerlinNoise glowstoneNoise = new PerlinNoise(0L);
        private final PerlinNoise soulSandNoise = new PerlinNoise(0L);
        private final PerlinNoise lavaNoise = new PerlinNoise(0L);
        private final WPObject OBJECT_FIRE = new GenericObject("Fire", 1, 1, 1, new Material[]{Material.FIRE});
        private static final int GLOWSTONE_SEED_OFFSET = 57861047;
        private static final int LAVA_SEED_OFFSET = 189831882;
        private static final int SOUL_SAND_SEED_OFFSET = 81867522;
        private static final int FIRE_CHANCE = 150;

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            if (this.glowstoneNoise.getSeed() != seed + 57861047L) {
                this.glowstoneNoise.setSeed(seed + 57861047L);
                this.soulSandNoise.setSeed(seed + 81867522L);
                this.lavaNoise.setSeed(seed + 189831882L);
            }
            if ((double)this.glowstoneNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), (double)((float)z / 16.411f)) > 0.4) {
                return Material.GLOWSTONE;
            }
            if ((double)this.soulSandNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), (double)((float)z / 16.411f)) > 0.4) {
                return Material.SOUL_SAND;
            }
            if ((double)this.lavaNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), (double)((float)z / 16.411f)) > 0.4) {
                return Material.LAVA;
            }
            return Material.NETHERRACK;
        }

        @Override
        public WPObject getSurfaceObject(Platform platform, long seed, int x, int y, int waterBlocksAbove) {
            if (waterBlocksAbove > 0) {
                return null;
            }
            int rnd = new Random(seed + (long)x * 65537L + (long)y * 4099L).nextInt(150);
            if (rnd == 0) {
                return this.OBJECT_FIRE;
            }
            return null;
        }
    }
    ,
    RESOURCES("Resources", "stone on the surface with pockets of coal, ores, gravel and dirt, lava and water, etc.", 1){
        private final PerlinNoise goldNoise = new PerlinNoise(0L);
        private final PerlinNoise ironNoise = new PerlinNoise(0L);
        private final PerlinNoise coalNoise = new PerlinNoise(0L);
        private final PerlinNoise lapisLazuliNoise = new PerlinNoise(0L);
        private final PerlinNoise diamondNoise = new PerlinNoise(0L);
        private final PerlinNoise redstoneNoise = new PerlinNoise(0L);
        private final PerlinNoise waterNoise = new PerlinNoise(0L);
        private final PerlinNoise lavaNoise = new PerlinNoise(0L);
        private final PerlinNoise dirtNoise = new PerlinNoise(0L);
        private final PerlinNoise gravelNoise = new PerlinNoise(0L);
        private static final long GOLD_SEED_OFFSET = 148503743L;
        private static final long IRON_SEED_OFFSET = 171021655L;
        private static final long COAL_SEED_OFFSET = 81779663L;
        private static final long LAPIS_LAZULI_SEED_OFFSET = 174377337L;
        private static final long DIAMOND_SEED_OFFSET = 14554756L;
        private static final long REDSTONE_SEED_OFFSET = 48636151L;
        private static final long WATER_SEED_OFFSET = 42845153L;
        private static final long LAVA_SEED_OFFSET = 62452072L;
        private static final long DIRT_SEED_OFFSET = 193567846L;
        private static final long GRAVEL_SEED_OFFSET = 19951397L;

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            if (this.goldNoise.getSeed() != seed + 148503743L) {
                this.goldNoise.setSeed(seed + 148503743L);
                this.ironNoise.setSeed(seed + 171021655L);
                this.coalNoise.setSeed(seed + 81779663L);
                this.lapisLazuliNoise.setSeed(seed + 174377337L);
                this.diamondNoise.setSeed(seed + 14554756L);
                this.redstoneNoise.setSeed(seed + 48636151L);
                this.waterNoise.setSeed(seed + 42845153L);
                this.lavaNoise.setSeed(seed + 62452072L);
                this.dirtNoise.setSeed(seed + 193567846L);
                this.gravelNoise.setSeed(seed + 19951397L);
            }
            double dx = (float)x / 4.099f;
            double dy = (float)y / 4.099f;
            double dz = (float)z / 4.099f;
            double dirtX = (float)x / 16.411f;
            double dirtY = (float)y / 16.411f;
            double dirtZ = (float)z / 16.411f;
            if (z <= Integer.MAX_VALUE && this.coalNoise.getPerlinNoise(dx, dy, dz) >= COAL_CHANCE) {
                return Material.COAL;
            }
            if (z <= Integer.MAX_VALUE && this.dirtNoise.getPerlinNoise(dirtX, dirtY, dirtZ) >= DIRT_CHANCE) {
                return Material.DIRT;
            }
            if (z <= Integer.MAX_VALUE && this.gravelNoise.getPerlinNoise(dirtX, dirtY, dirtZ) >= GRAVEL_CHANCE) {
                return Material.GRAVEL;
            }
            if (z <= 16 && this.redstoneNoise.getPerlinNoise(dx, dy, dz) >= REDSTONE_CHANCE) {
                return Material.REDSTONE_ORE;
            }
            if (z <= 48 && this.ironNoise.getPerlinNoise(dx, dy, dz) >= IRON_CHANCE) {
                return Material.IRON_ORE;
            }
            if (z <= Integer.MAX_VALUE && this.waterNoise.getPerlinNoise(dx, dy, dz) >= WATER_CHANCE) {
                return Material.WATER;
            }
            if (z <= 80 && this.lavaNoise.getPerlinNoise(dx, dy, dz) >= LAVA_CHANCE + (float)(z * z) / 65536.0f) {
                return Material.LAVA;
            }
            if (z <= 32 && this.goldNoise.getPerlinNoise(dx, dy, dz) >= GOLD_CHANCE) {
                return Material.GOLD_ORE;
            }
            if (z <= 32 && this.lapisLazuliNoise.getPerlinNoise(dx, dy, dz) >= LAPIS_LAZULI_CHANCE) {
                return Material.LAPIS_LAZULI_ORE;
            }
            if (z <= 16 && this.diamondNoise.getPerlinNoise(dx, dy, dz) >= DIAMOND_CHANCE) {
                return Material.DIAMOND_ORE;
            }
            return Material.STONE;
        }
    }
    ,
    BEACHES("Beaches", "grass with patches of sand, gravel and clay, and here and there seagrass and kelp under water", 16){
        private final PerlinNoise sandNoise = new PerlinNoise(0L);
        private final PerlinNoise clayNoise = new PerlinNoise(0L);
        private final PerlinNoise grassNoise = new PerlinNoise(0L);
        private final PerlinNoise tallGrassNoise = new PerlinNoise(0L);
        private static final long SAND_SEED_OFFSET = 26796036L;
        private static final long CLAY_SEED_OFFSET = 161603308L;
        private static final long GRASS_SEED_OFFSET = 169191195L;
        private static final long DOUBLE_TALL_GRASS_SEED_OFFSET = 31695680L;

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            float noise;
            if (this.sandNoise.getSeed() != seed + 26796036L) {
                this.sandNoise.setSeed(seed + 26796036L);
                this.clayNoise.setSeed(seed + 161603308L);
            }
            if ((noise = this.clayNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), (double)((float)z / 16.411f))) >= BEACH_CLAY_CHANCE) {
                return Material.CLAY;
            }
            noise = this.sandNoise.getPerlinNoise((double)((float)x / 131.101f), (double)((float)y / 131.101f), (double)((float)z / 16.411f));
            if ((noise += this.sandNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), (double)((float)z / 16.411f)) / 2.0f) >= BEACH_SAND_CHANCE) {
                return Material.SAND;
            }
            if (-noise >= BEACH_GRAVEL_CHANCE) {
                return Material.GRAVEL;
            }
            return Material.GRASS_BLOCK;
        }

        @Override
        public WPObject getSurfaceObject(Platform platform, long seed, int x, int y, int waterBlocksAbove) {
            if (platform.capabilities.contains((Object)Platform.Capability.NAME_BASED) && waterBlocksAbove > 0) {
                float grassValue;
                Random rnd = new Random(seed + (long)x * 65537L + (long)y * 4099L);
                if (this.grassNoise.getSeed() != seed + 169191195L) {
                    this.grassNoise.setSeed(seed + 169191195L);
                    this.tallGrassNoise.setSeed(seed + 31695680L);
                }
                if ((grassValue = this.grassNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), 0.06093474105000496) + (rnd.nextFloat() * 0.3f - 0.15f)) > GRASS_CHANCE) {
                    if (this.tallGrassNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), 0.06093474105000496) > 0.0f) {
                        if (grassValue > DOUBLE_TALL_GRASS_CHANCE) {
                            return Plants.KELP.realise(rnd.nextInt(Math.min(waterBlocksAbove, 26)) + 1, platform);
                        }
                        if (rnd.nextInt(4) == 0 || waterBlocksAbove < 2) {
                            return Plants.SEAGRASS.realise(1, platform);
                        }
                        return Plants.TALL_SEAGRASS.realise(1, platform);
                    }
                    if (grassValue > FERN_CHANCE && waterBlocksAbove >= 2) {
                        return Plants.TALL_SEAGRASS.realise(1, platform);
                    }
                    return Plants.SEAGRASS.realise(1, platform);
                }
            }
            return null;
        }
    }
    ,
    CUSTOM_1("Custom 1", "custom material one", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(0);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_2("Custom 2", "custom material two", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(1);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_3("Custom 3", "custom material three", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(2);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_4("Custom 4", "custom material four", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(3);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_5("Custom 5", "custom material five", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(4);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    MYCELIUM("Mycelium", 110, 3, "mycelium", 14),
    END_STONE("End Stone", 121, 121, "end stone", 9),
    BARE_GRASS("Bare Grass", 2, 2, "bare grass (no flowers, etc.)", 1),
    CUSTOM_6("Custom 6", "custom material six", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(5);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_7("Custom 7", "custom material seven", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(6);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_8("Custom 8", "custom material eight", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(7);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_9("Custom 9", "custom material nine", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(8);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_10("Custom 10", "custom material ten", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(9);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_11("Custom 11", "custom material eleven", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(10);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_12("Custom 12", "custom material twelve", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(11);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_13("Custom 13", "custom material thirteen", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(12);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_14("Custom 14", "custom material fourteen", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(13);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_15("Custom 15", "custom material fifteen", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(14);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_16("Custom 16", "custom material sixteen", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(15);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_17("Custom 17", "custom material seventeen", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(16);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_18("Custom 18", "custom material eighteen", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(17);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_19("Custom 19", "custom material nineteen", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(18);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_20("Custom 20", "custom material twenty", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(19);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_21("Custom 21", "custom material twenty-one", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(20);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_22("Custom 22", "custom material twenty-two", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(21);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_23("Custom 23", "custom material twenty-three", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(22);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_24("Custom 24", "custom material twenty-four", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(23);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    PERMADIRT("Coarse Dirt", Material.PERMADIRT, Material.PERMADIRT, "dirt on which no grass will grow", 1),
    PODZOL("Podzol", Material.PODZOL, Material.DIRT, "podzol", 1),
    RED_SAND("Red Sand", Material.RED_SAND, Material.RED_SAND, "red sand", 37),
    HARDENED_CLAY("Terracotta", Material.HARDENED_CLAY, Material.HARDENED_CLAY, "terracotta", 37),
    WHITE_STAINED_CLAY("White Stained Terracotta", Material.WHITE_CLAY, Material.WHITE_CLAY, "white stained terracotta", 37),
    ORANGE_STAINED_CLAY("Orange Stained Terracotta", Material.ORANGE_CLAY, Material.ORANGE_CLAY, "orange stained terracotta", 37),
    MAGENTA_STAINED_CLAY("Magenta Stained Terracotta", Material.MAGENTA_CLAY, Material.MAGENTA_CLAY, "magenta stained terracotta", 1),
    LIGHT_BLUE_STAINED_CLAY("Light Blue Stained Terracotta", Material.LIGHT_BLUE_CLAY, Material.LIGHT_BLUE_CLAY, "light blue stained terracotta", 1),
    YELLOW_STAINED_CLAY("Yellow Stained Terracotta", Material.YELLOW_CLAY, Material.YELLOW_CLAY, "yellow stained terracotta", 37),
    LIME_STAINED_CLAY("Lime Stained Terracotta", Material.LIME_CLAY, Material.LIME_CLAY, "lime stained terracotta", 1),
    PINK_STAINED_CLAY("Pink Stained Terracotta", Material.PINK_CLAY, Material.PINK_CLAY, "pink stained terracotta", 1),
    GREY_STAINED_CLAY("Grey Stained Terracotta", Material.GREY_CLAY, Material.GREY_CLAY, "grey stained terracotta", 1),
    LIGHT_GREY_STAINED_CLAY("Light Grey Stained Terracotta", Material.LIGHT_GREY_CLAY, Material.LIGHT_GREY_CLAY, "light grey stained terracotta", 37),
    CYAN_STAINED_CLAY("Cyan Stained Terracotta", Material.CYAN_CLAY, Material.CYAN_CLAY, "cyan stained terracotta", 1),
    PURPLE_STAINED_CLAY("Purple Stained Terracotta", Material.PURPLE_CLAY, Material.PURPLE_CLAY, "purple stained terracotta", 1),
    BLUE_STAINED_CLAY("Blue Stained Terracotta", Material.BLUE_CLAY, Material.BLUE_CLAY, "blue stained terracotta", 1),
    BROWN_STAINED_CLAY("Brown Stained Terracotta", Material.BROWN_CLAY, Material.BROWN_CLAY, "brown stained terracotta", 37),
    GREEN_STAINED_CLAY("Green Stained Terracotta", Material.GREEN_CLAY, Material.GREEN_CLAY, "green stained terracotta", 1),
    RED_STAINED_CLAY("Red Stained Terracotta", Material.RED_CLAY, Material.RED_CLAY, "red stained terracotta", 37),
    BLACK_STAINED_CLAY("Black Stained Terracotta", Material.BLACK_CLAY, Material.BLACK_CLAY, "black stained terracotta", 1),
    MESA("Mesa", "layers of red sand, hardened clay and stained clay, with here and there a dead shrub", 37, 1){
        private final Material[] LAYERS = new Material[64];
        private final PerlinNoise perlinNoise = new PerlinNoise(0L);
        private long seed = Long.MIN_VALUE;
        private final Material[] MATERIALS = new Material[]{Material.RED_SAND, Material.HARDENED_CLAY, Material.WHITE_CLAY, Material.LIGHT_GREY_CLAY, Material.YELLOW_CLAY, Material.ORANGE_CLAY, Material.RED_CLAY, Material.BROWN_CLAY};
        private static final int LAYER_COUNT = 64;
        private static final int SHRUB_CHANCE = 500;
        private static final long NOISE_SEED_OFFSET = 110335839L;

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.getMaterial(platform, seed, x, y, (float)z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            if (seed != this.seed) {
                this.init(seed);
            }
            return this.LAYERS[MathUtils.mod((int)((int)(z + (this.perlinNoise.getPerlinNoise((double)((float)x / 524.309f), (double)((float)y / 524.309f)) * 4.0f + this.perlinNoise.getPerlinNoise((double)((float)x / 131.101f), (double)((float)y / 131.101f)) + this.perlinNoise.getPerlinNoise((double)((float)x / 65.537f), (double)((float)y / 65.537f)) + this.perlinNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f)) / 4.0f + 3.125f) * 8.0f)), (int)64)];
        }

        @Override
        public WPObject getSurfaceObject(Platform platform, long seed, int x, int y, int waterBlocksAbove) {
            if (waterBlocksAbove > 0) {
                return null;
            }
            int rnd = new Random(seed + (long)x * 65537L + (long)y * 4099L).nextInt(500);
            if (rnd < 3) {
                return Plants.DEAD_SHRUB.realise(1, platform);
            }
            return null;
        }

        private void init(long seed) {
            this.seed = seed;
            this.perlinNoise.setSeed(seed + 110335839L);
            Random random = new Random(seed);
            Arrays.fill(this.LAYERS, Material.HARDENED_CLAY);
            for (int i = 0; i < 32; ++i) {
                Material material;
                int index = random.nextInt(63);
                this.LAYERS[index] = material = this.MATERIALS[random.nextInt(this.MATERIALS.length)];
                this.LAYERS[index + 1] = material;
            }
        }
    }
    ,
    RED_DESERT("Red Desert", Material.RED_SAND, Material.RED_SAND, "red sand with here and there a cactus or dead shrub", 37){
        private static final int CACTUS_CHANCE = 2000;

        @Override
        public WPObject getSurfaceObject(Platform platform, long seed, int x, int y, int waterBlocksAbove) {
            int cactusHeight;
            if (waterBlocksAbove > 0) {
                return null;
            }
            int rnd = new Random(seed + (long)x * 65537L + (long)y * 4099L).nextInt(2000);
            boolean shrub = false;
            if (rnd < 3) {
                cactusHeight = rnd + 1;
            } else {
                cactusHeight = 0;
                if (rnd < 12) {
                    shrub = true;
                }
            }
            if (shrub) {
                return Plants.DEAD_SHRUB.realise(1, platform);
            }
            if (cactusHeight == 0) {
                return null;
            }
            return Plants.CACTUS.realise(cactusHeight, platform);
        }
    }
    ,
    RED_SANDSTONE("Red Sandstone", 179, 179, "red sandstone", 37),
    GRANITE("Granite", Material.GRANITE, Material.GRANITE, "granite", 1),
    DIORITE("Diorite", Material.DIORITE, Material.DIORITE, "diorite", 1),
    ANDESITE("Andesite", Material.ANDESITE, Material.ANDESITE, "andesite", 1),
    STONE_MIX("Stone Mix", "stone or deepslate with patches of granite, diorite, andesite and tuff", 1){
        private final PerlinNoise graniteNoise = new PerlinNoise(0L);
        private final PerlinNoise dioriteNoise = new PerlinNoise(0L);
        private final PerlinNoise andesiteNoise = new PerlinNoise(0L);
        private static final int GRANITE_SEED_OFFSET = 145827825;
        private static final int DIORITE_SEED_OFFSET = 59606124;
        private static final int ANDESITE_SEED_OFFSET = 87772192;
        private final Random RANDOM = new Random();

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            if (this.graniteNoise.getSeed() != seed + 145827825L) {
                this.graniteNoise.setSeed(seed + 145827825L);
                this.dioriteNoise.setSeed(seed + 59606124L);
                this.andesiteNoise.setSeed(seed + 87772192L);
                this.RANDOM.setSeed(seed);
            }
            if (z >= -this.RANDOM.nextInt(5)) {
                if (this.graniteNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), (double)((float)z / 16.411f)) > GRANITE_CHANCE) {
                    return Material.GRANITE;
                }
                if (this.dioriteNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), (double)((float)z / 16.411f)) > DIORITE_CHANCE) {
                    return Material.DIORITE;
                }
                if (this.andesiteNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), (double)((float)z / 16.411f)) > ANDESITE_CHANCE) {
                    return Material.ANDESITE;
                }
                return Material.STONE;
            }
            if (this.graniteNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), (double)((float)z / 16.411f)) > GRANITE_CHANCE) {
                return Material.TUFF;
            }
            if (this.dioriteNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), (double)((float)z / 16.411f)) > DIORITE_CHANCE) {
                return Material.DEEPSLATE_X;
            }
            if (this.andesiteNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), (double)((float)z / 16.411f)) > ANDESITE_CHANCE) {
                return Material.DEEPSLATE_Z;
            }
            return Material.DEEPSLATE_Y;
        }
    }
    ,
    CUSTOM_25("Custom 25", "custom material twenty-five", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(24);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_26("Custom 26", "custom material twenty-six", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(25);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_27("Custom 27", "custom material twenty-seven", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(26);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_28("Custom 28", "custom material twenty-eight", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(27);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_29("Custom 29", "custom material twenty-nine", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(28);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_30("Custom 30", "custom material thirty", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(29);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_31("Custom 31", "custom material thirty-one", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(30);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_32("Custom 32", "custom material thirty-two", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(31);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_33("Custom 33", "custom material thirty-three", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(32);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_34("Custom 34", "custom material thirty-four", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(33);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_35("Custom 35", "custom material thirty-five", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(34);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_36("Custom 36", "custom material thirty-six", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(35);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_37("Custom 37", "custom material thirty-seven", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(36);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_38("Custom 38", "custom material thirty-eight", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(37);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_39("Custom 39", "custom material thirty-nine", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(38);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_40("Custom 40", "custom material forty", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(39);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_41("Custom 41", "custom material forty-one", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(40);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_42("Custom 42", "life, the universe and everything", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(41);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_43("Custom 43", "custom material forty-three", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(42);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_44("Custom 44", "custom material forty-four", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(43);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_45("Custom 45", "custom material forty-five", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(44);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_46("Custom 46", "custom material forty-six", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(45);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_47("Custom 47", "custom material forty-seven", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(46);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_48("Custom 48", "custom material forty-eight", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(47);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    GRASS_PATH("Dirt Path", "dirt path", 1){

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            int dz = z - height;
            if (dz == 0) {
                if (platform == DefaultPlugin.JAVA_MCREGION || platform == DefaultPlugin.JAVA_ANVIL || platform == DefaultPlugin.JAVA_ANVIL_1_15) {
                    return Material.GRASS_PATH;
                }
                return Material.DIRT_PATH;
            }
            return Material.GRASS_BLOCK;
        }
    }
    ,
    MAGMA("Magma", 213, 213, "magma", 1),
    CUSTOM_49("Custom 49", "custom material forty-nine", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(48);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_50("Custom 50", "custom material fifty", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(49);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_51("Custom 51", "custom material fifty-one", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(50);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_52("Custom 52", "custom material fifty-two", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(51);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_53("Custom 53", "custom material fifty-three", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(52);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_54("Custom 54", "custom material fifty-four", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(53);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_55("Custom 55", "custom material fifty-five", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(54);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_56("Custom 56", "custom material fifty-six", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(55);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_57("Custom 57", "custom material fifty-seven", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(56);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_58("Custom 58", "custom material fifty-eight", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(57);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_59("Custom 59", "custom material fifty-nine", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(58);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_60("Custom 60", "custom material sixty", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(59);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_61("Custom 61", "custom material sixty-one", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(60);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_62("Custom 62", "custom material sixty-two", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(61);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_63("Custom 63", "custom material sixty-three", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(62);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_64("Custom 64", "custom material sixty-four", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(63);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_65("Custom 65", "custom material sixty-five", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(64);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_66("Custom 66", "custom material sixty-six", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(65);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_67("Custom 67", "custom material sixty-seven", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(66);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_68("Custom 68", "custom material sixty-eight", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(67);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_69("Custom 69", "custom material sixty-nine", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(68);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_70("Custom 70", "custom material seventy", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(69);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_71("Custom 71", "custom material seventy-one", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(70);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_72("Custom 72", "custom material seventy-two", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(71);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_73("Custom 73", "custom material seventy-three", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(72);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_74("Custom 74", "custom material seventy-four", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(73);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_75("Custom 75", "custom material seventy-five", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(74);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_76("Custom 76", "custom material seventy-six", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(75);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_77("Custom 77", "custom material seventy-seven", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(76);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_78("Custom 78", "custom material seventy-eight", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(77);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_79("Custom 79", "custom material seventy-nine", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(78);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_80("Custom 80", "custom material eighty", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(79);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_81("Custom 81", "custom material eighty-one", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(80);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_82("Custom 82", "custom material eighty-two", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(81);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_83("Custom 83", "custom material eighty-three", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(82);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_84("Custom 84", "custom material eighty-four", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(83);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_85("Custom 85", "custom material eighty-five", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(84);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_86("Custom 86", "custom material eighty-six", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(85);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_87("Custom 87", "custom material eighty-seven", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(86);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_88("Custom 88", "custom material eighty-eight", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(87);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_89("Custom 89", "custom material eighty-nine", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(88);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_90("Custom 90", "custom material ninety", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(89);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_91("Custom 91", "custom material ninety-one", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(90);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_92("Custom 92", "custom material ninety-two", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(91);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_93("Custom 93", "custom material ninety-three", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(92);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_94("Custom 94", "custom material ninety-four", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(93);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_95("Custom 95", "custom material ninety-five", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(94);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    CUSTOM_96("Custom 96", "custom material ninety-six", 1){
        private final CustomTerrainHelper helper = new CustomTerrainHelper(95);

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
            return this.helper.getMaterial(seed, x, y, z, height);
        }

        @Override
        public String getName() {
            return this.helper.getName();
        }

        @Override
        public BufferedImage getIcon(ColourScheme colourScheme) {
            return this.helper.getIcon(colourScheme);
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public boolean isConfigured() {
            return this.helper.isConfigured();
        }

        @Override
        public int getDefaultBiome() {
            return this.helper.getDefaultBiome();
        }

        @Override
        public int getCustomTerrainIndex() {
            return this.helper.getCustomTerrainIndex();
        }

        @Override
        public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }

        @Override
        public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
            return this.helper.getColour(seed, x, y, z, height, colourScheme);
        }
    }
    ,
    DEEPSLATE("Deepslate", Material.DEEPSLATE_Y, Material.DEEPSLATE_Y, "deepslate", 1),
    TUFF("Tuff", Material.TUFF, Material.TUFF, "tuff", 1),
    BASALT("Basalt", Material.BASALT, Material.BASALT, "basalt", 8),
    BLACKSTONE("Blackstone", Material.BLACKSTONE, Material.BLACKSTONE, "blackstone", 8),
    SOUL_SOIL("Soul Soil", Material.SOUL_SOIL, Material.SOUL_SOIL, "soul soil", 8),
    WARPED_NYLIUM("Warped Nylium", Material.WARPED_NYLIUM, Material.NETHERRACK, "warped nylium", 8),
    CRIMSON_NYLIUM("Crimson Nylium", Material.CRIMSON_NYLIUM, Material.NETHERRACK, "crimson nylium", 8),
    CALCITE("Calcite", Material.CALCITE, Material.CALCITE, "calcite", 1),
    MUD("Mud", Material.MUD, Material.MUD, "mud", 1),
    BARE_BEACHES("Bare Beaches", "grass with patches of sand, gravel and clay, and no plants", 16){
        private final PerlinNoise sandNoise = new PerlinNoise(0L);
        private final PerlinNoise clayNoise = new PerlinNoise(0L);
        private static final long SAND_SEED_OFFSET = 26796036L;
        private static final long CLAY_SEED_OFFSET = 161603308L;

        @Override
        public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
            float noise;
            if (this.sandNoise.getSeed() != seed + 26796036L) {
                this.sandNoise.setSeed(seed + 26796036L);
                this.clayNoise.setSeed(seed + 161603308L);
            }
            if ((noise = this.clayNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), (double)((float)z / 16.411f))) >= BEACH_CLAY_CHANCE) {
                return Material.CLAY;
            }
            noise = this.sandNoise.getPerlinNoise((double)((float)x / 131.101f), (double)((float)y / 131.101f), (double)((float)z / 16.411f));
            if ((noise += this.sandNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), (double)((float)z / 16.411f)) / 2.0f) >= BEACH_SAND_CHANCE) {
                return Material.SAND;
            }
            if (-noise >= BEACH_GRAVEL_CHANCE) {
                return Material.GRAVEL;
            }
            return Material.GRASS_BLOCK;
        }
    }
    ,
    MOSS("Moss", Material.MOSS_BLOCK, Material.MOSS_BLOCK, "moss", 1);

    private final Material topMaterial;
    private final Material topLayerMaterial;
    private final String name;
    private final String description;
    private final BufferedImage icon;
    private final int defaultBiome;
    public static final int CUSTOM_TERRAIN_COUNT = 96;
    static final MixedMaterial[] customMaterials;
    static final int GOLD_LEVEL = 32;
    static final int IRON_LEVEL = 48;
    static final int COAL_LEVEL = Integer.MAX_VALUE;
    static final int LAPIS_LAZULI_LEVEL = 32;
    static final int DIAMOND_LEVEL = 16;
    static final int REDSTONE_LEVEL = 16;
    static final int WATER_LEVEL = Integer.MAX_VALUE;
    static final int LAVA_LEVEL = 80;
    static final int DIRT_LEVEL = Integer.MAX_VALUE;
    static final int GRAVEL_LEVEL = Integer.MAX_VALUE;
    static final float GOLD_CHANCE;
    static final float IRON_CHANCE;
    static final float COAL_CHANCE;
    static final float LAPIS_LAZULI_CHANCE;
    static final float DIAMOND_CHANCE;
    static final float REDSTONE_CHANCE;
    static final float WATER_CHANCE;
    static final float LAVA_CHANCE;
    static final float DIRT_CHANCE;
    static final float GRAVEL_CHANCE;
    static final float FLOWER_CHANCE;
    static final float FERN_CHANCE;
    static final float GRASS_CHANCE;
    static final float DOUBLE_TALL_GRASS_CHANCE;
    static final float BEACH_SAND_CHANCE;
    static final float BEACH_GRAVEL_CHANCE;
    static final float BEACH_CLAY_CHANCE;
    static final float GRANITE_CHANCE;
    static final float DIORITE_CHANCE;
    static final float ANDESITE_CHANCE;
    public static final Terrain[] VALUES;
    public static final Terrain[] PICK_LIST;
    public static final Set<Terrain> STAINED_TERRACOTTAS;

    private Terrain(String name, String description, int defaultBiome) {
        this(name, Material.STONE, Material.STONE, description, defaultBiome);
    }

    private Terrain(String name, String description, int defaultBiome, int toppingHeight) {
        this(name, Material.STONE, Material.STONE, description, defaultBiome);
    }

    private Terrain(String name, int topMaterial, int topLayerMaterial, String description, int defaultBiome) {
        this(name, Material.get(topMaterial), Material.get(topLayerMaterial), description, defaultBiome);
    }

    private Terrain(String name, Material topMaterial, Material topLayerMaterial, String description, int defaultBiome) {
        this.name = name;
        this.topMaterial = topMaterial;
        this.topLayerMaterial = topLayerMaterial;
        this.description = description;
        this.defaultBiome = defaultBiome;
        this.icon = IconUtils.loadUnscaledImage((String)("org/pepsoft/worldpainter/icons/" + this.name().toLowerCase() + ".png"));
    }

    public String getName() {
        return this.name;
    }

    public Material getMaterial(Platform platform, long seed, int x, int y, float z, int height) {
        return this.getMaterial(platform, seed, x, y, Math.round(z), height);
    }

    public Material getMaterial(Platform platform, long seed, int x, int y, int z, int height) {
        int dz = z - height;
        if (dz > 0) {
            return Material.AIR;
        }
        if (dz == 0) {
            return this.topMaterial;
        }
        return this.topLayerMaterial;
    }

    public Set<Material> getAllMaterials() {
        return this.topMaterial == this.topLayerMaterial ? Collections.singleton(this.topMaterial) : ImmutableSet.of((Object)this.topMaterial, (Object)this.topLayerMaterial);
    }

    public WPObject getSurfaceObject(Platform platform, long seed, int x, int y, int waterBlocksAbove) {
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public BufferedImage getIcon(ColourScheme colourScheme) {
        return this.icon;
    }

    public final BufferedImage getScaledIcon(int size, ColourScheme colourScheme) {
        return IconUtils.scaleIcon((Image)this.getIcon(colourScheme), (int)size);
    }

    public int getColour(long seed, int x, int y, float z, int height, Platform platform, ColourScheme colourScheme) {
        try {
            return colourScheme.getColour(this.getMaterial(platform, seed, x, y, z, height));
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getClass().getSimpleName() + " while getting colour of material " + this.getMaterial(platform, seed, x, y, z, height) + " @ " + x + "," + y + "," + z + "," + height + " for terrain " + (Object)((Object)this), e);
        }
    }

    public int getColour(long seed, int x, int y, int z, int height, Platform platform, ColourScheme colourScheme) {
        try {
            return colourScheme.getColour(this.getMaterial(platform, seed, x, y, z, height));
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getClass().getSimpleName() + " while getting colour of material " + this.getMaterial(platform, seed, x, y, z, height) + " @ " + x + "," + y + "," + z + "," + height + " for terrain " + (Object)((Object)this), e);
        }
    }

    public int getDefaultBiome() {
        return this.defaultBiome;
    }

    public boolean isCustom() {
        return false;
    }

    public boolean isConfigured() {
        return true;
    }

    public int getCustomTerrainIndex() {
        throw new IllegalArgumentException("Not a custom terrain");
    }

    public String toString() {
        return this.name;
    }

    public static boolean isCustomMaterialConfigured(int index) {
        return customMaterials[index] != null;
    }

    public static int getConfiguredCustomMaterialCount() {
        return (int)Arrays.stream(customMaterials).filter(Objects::nonNull).count();
    }

    public static MixedMaterial getCustomMaterial(int index) {
        return customMaterials[index];
    }

    public static void setCustomMaterial(int index, MixedMaterial material) {
        Terrain.customMaterials[index] = material;
    }

    public static Terrain getCustomTerrain(int index) {
        return index < 48 ? (index < 24 ? VALUES[index + 47] : VALUES[index + 52]) : VALUES[index + 54];
    }

    public static Terrain[] getConfiguredValues() {
        ArrayList<Terrain> values = new ArrayList<Terrain>(VALUES.length);
        values.addAll(Arrays.asList(PICK_LIST));
        ArrayList<Terrain> customValues = new ArrayList<Terrain>(96);
        for (Terrain terrain : VALUES) {
            if (!terrain.isCustom() || !terrain.isConfigured()) continue;
            customValues.add(terrain);
        }
        if (!customValues.isEmpty()) {
            customValues.sort(Comparator.comparing(Terrain::getName));
            values.addAll(customValues);
        }
        return values.toArray(new Terrain[values.size()]);
    }

    static {
        customMaterials = new MixedMaterial[96];
        GOLD_CHANCE = PerlinNoise.getLevelForPromillage((int)1);
        IRON_CHANCE = PerlinNoise.getLevelForPromillage((int)5);
        COAL_CHANCE = PerlinNoise.getLevelForPromillage((int)9);
        LAPIS_LAZULI_CHANCE = PerlinNoise.getLevelForPromillage((int)1);
        DIAMOND_CHANCE = PerlinNoise.getLevelForPromillage((int)1);
        REDSTONE_CHANCE = PerlinNoise.getLevelForPromillage((int)6);
        WATER_CHANCE = PerlinNoise.getLevelForPromillage((int)1);
        LAVA_CHANCE = PerlinNoise.getLevelForPromillage((int)1);
        DIRT_CHANCE = PerlinNoise.getLevelForPromillage((int)9);
        GRAVEL_CHANCE = PerlinNoise.getLevelForPromillage((int)9);
        FLOWER_CHANCE = PerlinNoise.getLevelForPromillage((int)10);
        FERN_CHANCE = PerlinNoise.getLevelForPromillage((int)10);
        GRASS_CHANCE = PerlinNoise.getLevelForPromillage((int)100);
        DOUBLE_TALL_GRASS_CHANCE = PerlinNoise.getLevelForPromillage((int)50);
        BEACH_SAND_CHANCE = PerlinNoise.getLevelForPromillage((int)400) * 1.5f;
        BEACH_GRAVEL_CHANCE = PerlinNoise.getLevelForPromillage((int)200) * 1.5f;
        BEACH_CLAY_CHANCE = PerlinNoise.getLevelForPromillage((int)40);
        GRANITE_CHANCE = PerlinNoise.getLevelForPromillage((int)45);
        DIORITE_CHANCE = PerlinNoise.getLevelForPromillage((int)45);
        ANDESITE_CHANCE = PerlinNoise.getLevelForPromillage((int)45);
        VALUES = new Terrain[]{GRASS, BARE_GRASS, DIRT, PERMADIRT, PODZOL, SAND, RED_SAND, DESERT, RED_DESERT, MESA, HARDENED_CLAY, WHITE_STAINED_CLAY, ORANGE_STAINED_CLAY, MAGENTA_STAINED_CLAY, LIGHT_BLUE_STAINED_CLAY, YELLOW_STAINED_CLAY, LIME_STAINED_CLAY, PINK_STAINED_CLAY, GREY_STAINED_CLAY, LIGHT_GREY_STAINED_CLAY, CYAN_STAINED_CLAY, PURPLE_STAINED_CLAY, BLUE_STAINED_CLAY, BROWN_STAINED_CLAY, GREEN_STAINED_CLAY, RED_STAINED_CLAY, BLACK_STAINED_CLAY, SANDSTONE, STONE, ROCK, COBBLESTONE, MOSSY_COBBLESTONE, OBSIDIAN, BEDROCK, GRAVEL, CLAY, BEACHES, WATER, LAVA, SNOW, DEEP_SNOW, NETHERRACK, SOUL_SAND, NETHERLIKE, MYCELIUM, END_STONE, RESOURCES, CUSTOM_1, CUSTOM_2, CUSTOM_3, CUSTOM_4, CUSTOM_5, CUSTOM_6, CUSTOM_7, CUSTOM_8, CUSTOM_9, CUSTOM_10, CUSTOM_11, CUSTOM_12, CUSTOM_13, CUSTOM_14, CUSTOM_15, CUSTOM_16, CUSTOM_17, CUSTOM_18, CUSTOM_19, CUSTOM_20, CUSTOM_21, CUSTOM_22, CUSTOM_23, CUSTOM_24, RED_SANDSTONE, GRANITE, DIORITE, ANDESITE, STONE_MIX, CUSTOM_25, CUSTOM_26, CUSTOM_27, CUSTOM_28, CUSTOM_29, CUSTOM_30, CUSTOM_31, CUSTOM_32, CUSTOM_33, CUSTOM_34, CUSTOM_35, CUSTOM_36, CUSTOM_37, CUSTOM_38, CUSTOM_39, CUSTOM_40, CUSTOM_41, CUSTOM_42, CUSTOM_43, CUSTOM_44, CUSTOM_45, CUSTOM_46, CUSTOM_47, CUSTOM_48, GRASS_PATH, MAGMA, CUSTOM_49, CUSTOM_50, CUSTOM_51, CUSTOM_52, CUSTOM_53, CUSTOM_54, CUSTOM_55, CUSTOM_56, CUSTOM_57, CUSTOM_58, CUSTOM_59, CUSTOM_60, CUSTOM_61, CUSTOM_62, CUSTOM_63, CUSTOM_64, CUSTOM_65, CUSTOM_66, CUSTOM_67, CUSTOM_68, CUSTOM_69, CUSTOM_70, CUSTOM_71, CUSTOM_72, CUSTOM_73, CUSTOM_74, CUSTOM_75, CUSTOM_76, CUSTOM_77, CUSTOM_78, CUSTOM_79, CUSTOM_80, CUSTOM_81, CUSTOM_82, CUSTOM_83, CUSTOM_84, CUSTOM_85, CUSTOM_86, CUSTOM_87, CUSTOM_88, CUSTOM_89, CUSTOM_90, CUSTOM_91, CUSTOM_92, CUSTOM_93, CUSTOM_94, CUSTOM_95, CUSTOM_96, DEEPSLATE, TUFF, BASALT, BLACKSTONE, SOUL_SOIL, WARPED_NYLIUM, CRIMSON_NYLIUM, CALCITE, MUD, BARE_BEACHES, MOSS};
        PICK_LIST = new Terrain[]{GRASS, BARE_GRASS, GRASS_PATH, DIRT, PERMADIRT, PODZOL, MOSS, MUD, SAND, RED_SAND, DESERT, RED_DESERT, MESA, HARDENED_CLAY, SANDSTONE, RED_SANDSTONE, STONE_MIX, STONE, GRANITE, DIORITE, ANDESITE, CALCITE, ROCK, COBBLESTONE, MOSSY_COBBLESTONE, OBSIDIAN, DEEPSLATE, TUFF, BEDROCK, GRAVEL, CLAY, BEACHES, WATER, LAVA, MAGMA, DEEP_SNOW, NETHERRACK, BASALT, BLACKSTONE, SOUL_SAND, SOUL_SOIL, NETHERLIKE, WARPED_NYLIUM, CRIMSON_NYLIUM, MYCELIUM, END_STONE, WHITE_STAINED_CLAY, ORANGE_STAINED_CLAY, MAGENTA_STAINED_CLAY, LIGHT_BLUE_STAINED_CLAY, YELLOW_STAINED_CLAY, LIME_STAINED_CLAY, PINK_STAINED_CLAY, GREY_STAINED_CLAY, LIGHT_GREY_STAINED_CLAY, CYAN_STAINED_CLAY, PURPLE_STAINED_CLAY, BLUE_STAINED_CLAY, BROWN_STAINED_CLAY, GREEN_STAINED_CLAY, RED_STAINED_CLAY, BLACK_STAINED_CLAY};
        STAINED_TERRACOTTAS = ImmutableSet.of((Object)((Object)WHITE_STAINED_CLAY), (Object)((Object)ORANGE_STAINED_CLAY), (Object)((Object)MAGENTA_STAINED_CLAY), (Object)((Object)LIGHT_BLUE_STAINED_CLAY), (Object)((Object)YELLOW_STAINED_CLAY), (Object)((Object)LIME_STAINED_CLAY), (Object[])new Terrain[]{PINK_STAINED_CLAY, GREY_STAINED_CLAY, LIGHT_GREY_STAINED_CLAY, CYAN_STAINED_CLAY, PURPLE_STAINED_CLAY, BLUE_STAINED_CLAY, BROWN_STAINED_CLAY, GREEN_STAINED_CLAY, RED_STAINED_CLAY, BLACK_STAINED_CLAY});
    }
}

