/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Point;
import java.util.Map;
import java.util.Set;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.RODelegatingDimension;
import org.pepsoft.worldpainter.ScalingHelper;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;

public class ScaledDimension
extends RODelegatingDimension<Tile> {
    private final float scale;
    private final ScalingHelper scalingHelper;
    private final Set<Point> tileCoords;

    public ScaledDimension(Dimension dimension, float scale) {
        super(dimension);
        this.scale = scale;
        this.scalingHelper = new ScalingHelper(dimension.tiles, dimension.getTileFactory(), scale);
        this.tileCoords = this.scalingHelper.getTileCoords();
        this.setScale(dimension.getScale() / scale);
    }

    @Override
    public int getTileCount() {
        return this.tileCoords.size();
    }

    @Override
    public int getIntHeightAt(int x, int y, int defaultValue) {
        return Math.round(this.scalingHelper.getHeightAt(x, y));
    }

    @Override
    public float getHeightAt(int x, int y) {
        return this.scalingHelper.getHeightAt(x, y);
    }

    @Override
    public int getRawHeightAt(int x, int y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getWaterLevelAt(int x, int y) {
        return this.dimension.getWaterLevelAt(Math.round((float)x / this.scale), Math.round((float)y / this.scale));
    }

    @Override
    public int getLayerValueAt(Layer layer, int x, int y) {
        if (layer.discrete) {
            return this.dimension.getLayerValueAt(layer, Math.round((float)x / this.scale), Math.round((float)y / this.scale));
        }
        return this.scalingHelper.getLayerValueAt(layer, x, y);
    }

    @Override
    public boolean getBitLayerValueAt(Layer layer, int x, int y) {
        if (layer.discrete) {
            return this.dimension.getBitLayerValueAt(layer, Math.round((float)x / this.scale), Math.round((float)y / this.scale));
        }
        return this.scalingHelper.getBitLayerValueAt(layer, x, y);
    }

    @Override
    public float getDistanceToEdge(Layer layer, int x, int y, float maxDistance) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getHeight() {
        return this.scalingHelper.getHighestTileY() - this.scalingHelper.getLowestTileY() + 1;
    }

    @Override
    public int getHighestX() {
        return this.scalingHelper.getHighestTileX();
    }

    @Override
    public int getHighestY() {
        return this.scalingHelper.getHighestTileY();
    }

    @Override
    public ExporterSettings getLayerSettings(Layer layer) {
        return this.dimension.getLayerSettings(layer);
    }

    @Override
    public Map<Layer, ExporterSettings> getAllLayerSettings() {
        return this.dimension.getAllLayerSettings();
    }

    @Override
    public int getLowestX() {
        return this.scalingHelper.getLowestTileX();
    }

    @Override
    public int getLowestY() {
        return this.scalingHelper.getLowestTileY();
    }

    @Override
    public int getFloodedCount(int x, int y, int r, boolean lava) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getSlope(int x, int y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Point> getTileCoords() {
        return this.tileCoords;
    }

    @Override
    public int getWidth() {
        return this.scalingHelper.getHighestTileX() - this.scalingHelper.getLowestTileX() + 1;
    }

    @Override
    public boolean isBorderTile(int x, int y) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Tile doGetTile(Point coords) {
        return this.scalingHelper.createScaledTile(coords.x, coords.y);
    }
}

