/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Point;
import java.beans.PropertyChangeListener;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.undo.UndoManager;
import org.pepsoft.worldpainter.CoordinateTransform;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Overlay;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.biomeschemes.CustomBiome;
import org.pepsoft.worldpainter.gardenofeden.Garden;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;

public abstract class RODelegatingDimension<T extends Tile>
extends Dimension {
    protected final Dimension dimension;
    protected final Map<Point, Reference<T>> tileCache = new HashMap<Point, Reference<T>>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private Set<T> allTiles;
    private static final Reference<? extends Tile> NO_TILE_PRESENT = new SoftReference<Object>(null);
    private static final long serialVersionUID = 1L;

    public RODelegatingDimension(Dimension dimension) {
        super(dimension.getWorld(), dimension.getName(), dimension.getMinecraftSeed(), dimension.getTileFactory(), dimension.getAnchor());
        this.dimension = dimension;
    }

    @Override
    public World2 getWorld() {
        return this.dimension.getWorld();
    }

    @Override
    public Dimension.Anchor getAnchor() {
        return this.dimension.getAnchor();
    }

    @Override
    public String getName() {
        return this.dimension.getName();
    }

    @Override
    public long getChangeNo() {
        return this.dimension.getChangeNo();
    }

    @Override
    public long getSeed() {
        return this.dimension.getSeed();
    }

    @Override
    public Terrain getSubsurfaceMaterial() {
        return this.dimension.getSubsurfaceMaterial();
    }

    @Override
    public boolean isPopulate() {
        return this.dimension.isPopulate();
    }

    @Override
    public Dimension.Border getBorder() {
        return this.dimension.getBorder();
    }

    @Override
    public int getBorderLevel() {
        return this.dimension.getBorderLevel();
    }

    @Override
    public int getBorderSize() {
        return this.dimension.getBorderSize();
    }

    @Override
    public TileFactory getTileFactory() {
        return this.dimension.getTileFactory();
    }

    @Override
    public boolean isTilePresent(int x, int y) {
        return this.getTile(x, y) != null;
    }

    @Override
    public int getTileCount() {
        return this.dimension.getTileCount();
    }

    @Override
    public void removeTile(Point coords) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeTile(int tileX, int tileY) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIntHeightAt(int x, int y) {
        return this.getIntHeightAt(x, y, Integer.MIN_VALUE);
    }

    @Override
    public int getIntHeightAt(int x, int y, int defaultValue) {
        return this.dimension.getIntHeightAt(x, y, defaultValue);
    }

    @Override
    public int getIntHeightAt(Point coords) {
        return this.getIntHeightAt(coords.x, coords.y, Integer.MIN_VALUE);
    }

    @Override
    public float getHeightAt(int x, int y) {
        return this.dimension.getHeightAt(x, y);
    }

    @Override
    public float getHeightAt(Point coords) {
        return this.getHeightAt(coords.x, coords.y);
    }

    @Override
    public int getRawHeightAt(int x, int y) {
        return this.dimension.getRawHeightAt(x, y);
    }

    @Override
    public int getRawHeightAt(Point coords) {
        return this.getRawHeightAt(coords.x, coords.y);
    }

    @Override
    public final void setRawHeightAt(int x, int y, int rawHeight) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setRawHeightAt(Point coords, int rawHeight) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Terrain getTerrainAt(int x, int y) {
        return super.getTerrainAt(x, y);
    }

    @Override
    public Set<Terrain> getAllTerrains() {
        return this.dimension.getAllTerrains();
    }

    @Override
    public int getWaterLevelAt(int x, int y) {
        return this.dimension.getWaterLevelAt(x, y);
    }

    @Override
    public int getWaterLevelAt(Point coords) {
        return this.getWaterLevelAt(coords.x, coords.y);
    }

    @Override
    public int getLayerValueAt(Layer layer, int x, int y) {
        return this.dimension.getLayerValueAt(layer, x, y);
    }

    @Override
    public int getLayerValueAt(Layer layer, Point coords) {
        return this.getLayerValueAt(layer, coords.x, coords.y);
    }

    @Override
    public boolean getBitLayerValueAt(Layer layer, int x, int y) {
        return this.dimension.getBitLayerValueAt(layer, x, y);
    }

    @Override
    public float getDistanceToEdge(Layer layer, int x, int y, float maxDistance) {
        return this.dimension.getDistanceToEdge(layer, x, y, maxDistance);
    }

    @Override
    public final void clearLayerData(Layer layer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMinecraftSeed() {
        return this.dimension.getMinecraftSeed();
    }

    @Override
    public List<Overlay> getOverlays() {
        return this.dimension.getOverlays();
    }

    @Override
    public int addOverlay(Overlay overlay) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeOverlay(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isGridEnabled() {
        return this.dimension.isGridEnabled();
    }

    @Override
    public final void setGridEnabled(boolean gridEnabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getGridSize() {
        return this.dimension.getGridSize();
    }

    @Override
    public final void setGridSize(int gridSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOverlaysEnabled() {
        return this.dimension.isOverlaysEnabled();
    }

    @Override
    public final void setOverlaysEnabled(boolean overlaysEnabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxHeight() {
        return this.dimension.getMaxHeight();
    }

    @Override
    public final void setMaxHeight(int maxHeight) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getContourSeparation() {
        return this.dimension.getContourSeparation();
    }

    @Override
    public final void setContourSeparation(int contourSeparation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isContoursEnabled() {
        return this.dimension.isContoursEnabled();
    }

    @Override
    public final void setContoursEnabled(boolean contoursEnabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTopLayerMinDepth() {
        return this.dimension.getTopLayerMinDepth();
    }

    @Override
    public final void setTopLayerMinDepth(int topLayerMinDepth) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTopLayerVariation() {
        return this.dimension.getTopLayerVariation();
    }

    @Override
    public final void setTopLayerVariation(int topLayerVariation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBottomless() {
        return this.dimension.isBottomless();
    }

    @Override
    public final void setBottomless(boolean bottomless) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Point getLastViewPosition() {
        return this.dimension.getLastViewPosition();
    }

    @Override
    public final void setLastViewPosition(Point lastViewPosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<CustomBiome> getCustomBiomes() {
        return this.dimension.getCustomBiomes();
    }

    @Override
    public final void setCustomBiomes(List<CustomBiome> customBiomes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Garden getGarden() {
        return this.dimension.getGarden();
    }

    @Override
    public Set<Layer> getAllLayers(boolean applyCombinedLayers) {
        return this.dimension.getAllLayers(applyCombinedLayers);
    }

    @Override
    public boolean containsOneOf(Layer ... layers) {
        return this.dimension.containsOneOf(layers);
    }

    @Override
    public Set<Layer> getMinimumLayers() {
        return this.dimension.getMinimumLayers();
    }

    @Override
    public Dimension.WallType getWallType() {
        return this.dimension.getWallType();
    }

    @Override
    public final void setWallType(Dimension.WallType wallType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Dimension.WallType getRoofType() {
        return this.dimension.getRoofType();
    }

    @Override
    public final void setRoofType(Dimension.WallType roofType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean undoChanges() {
        return false;
    }

    @Override
    public final void clearUndo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void clearRedo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Dimension getSnapshot() {
        return this.dimension.getSnapshot();
    }

    @Override
    public int getTopLayerDepth(int x, int y, int z) {
        return this.dimension.getTopLayerDepth(x, y, z);
    }

    @Override
    final void ensureAllReadable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeDimensionListener(Dimension.Listener listener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
    }

    @Override
    public final void transform(CoordinateTransform transform, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        throw new UnsupportedOperationException();
    }

    @Override
    public void heightMapChanged(Tile tile) {
    }

    @Override
    public void terrainChanged(Tile tile) {
    }

    @Override
    public void waterLevelChanged(Tile tile) {
    }

    @Override
    public void seedsChanged(Tile tile) {
    }

    @Override
    public void layerDataChanged(Tile tile, Set<Layer> changedLayers) {
    }

    @Override
    public void allBitLayerDataChanged(Tile tile) {
    }

    @Override
    public void allNonBitlayerDataChanged(Tile tile) {
    }

    @Override
    public void addDimensionListener(Dimension.Listener listener) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
    }

    @Override
    public final void addTile(Tile tile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void applyTheme(int x, int y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void applyTheme(Point coords) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unregisterUndoManager() {
    }

    @Override
    public void armSavePoint() {
    }

    @Override
    public void registerUndoManager(UndoManager undoManager) {
    }

    @Override
    public boolean isUndoAvailable() {
        return false;
    }

    @Override
    public int getHeight() {
        return this.dimension.getHeight();
    }

    @Override
    public int getHighestX() {
        return this.dimension.getHighestX();
    }

    @Override
    public int getHighestY() {
        return this.dimension.getHighestY();
    }

    @Override
    public ExporterSettings getLayerSettings(Layer layer) {
        return this.dimension.getLayerSettings(layer);
    }

    @Override
    public Map<Layer, ExporterSettings> getAllLayerSettings() {
        return this.dimension.getAllLayerSettings();
    }

    @Override
    public int getLowestX() {
        return this.dimension.getLowestX();
    }

    @Override
    public int getLowestY() {
        return this.dimension.getLowestY();
    }

    @Override
    public int getFloodedCount(int x, int y, int r, boolean lava) {
        return this.dimension.getFloodedCount(x, y, r, lava);
    }

    @Override
    public float getSlope(int x, int y) {
        return this.dimension.getSlope(x, y);
    }

    public final T getTile(int x, int y) {
        return this.getTile(new Point(x, y));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getTile(Point coords) {
        this.readLock.lock();
        try {
            Tile cachedTile;
            Reference<T> cachedTileRef = this.tileCache.get(coords);
            if (cachedTileRef == NO_TILE_PRESENT) {
                T t = null;
                return t;
            }
            Tile tile = cachedTile = cachedTileRef != null ? (Tile)cachedTileRef.get() : null;
            if (cachedTile == null) {
                this.readLock.unlock();
                this.writeLock.lock();
                try {
                    Tile tile2 = this.doGetTile(coords);
                    if (tile2 != null) {
                        cachedTile = this.wrapTile(tile2);
                        this.tileCache.put(coords, new SoftReference<Tile>(cachedTile));
                    }
                    this.readLock.lock();
                }
                finally {
                    this.writeLock.unlock();
                }
            }
            Tile tile3 = cachedTile;
            return (T)tile3;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> getTiles() {
        this.readLock.lock();
        try {
            if (this.allTiles == null) {
                this.readLock.unlock();
                this.writeLock.lock();
                try {
                    Collection<? extends Tile> tiles = this.dimension.getTiles();
                    this.allTiles = new HashSet<T>();
                    for (Tile tile : tiles) {
                        Tile cachedTile;
                        Reference<T> cachedTileRef = this.tileCache.get(new Point(tile.getX(), tile.getY()));
                        if (cachedTileRef == NO_TILE_PRESENT) continue;
                        Tile tile2 = cachedTile = cachedTileRef != null ? (Tile)cachedTileRef.get() : null;
                        if (cachedTile != null) {
                            this.allTiles.add(cachedTile);
                            continue;
                        }
                        this.allTiles.add(this.wrapTile(tile));
                    }
                    this.readLock.lock();
                }
                finally {
                    this.writeLock.unlock();
                }
            }
            Set<T> set = this.allTiles;
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<Point> getTileCoords() {
        return this.dimension.getTileCoords();
    }

    @Override
    public int getWidth() {
        return this.dimension.getWidth();
    }

    @Override
    public boolean isEventsInhibited() {
        return false;
    }

    @Override
    public final void removeTile(Tile tile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setBitLayerValueAt(Layer layer, int x, int y, boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setBorder(Dimension.Border border) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setBorderLevel(int borderLevel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setBorderSize(int borderSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void changed() {
    }

    @Override
    public void setEventsInhibited(boolean eventsInhibited) {
    }

    @Override
    public final void setHeightAt(int x, int y, float height) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setHeightAt(Point coords, float height) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setLayerSettings(Layer layer, ExporterSettings settings) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setLayerValueAt(Layer layer, int x, int y, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setMinecraftSeed(long minecraftSeed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setPopulate(boolean populate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setSubsurfaceMaterial(Terrain subsurfaceMaterial) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setTerrainAt(int x, int y, Terrain terrain) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setTerrainAt(Point coords, Terrain terrain) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setWaterLevelAt(int x, int y, int waterLevel) {
        throw new UnsupportedOperationException();
    }

    protected Tile doGetTile(Point coords) {
        return this.dimension.getTile(coords);
    }

    protected T wrapTile(Tile tile) {
        return (T)tile;
    }

    private void writeObject(ObjectOutputStream out) throws NotSerializableException {
        throw new NotSerializableException("Serialization of " + this.getClass().getSimpleName() + " not supported");
    }
}

