/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pepsoft.util.AttributeKey;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.GameType;
import org.pepsoft.worldpainter.Generator;
import org.pepsoft.worldpainter.World2;

public final class Platform
implements Serializable {
    public final String id;
    public final String displayName;
    public final int minMaxHeight;
    public final int standardMaxHeight;
    public final int maxMaxHeight;
    public final int minX;
    public final int maxX;
    public final int minY;
    public final int maxY;
    public final List<GameType> supportedGameTypes;
    public final List<Generator> supportedGenerators;
    public final List<Integer> supportedDimensions;
    public final Set<Capability> capabilities;
    public final int[] maxHeights;
    public final int minZ;
    public final Map<String, Serializable> attributes;
    public final int minMinHeight;
    public final int maxMinHeight;
    public final int[] minHeights;
    public static final AttributeKey<String> ATTRIBUTE_GRASS_BLOCK_NAME = new AttributeKey("blocks.grass_block.name", (Object)"minecraft:grass_block");
    public static final AttributeKey<Integer> ATTRIBUTE_WATER_OPACITY = new AttributeKey("blocks.water.opacity", (Object)1);
    private static final Map<String, Platform> ALL_PLATFORMS = new HashMap<String, Platform>();
    private static final long serialVersionUID = 1L;

    public Platform(String id, String displayName, int minMaxHeight, int standardMaxHeight, int maxMaxHeight, int minX, int maxX, int minY, int maxY, List<GameType> supportedGameTypes, List<Generator> supportedGeneratorTypes, List<Integer> supportedDimensions, Set<Capability> capabilities, Object ... attributes) {
        this(id, displayName, Platform.defaultMaxHeightsFromTo(minMaxHeight, maxMaxHeight), standardMaxHeight, minX, maxX, minY, maxY, new int[]{0}, 0, supportedGameTypes, supportedGeneratorTypes, supportedDimensions, capabilities, attributes);
    }

    public Platform(String id, String displayName, int[] maxHeights, int standardMaxHeight, int minX, int maxX, int minY, int maxY, int standardMinHeight, List<GameType> supportedGameTypes, List<Generator> supportedGeneratorTypes, List<Integer> supportedDimensions, Set<Capability> capabilities, Object ... attributes) {
        this(id, displayName, maxHeights, standardMaxHeight, minX, maxX, minY, maxY, new int[]{standardMinHeight}, standardMinHeight, supportedGameTypes, supportedGeneratorTypes, supportedDimensions, capabilities, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Platform(String id, String displayName, int[] maxHeights, int standardMaxHeight, int minX, int maxX, int minY, int maxY, int[] minHeights, int standardMinHeight, List<GameType> supportedGameTypes, List<Generator> supportedGeneratorTypes, List<Integer> supportedDimensions, Set<Capability> capabilities, Object ... attributes) {
        Map<String, Platform> map = ALL_PLATFORMS;
        synchronized (map) {
            if (ALL_PLATFORMS.containsKey(id)) {
                throw new IllegalStateException("There is already a platform with ID " + id);
            }
            this.id = id;
            this.displayName = displayName;
            this.minMaxHeight = maxHeights[0];
            this.maxHeights = maxHeights;
            this.standardMaxHeight = standardMaxHeight;
            this.maxMaxHeight = maxHeights[maxHeights.length - 1];
            this.minX = minX;
            this.maxX = maxX;
            this.minY = minY;
            this.maxY = maxY;
            this.minMinHeight = minHeights[minHeights.length - 1];
            this.minHeights = minHeights;
            this.minZ = standardMinHeight;
            this.maxMinHeight = minHeights[0];
            this.supportedGameTypes = ImmutableList.copyOf(supportedGameTypes);
            this.supportedGenerators = ImmutableList.copyOf(supportedGeneratorTypes);
            this.supportedDimensions = ImmutableList.copyOf(supportedDimensions);
            this.capabilities = Sets.immutableEnumSet(capabilities);
            if (attributes != null && attributes.length > 0) {
                if (attributes.length % 2 != 0) {
                    throw new IllegalArgumentException("attributes array must have even length");
                }
                ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
                for (int i = 0; i < attributes.length; i += 2) {
                    if (attributes[i] == null) {
                        throw new NullPointerException("attributes[" + i + "]");
                    }
                    if (attributes[i + 1] == null) {
                        throw new NullPointerException("attributes[" + (i + 1) + "]");
                    }
                    mapBuilder.put((Object)((AttributeKey)attributes[i]).key, (Object)((Serializable)attributes[i + 1]));
                }
                this.attributes = mapBuilder.build();
            } else {
                this.attributes = null;
            }
            ALL_PLATFORMS.put(id, this);
        }
    }

    @Deprecated
    public Platform(String id, String displayName, int minMaxHeight, int standardMaxHeight, int maxMaxHeight, int minX, int maxX, int minY, int maxY, List<GameType> supportedGameTypes, List<Generator> supportedGenerators, List<Integer> supportedDimensions, Set<Capability> capabilities) {
        this(id, displayName, Platform.defaultMaxHeightsFromTo(minMaxHeight, maxMaxHeight), standardMaxHeight, minX, maxX, minY, maxY, new int[]{0}, 0, supportedGameTypes, supportedGenerators, supportedDimensions, capabilities, (Object[])null);
    }

    @Deprecated
    public Platform(String id, String displayName, int[] maxHeights, int standardMaxHeight, int minX, int maxX, int minY, int maxY, int standardMinHeight, List<GameType> supportedGameTypes, List<Generator> supportedGeneratorTypes, List<Integer> supportedDimensions, Set<Capability> capabilities) {
        this(id, displayName, maxHeights, standardMaxHeight, minX, maxX, minY, maxY, new int[]{standardMinHeight}, standardMinHeight, supportedGameTypes, supportedGeneratorTypes, supportedDimensions, capabilities, (Object[])null);
    }

    public String isCompatible(World2 world) {
        if (world.getMinHeight() < this.minMinHeight) {
            return "World lower build limit (" + world.getMinHeight() + ") is lower than the minimum lower build limit supported by map format (" + this.minMinHeight + ")";
        }
        if (world.getMinHeight() > this.maxMinHeight) {
            return "World lower build limit (" + world.getMinHeight() + ") is higher than the maximum lower build limit supported by map format (" + this.maxMinHeight + ")";
        }
        if (world.getMaxHeight() < this.minMaxHeight) {
            return "World upper build limit (" + world.getMaxHeight() + ") is lower than the minimum upper build limit supported by map format (" + this.minMaxHeight + ")";
        }
        if (world.getMaxHeight() > this.maxMaxHeight) {
            return "World upper build limit (" + world.getMaxHeight() + ") is higher than the maximum upper build limit supported by map format (" + this.maxMaxHeight + ")";
        }
        for (Dimension dimension : world.getDimensions()) {
            Dimension.Anchor anchor = dimension.getAnchor();
            if (anchor.role != Dimension.Role.DETAIL || anchor.invert || this.supportedDimensions.contains(anchor.dim)) continue;
            return "Map format does not support dimension " + anchor.getDefaultName();
        }
        return null;
    }

    public boolean supportsBiomes() {
        return this.capabilities.contains((Object)Capability.BIOMES) || this.capabilities.contains((Object)Capability.BIOMES_3D) || this.capabilities.contains((Object)Capability.NAMED_BIOMES);
    }

    public <T extends Serializable> T getAttribute(AttributeKey<T> key) {
        return (T)(this.attributes != null ? (Serializable)key.get(this.attributes) : (Serializable)key.defaultValue);
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.displayName;
    }

    public static Platform getById(String id) {
        return ALL_PLATFORMS.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResolve() throws ObjectStreamException {
        Map<String, Platform> map = ALL_PLATFORMS;
        synchronized (map) {
            if (ALL_PLATFORMS.containsKey(this.id)) {
                return ALL_PLATFORMS.get(this.id);
            }
            ALL_PLATFORMS.put(this.id, this);
            return this;
        }
    }

    private static int[] defaultMaxHeightsFromTo(int minMaxHeight, int maxMaxHeight) {
        int minExponent = (int)Math.ceil(Math.log(minMaxHeight) / Math.log(2.0));
        int maxExponent = (int)Math.floor(Math.log(maxMaxHeight) / Math.log(2.0));
        ArrayList<Integer> maxHeights = new ArrayList<Integer>();
        for (int i = minExponent; i <= maxExponent; ++i) {
            maxHeights.add((int)Math.pow(2.0, i));
        }
        return maxHeights.stream().mapToInt(Integer::intValue).toArray();
    }

    public static enum Capability {
        BIOMES,
        PRECALCULATED_LIGHT,
        SET_SPAWN_POINT,
        BLOCK_BASED,
        NAME_BASED,
        SEED,
        POPULATE,
        BIOMES_3D,
        NAMED_BIOMES,
        GENERATOR_PER_DIMENSION,
        LEAF_DISTANCES,
        WATERLOGGED_LEAVES,
        DATA_PACKS;

    }
}

