/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Point;
import java.awt.Rectangle;
import javax.vecmath.Point3i;
import org.pepsoft.minecraft.Direction;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.heightMaps.TransformingHeightMap;

public abstract class CoordinateTransform {
    public static final CoordinateTransform ROTATE_CLOCKWISE_90_DEGREES = new CoordinateTransform(){

        @Override
        public Point transform(int x, int y) {
            return new Point(-y - 1, x);
        }

        @Override
        public Point3i transform(int x, int y, int z) {
            return new Point3i(-y - 1, x, z);
        }

        @Override
        public void transformInPlace(Point coords) {
            int tmp = coords.x;
            coords.x = -coords.y - 1;
            coords.y = tmp;
        }

        @Override
        public void transformInPlace(Point3i coords) {
            int tmp = coords.x;
            coords.x = -coords.y - 1;
            coords.y = tmp;
        }

        @Override
        public Direction transform(Direction direction) {
            return direction.right();
        }

        @Override
        public Direction inverseTransform(Direction direction) {
            return direction.left();
        }

        @Override
        public float transformAngle(float angle) {
            angle -= 1.5707964f;
            while (angle < 0.0f) {
                angle += (float)Math.PI * 2;
            }
            return angle;
        }

        @Override
        public float transformScalar(float scalar) {
            return scalar;
        }

        @Override
        public HeightMap transform(HeightMap heightMap) {
            return TransformingHeightMap.build().withHeightMap(heightMap).withName(heightMap.getName()).withRotation(1.5707964f).now();
        }

        @Override
        public boolean isRotating() {
            return true;
        }
    };
    public static final CoordinateTransform ROTATE_180_DEGREES = new CoordinateTransform(){

        @Override
        public Point transform(int x, int y) {
            return new Point(-x - 1, -y - 1);
        }

        @Override
        public Point3i transform(int x, int y, int z) {
            return new Point3i(-x - 1, -y - 1, z);
        }

        @Override
        public void transformInPlace(Point coords) {
            coords.x = -coords.x - 1;
            coords.y = -coords.y - 1;
        }

        @Override
        public void transformInPlace(Point3i coords) {
            coords.x = -coords.x - 1;
            coords.y = -coords.y - 1;
        }

        @Override
        public Direction transform(Direction direction) {
            return direction.opposite();
        }

        @Override
        public Direction inverseTransform(Direction direction) {
            return direction.opposite();
        }

        @Override
        public float transformAngle(float angle) {
            angle += (float)Math.PI;
            while (angle >= (float)Math.PI * 2) {
                angle -= (float)Math.PI * 2;
            }
            return angle;
        }

        @Override
        public float transformScalar(float scalar) {
            return scalar;
        }

        @Override
        public HeightMap transform(HeightMap heightMap) {
            return TransformingHeightMap.build().withHeightMap(heightMap).withName(heightMap.getName()).withRotation((float)Math.PI).now();
        }

        @Override
        public boolean isRotating() {
            return true;
        }
    };
    public static final CoordinateTransform ROTATE_CLOCKWISE_270_DEGREES = new CoordinateTransform(){

        @Override
        public Point transform(int x, int y) {
            return new Point(y, -x - 1);
        }

        @Override
        public Point3i transform(int x, int y, int z) {
            return new Point3i(y, -x - 1, z);
        }

        @Override
        public void transformInPlace(Point coords) {
            int tmp = -coords.x - 1;
            coords.x = coords.y;
            coords.y = tmp;
        }

        @Override
        public void transformInPlace(Point3i coords) {
            int tmp = -coords.x - 1;
            coords.x = coords.y;
            coords.y = tmp;
        }

        @Override
        public Direction transform(Direction direction) {
            return direction.left();
        }

        @Override
        public Direction inverseTransform(Direction direction) {
            return direction.right();
        }

        @Override
        public float transformAngle(float angle) {
            angle += 1.5707964f;
            while (angle >= (float)Math.PI * 2) {
                angle -= (float)Math.PI * 2;
            }
            return angle;
        }

        @Override
        public float transformScalar(float scalar) {
            return scalar;
        }

        @Override
        public HeightMap transform(HeightMap heightMap) {
            return TransformingHeightMap.build().withHeightMap(heightMap).withName(heightMap.getName()).withRotation(4.712389f).now();
        }

        @Override
        public boolean isRotating() {
            return true;
        }
    };
    public static final CoordinateTransform NOOP = new CoordinateTransform(){

        @Override
        public Point transform(int x, int y) {
            return new Point(x, y);
        }

        @Override
        public Point3i transform(int x, int y, int z) {
            return new Point3i(x, y, z);
        }

        @Override
        public void transformInPlace(Point coords) {
        }

        @Override
        public void transformInPlace(Point3i coords) {
        }

        @Override
        public Rectangle transform(Rectangle rectangle) {
            return rectangle;
        }

        @Override
        public Direction transform(Direction direction) {
            return direction;
        }

        @Override
        public Direction inverseTransform(Direction direction) {
            return direction;
        }

        @Override
        public float transformAngle(float angle) {
            return angle;
        }

        @Override
        public float transformScalar(float scalar) {
            return scalar;
        }

        @Override
        public HeightMap transform(HeightMap heightMap) {
            return heightMap;
        }

        @Override
        public boolean isScaling() {
            return false;
        }
    };
    private static final float HALF_PI = 1.5707964f;
    private static final float PI = (float)Math.PI;
    private static final float TWO_PI = (float)Math.PI * 2;

    public Point transform(int x, int y) {
        Point rc = new Point(x, y);
        this.transformInPlace(rc);
        return rc;
    }

    public Point3i transform(int x, int y, int z) {
        Point3i rc = new Point3i(x, y, z);
        this.transformInPlace(rc);
        return rc;
    }

    public final Point transform(Point coords) {
        return this.transform(coords.x, coords.y);
    }

    public final Point3i transform(Point3i coords) {
        return this.transform(coords.x, coords.y, coords.z);
    }

    public abstract void transformInPlace(Point var1);

    public abstract void transformInPlace(Point3i var1);

    public Rectangle transform(Rectangle rectangle) {
        Point corner1 = rectangle.getLocation();
        Point corner2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        this.transformInPlace(corner1);
        this.transformInPlace(corner2);
        return new Rectangle(Math.min(corner1.x, corner2.x), Math.min(corner1.y, corner2.y), Math.abs(corner2.x - corner1.x) + 1, Math.abs(corner2.y - corner1.y) + 1);
    }

    public abstract Direction transform(Direction var1);

    public abstract Direction inverseTransform(Direction var1);

    public abstract float transformAngle(float var1);

    public abstract float transformScalar(float var1);

    public abstract HeightMap transform(HeightMap var1);

    public boolean isScaling() {
        return false;
    }

    public boolean isRotating() {
        return false;
    }

    public float getScale() {
        return 1.0f;
    }

    public static CoordinateTransform getScalingInstance(final float scale) {
        if (scale == 1.0f) {
            return NOOP;
        }
        return new CoordinateTransform(){

            @Override
            public void transformInPlace(Point coords) {
                coords.x = Math.round((float)coords.x * scale);
                coords.y = Math.round((float)coords.y * scale);
            }

            @Override
            public void transformInPlace(Point3i coords) {
                coords.x = Math.round((float)coords.x * scale);
                coords.y = Math.round((float)coords.y * scale);
            }

            @Override
            public Direction transform(Direction direction) {
                return direction;
            }

            @Override
            public Direction inverseTransform(Direction direction) {
                return direction;
            }

            @Override
            public float transformAngle(float angle) {
                return angle;
            }

            @Override
            public float transformScalar(float scalar) {
                return scalar * scale;
            }

            @Override
            public HeightMap transform(HeightMap heightMap) {
                return heightMap.scaled(scale);
            }

            @Override
            public boolean isScaling() {
                return true;
            }

            @Override
            public float getScale() {
                return scale;
            }
        };
    }
}

