/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Point;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileFactory;

public abstract class AbstractTileFactory
implements TileFactory {
    private final Map<Point, TileCacheEntry> tileCache = Collections.synchronizedMap(new HashMap());
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Tile getTile(int x, int y) {
        TileCacheEntry tileCacheEntry;
        Point coords = new Point(x, y);
        TileCacheEntry tileCacheEntry2 = tileCacheEntry = this.tileCache.computeIfAbsent(coords, point -> new TileCacheEntry());
        synchronized (tileCacheEntry2) {
            Tile tile;
            Tile tile2 = tile = tileCacheEntry.tileRef != null ? tileCacheEntry.tileRef.get() : null;
            if (tile == null) {
                tile = this.createTile(x, y);
                tileCacheEntry.tileRef = new SoftReference<Tile>(tile);
            }
            return tile;
        }
    }

    static class TileCacheEntry {
        Reference<Tile> tileRef;

        TileCacheEntry() {
        }
    }
}

