/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft.mapexplorer;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jnbt.CompoundTag;
import org.jnbt.EndTag;
import org.jnbt.ListTag;
import org.jnbt.NBTInputStream;
import org.jnbt.Tag;
import org.pepsoft.minecraft.mapexplorer.FileSystemNode;
import org.pepsoft.minecraft.mapexplorer.TagNode;
import org.pepsoft.util.IconUtils;
import org.pepsoft.worldpainter.mapexplorer.Node;

public class NBTFileNode
extends FileSystemNode {
    private static final Icon ICON = IconUtils.scaleIcon((ImageIcon)IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/mapexplorer/nbtfile.png"), (int)16);

    NBTFileNode(File file) {
        super(file);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    protected Node[] loadChildren() {
        try {
            Tag tag;
            block45: {
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));){
                    ((InputStream)in).mark(2);
                    if (((InputStream)in).read() == 31 && ((InputStream)in).read() == 139) {
                        ((InputStream)in).reset();
                        tag = new NBTInputStream((InputStream)new GZIPInputStream(in)).readTag();
                        break block45;
                    }
                    ((InputStream)in).reset();
                    try (NBTInputStream levelIn = new NBTInputStream((InputStream)in);){
                        tag = levelIn.readTag();
                        if (!(tag instanceof CompoundTag)) {
                            ArrayList<Tag> tags = new ArrayList<Tag>();
                            while (!(tag instanceof EndTag)) {
                                tags.add(tag);
                                tag = levelIn.readTag();
                            }
                            tag = new ListTag("", Tag.class, tags);
                        }
                    }
                }
                catch (EOFException e) {
                    try (NBTInputStream in2 = new NBTInputStream((InputStream)new FileInputStream(this.file), true);){
                        tag = in2.readTag();
                        if (!(tag instanceof CompoundTag)) {
                            ArrayList<Tag> tags = new ArrayList<Tag>();
                            while (!(tag instanceof EndTag)) {
                                tags.add(tag);
                                tag = in2.readTag();
                            }
                            tag = new ListTag("", Tag.class, tags);
                        }
                    }
                }
            }
            return new Node[]{new TagNode(tag)};
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error while reading level.dat file", e);
        }
    }
}

