/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft.mapexplorer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.swing.BetterJPopupMenu;
import org.pepsoft.worldpainter.mapexplorer.AbstractNode;
import org.pepsoft.worldpainter.mapexplorer.Node;

public class FileSystemNode
extends AbstractNode {
    protected final File file;
    private final String displayName;
    private static final FileSystemView FILE_SYSTEM_VIEW = FileSystemView.getFileSystemView();

    public FileSystemNode(File file) {
        this(file, null);
    }

    public FileSystemNode(File file, String displayName) {
        this.file = file;
        this.displayName = displayName == null ? FILE_SYSTEM_VIEW.getSystemDisplayName(file) : displayName;
    }

    @Override
    public boolean isLeaf() {
        return !this.file.isDirectory();
    }

    @Override
    protected Node[] loadChildren() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String getName() {
        return this.displayName;
    }

    @Override
    public Icon getIcon() {
        return FILE_SYSTEM_VIEW.getSystemIcon(this.file);
    }

    @Override
    public void doubleClicked() {
        DesktopUtils.open((File)this.file);
    }

    @Override
    public void showPopupMenu(Component invoker, int x, int y, final Node.ActionListener actionListener) {
        BetterJPopupMenu popupMenu = new BetterJPopupMenu(this.getName());
        popupMenu.add(new AbstractAction("Refresh"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileSystemNode.this.refresh();
                actionListener.performAction(Node.Action.REFRESH);
            }
        });
        popupMenu.show(invoker, x, y);
    }

    public static String getName(File file) {
        return FILE_SYSTEM_VIEW.getSystemDisplayName(file);
    }
}

