/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft.datapack;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import org.pepsoft.minecraft.datapack.Descriptor;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Platform;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public final class Dimension
extends Descriptor {
    private final int logicalHeight;
    private final String infiniburn;
    private final float ambientLight;
    private final boolean respawnAnchorWorks;
    private final boolean hasRaids;
    private final int minY;
    private final int height;
    private final boolean natural;
    private final float coordinateScale;
    private final boolean piglinSafe;
    private final boolean bedWorks;
    private final boolean hasSkylight;
    private final boolean hasCeiling;
    private final boolean ultrawarm;
    private final Integer fixedTime;
    private final String effects;
    private final int monsterSpawnBlockLightLimit;
    private final IntProvider monsterSpawnLightLevel;

    public static Dimension createDefault(Platform platform, int dim, int minHeight, int maxHeight) {
        switch (dim) {
            case 0: {
                return Dimension.builder().infiniburn(platform == DefaultPlugin.JAVA_ANVIL_1_17 ? "minecraft:infiniburn_overworld" : "#minecraft:infiniburn_overworld").logicalHeight(maxHeight - minHeight).minY(minHeight).height(maxHeight - minHeight).effects(platform == DefaultPlugin.JAVA_ANVIL_1_17 ? "minecraft:overworld" : "#minecraft:overworld").build();
            }
            case 1: {
                return Dimension.builder().infiniburn(platform == DefaultPlugin.JAVA_ANVIL_1_17 ? "minecraft:infiniburn_nether" : "#minecraft:infiniburn_nether").logicalHeight(128).minY(0).height(256).ultrawarm(true).natural(false).coordinateScale(8.0f).piglinSafe(true).bedWorks(false).hasRaids(false).hasSkylight(false).hasCeiling(true).fixedTime(18000).ambientLight(0.1f).effects(platform == DefaultPlugin.JAVA_ANVIL_1_17 ? "minecraft:the_nether" : "#minecraft:the_nether").build();
            }
            case 2: {
                return Dimension.builder().infiniburn(platform == DefaultPlugin.JAVA_ANVIL_1_17 ? "minecraft:infiniburn_end" : "#minecraft:infiniburn_end").logicalHeight(256).minY(0).height(256).natural(false).bedWorks(false).hasSkylight(false).fixedTime(6000).effects(platform == DefaultPlugin.JAVA_ANVIL_1_17 ? "minecraft:the_end" : "#minecraft:the_end").build();
            }
        }
        throw new IllegalArgumentException("Unsupported dimension: " + dim);
    }

    private static int $default$logicalHeight() {
        return 384;
    }

    private static String $default$infiniburn() {
        return "#minecraft:infiniburn_overworld";
    }

    private static boolean $default$hasRaids() {
        return true;
    }

    private static int $default$minY() {
        return -64;
    }

    private static int $default$height() {
        return 384;
    }

    private static boolean $default$natural() {
        return true;
    }

    private static float $default$coordinateScale() {
        return 1.0f;
    }

    private static boolean $default$bedWorks() {
        return true;
    }

    private static boolean $default$hasSkylight() {
        return true;
    }

    private static String $default$effects() {
        return "#minecraft:overworld";
    }

    private static IntProvider $default$monsterSpawnLightLevel() {
        return IntProvider.builder().type("minecraft:uniform").value(ImmutableMap.of((Object)"min_inclusive", (Object)0, (Object)"max_inclusive", (Object)7)).build();
    }

    @ConstructorProperties(value={"logicalHeight", "infiniburn", "ambientLight", "respawnAnchorWorks", "hasRaids", "minY", "height", "natural", "coordinateScale", "piglinSafe", "bedWorks", "hasSkylight", "hasCeiling", "ultrawarm", "fixedTime", "effects", "monsterSpawnBlockLightLimit", "monsterSpawnLightLevel"})
    Dimension(int logicalHeight, String infiniburn, float ambientLight, boolean respawnAnchorWorks, boolean hasRaids, int minY, int height, boolean natural, float coordinateScale, boolean piglinSafe, boolean bedWorks, boolean hasSkylight, boolean hasCeiling, boolean ultrawarm, Integer fixedTime, String effects, int monsterSpawnBlockLightLimit, IntProvider monsterSpawnLightLevel) {
        this.logicalHeight = logicalHeight;
        this.infiniburn = infiniburn;
        this.ambientLight = ambientLight;
        this.respawnAnchorWorks = respawnAnchorWorks;
        this.hasRaids = hasRaids;
        this.minY = minY;
        this.height = height;
        this.natural = natural;
        this.coordinateScale = coordinateScale;
        this.piglinSafe = piglinSafe;
        this.bedWorks = bedWorks;
        this.hasSkylight = hasSkylight;
        this.hasCeiling = hasCeiling;
        this.ultrawarm = ultrawarm;
        this.fixedTime = fixedTime;
        this.effects = effects;
        this.monsterSpawnBlockLightLimit = monsterSpawnBlockLightLimit;
        this.monsterSpawnLightLevel = monsterSpawnLightLevel;
    }

    public static DimensionBuilder builder() {
        return new DimensionBuilder();
    }

    public int getLogicalHeight() {
        return this.logicalHeight;
    }

    public String getInfiniburn() {
        return this.infiniburn;
    }

    public float getAmbientLight() {
        return this.ambientLight;
    }

    public boolean isRespawnAnchorWorks() {
        return this.respawnAnchorWorks;
    }

    public boolean isHasRaids() {
        return this.hasRaids;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isNatural() {
        return this.natural;
    }

    public float getCoordinateScale() {
        return this.coordinateScale;
    }

    public boolean isPiglinSafe() {
        return this.piglinSafe;
    }

    public boolean isBedWorks() {
        return this.bedWorks;
    }

    public boolean isHasSkylight() {
        return this.hasSkylight;
    }

    public boolean isHasCeiling() {
        return this.hasCeiling;
    }

    public boolean isUltrawarm() {
        return this.ultrawarm;
    }

    public Integer getFixedTime() {
        return this.fixedTime;
    }

    public String getEffects() {
        return this.effects;
    }

    public int getMonsterSpawnBlockLightLimit() {
        return this.monsterSpawnBlockLightLimit;
    }

    public IntProvider getMonsterSpawnLightLevel() {
        return this.monsterSpawnLightLevel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dimension)) {
            return false;
        }
        Dimension other = (Dimension)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLogicalHeight() != other.getLogicalHeight()) {
            return false;
        }
        if (Float.compare(this.getAmbientLight(), other.getAmbientLight()) != 0) {
            return false;
        }
        if (this.isRespawnAnchorWorks() != other.isRespawnAnchorWorks()) {
            return false;
        }
        if (this.isHasRaids() != other.isHasRaids()) {
            return false;
        }
        if (this.getMinY() != other.getMinY()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        if (this.isNatural() != other.isNatural()) {
            return false;
        }
        if (Float.compare(this.getCoordinateScale(), other.getCoordinateScale()) != 0) {
            return false;
        }
        if (this.isPiglinSafe() != other.isPiglinSafe()) {
            return false;
        }
        if (this.isBedWorks() != other.isBedWorks()) {
            return false;
        }
        if (this.isHasSkylight() != other.isHasSkylight()) {
            return false;
        }
        if (this.isHasCeiling() != other.isHasCeiling()) {
            return false;
        }
        if (this.isUltrawarm() != other.isUltrawarm()) {
            return false;
        }
        if (this.getMonsterSpawnBlockLightLimit() != other.getMonsterSpawnBlockLightLimit()) {
            return false;
        }
        Integer this$fixedTime = this.getFixedTime();
        Integer other$fixedTime = other.getFixedTime();
        if (this$fixedTime == null ? other$fixedTime != null : !((Object)this$fixedTime).equals(other$fixedTime)) {
            return false;
        }
        String this$infiniburn = this.getInfiniburn();
        String other$infiniburn = other.getInfiniburn();
        if (this$infiniburn == null ? other$infiniburn != null : !this$infiniburn.equals(other$infiniburn)) {
            return false;
        }
        String this$effects = this.getEffects();
        String other$effects = other.getEffects();
        if (this$effects == null ? other$effects != null : !this$effects.equals(other$effects)) {
            return false;
        }
        IntProvider this$monsterSpawnLightLevel = this.getMonsterSpawnLightLevel();
        IntProvider other$monsterSpawnLightLevel = other.getMonsterSpawnLightLevel();
        return !(this$monsterSpawnLightLevel == null ? other$monsterSpawnLightLevel != null : !((Object)this$monsterSpawnLightLevel).equals(other$monsterSpawnLightLevel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Dimension;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLogicalHeight();
        result = result * 59 + Float.floatToIntBits(this.getAmbientLight());
        result = result * 59 + (this.isRespawnAnchorWorks() ? 79 : 97);
        result = result * 59 + (this.isHasRaids() ? 79 : 97);
        result = result * 59 + this.getMinY();
        result = result * 59 + this.getHeight();
        result = result * 59 + (this.isNatural() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getCoordinateScale());
        result = result * 59 + (this.isPiglinSafe() ? 79 : 97);
        result = result * 59 + (this.isBedWorks() ? 79 : 97);
        result = result * 59 + (this.isHasSkylight() ? 79 : 97);
        result = result * 59 + (this.isHasCeiling() ? 79 : 97);
        result = result * 59 + (this.isUltrawarm() ? 79 : 97);
        result = result * 59 + this.getMonsterSpawnBlockLightLimit();
        Integer $fixedTime = this.getFixedTime();
        result = result * 59 + ($fixedTime == null ? 43 : ((Object)$fixedTime).hashCode());
        String $infiniburn = this.getInfiniburn();
        result = result * 59 + ($infiniburn == null ? 43 : $infiniburn.hashCode());
        String $effects = this.getEffects();
        result = result * 59 + ($effects == null ? 43 : $effects.hashCode());
        IntProvider $monsterSpawnLightLevel = this.getMonsterSpawnLightLevel();
        result = result * 59 + ($monsterSpawnLightLevel == null ? 43 : ((Object)$monsterSpawnLightLevel).hashCode());
        return result;
    }

    public String toString() {
        return "Dimension(logicalHeight=" + this.getLogicalHeight() + ", infiniburn=" + this.getInfiniburn() + ", ambientLight=" + this.getAmbientLight() + ", respawnAnchorWorks=" + this.isRespawnAnchorWorks() + ", hasRaids=" + this.isHasRaids() + ", minY=" + this.getMinY() + ", height=" + this.getHeight() + ", natural=" + this.isNatural() + ", coordinateScale=" + this.getCoordinateScale() + ", piglinSafe=" + this.isPiglinSafe() + ", bedWorks=" + this.isBedWorks() + ", hasSkylight=" + this.isHasSkylight() + ", hasCeiling=" + this.isHasCeiling() + ", ultrawarm=" + this.isUltrawarm() + ", fixedTime=" + this.getFixedTime() + ", effects=" + this.getEffects() + ", monsterSpawnBlockLightLimit=" + this.getMonsterSpawnBlockLightLimit() + ", monsterSpawnLightLevel=" + this.getMonsterSpawnLightLevel() + ")";
    }

    public static class DimensionBuilder {
        private boolean logicalHeight$set;
        private int logicalHeight$value;
        private boolean infiniburn$set;
        private String infiniburn$value;
        private float ambientLight;
        private boolean respawnAnchorWorks;
        private boolean hasRaids$set;
        private boolean hasRaids$value;
        private boolean minY$set;
        private int minY$value;
        private boolean height$set;
        private int height$value;
        private boolean natural$set;
        private boolean natural$value;
        private boolean coordinateScale$set;
        private float coordinateScale$value;
        private boolean piglinSafe;
        private boolean bedWorks$set;
        private boolean bedWorks$value;
        private boolean hasSkylight$set;
        private boolean hasSkylight$value;
        private boolean hasCeiling;
        private boolean ultrawarm;
        private Integer fixedTime;
        private boolean effects$set;
        private String effects$value;
        private int monsterSpawnBlockLightLimit;
        private boolean monsterSpawnLightLevel$set;
        private IntProvider monsterSpawnLightLevel$value;

        DimensionBuilder() {
        }

        public DimensionBuilder logicalHeight(int logicalHeight) {
            this.logicalHeight$value = logicalHeight;
            this.logicalHeight$set = true;
            return this;
        }

        public DimensionBuilder infiniburn(String infiniburn) {
            this.infiniburn$value = infiniburn;
            this.infiniburn$set = true;
            return this;
        }

        public DimensionBuilder ambientLight(float ambientLight) {
            this.ambientLight = ambientLight;
            return this;
        }

        public DimensionBuilder respawnAnchorWorks(boolean respawnAnchorWorks) {
            this.respawnAnchorWorks = respawnAnchorWorks;
            return this;
        }

        public DimensionBuilder hasRaids(boolean hasRaids) {
            this.hasRaids$value = hasRaids;
            this.hasRaids$set = true;
            return this;
        }

        public DimensionBuilder minY(int minY) {
            this.minY$value = minY;
            this.minY$set = true;
            return this;
        }

        public DimensionBuilder height(int height) {
            this.height$value = height;
            this.height$set = true;
            return this;
        }

        public DimensionBuilder natural(boolean natural) {
            this.natural$value = natural;
            this.natural$set = true;
            return this;
        }

        public DimensionBuilder coordinateScale(float coordinateScale) {
            this.coordinateScale$value = coordinateScale;
            this.coordinateScale$set = true;
            return this;
        }

        public DimensionBuilder piglinSafe(boolean piglinSafe) {
            this.piglinSafe = piglinSafe;
            return this;
        }

        public DimensionBuilder bedWorks(boolean bedWorks) {
            this.bedWorks$value = bedWorks;
            this.bedWorks$set = true;
            return this;
        }

        public DimensionBuilder hasSkylight(boolean hasSkylight) {
            this.hasSkylight$value = hasSkylight;
            this.hasSkylight$set = true;
            return this;
        }

        public DimensionBuilder hasCeiling(boolean hasCeiling) {
            this.hasCeiling = hasCeiling;
            return this;
        }

        public DimensionBuilder ultrawarm(boolean ultrawarm) {
            this.ultrawarm = ultrawarm;
            return this;
        }

        public DimensionBuilder fixedTime(Integer fixedTime) {
            this.fixedTime = fixedTime;
            return this;
        }

        public DimensionBuilder effects(String effects) {
            this.effects$value = effects;
            this.effects$set = true;
            return this;
        }

        public DimensionBuilder monsterSpawnBlockLightLimit(int monsterSpawnBlockLightLimit) {
            this.monsterSpawnBlockLightLimit = monsterSpawnBlockLightLimit;
            return this;
        }

        public DimensionBuilder monsterSpawnLightLevel(IntProvider monsterSpawnLightLevel) {
            this.monsterSpawnLightLevel$value = monsterSpawnLightLevel;
            this.monsterSpawnLightLevel$set = true;
            return this;
        }

        public Dimension build() {
            int logicalHeight$value = this.logicalHeight$value;
            if (!this.logicalHeight$set) {
                logicalHeight$value = Dimension.$default$logicalHeight();
            }
            String infiniburn$value = this.infiniburn$value;
            if (!this.infiniburn$set) {
                infiniburn$value = Dimension.$default$infiniburn();
            }
            boolean hasRaids$value = this.hasRaids$value;
            if (!this.hasRaids$set) {
                hasRaids$value = Dimension.$default$hasRaids();
            }
            int minY$value = this.minY$value;
            if (!this.minY$set) {
                minY$value = Dimension.$default$minY();
            }
            int height$value = this.height$value;
            if (!this.height$set) {
                height$value = Dimension.$default$height();
            }
            boolean natural$value = this.natural$value;
            if (!this.natural$set) {
                natural$value = Dimension.$default$natural();
            }
            float coordinateScale$value = this.coordinateScale$value;
            if (!this.coordinateScale$set) {
                coordinateScale$value = Dimension.$default$coordinateScale();
            }
            boolean bedWorks$value = this.bedWorks$value;
            if (!this.bedWorks$set) {
                bedWorks$value = Dimension.$default$bedWorks();
            }
            boolean hasSkylight$value = this.hasSkylight$value;
            if (!this.hasSkylight$set) {
                hasSkylight$value = Dimension.$default$hasSkylight();
            }
            String effects$value = this.effects$value;
            if (!this.effects$set) {
                effects$value = Dimension.$default$effects();
            }
            IntProvider monsterSpawnLightLevel$value = this.monsterSpawnLightLevel$value;
            if (!this.monsterSpawnLightLevel$set) {
                monsterSpawnLightLevel$value = Dimension.$default$monsterSpawnLightLevel();
            }
            return new Dimension(logicalHeight$value, infiniburn$value, this.ambientLight, this.respawnAnchorWorks, hasRaids$value, minY$value, height$value, natural$value, coordinateScale$value, this.piglinSafe, bedWorks$value, hasSkylight$value, this.hasCeiling, this.ultrawarm, this.fixedTime, effects$value, this.monsterSpawnBlockLightLimit, monsterSpawnLightLevel$value);
        }

        public String toString() {
            return "Dimension.DimensionBuilder(logicalHeight$value=" + this.logicalHeight$value + ", infiniburn$value=" + this.infiniburn$value + ", ambientLight=" + this.ambientLight + ", respawnAnchorWorks=" + this.respawnAnchorWorks + ", hasRaids$value=" + this.hasRaids$value + ", minY$value=" + this.minY$value + ", height$value=" + this.height$value + ", natural$value=" + this.natural$value + ", coordinateScale$value=" + this.coordinateScale$value + ", piglinSafe=" + this.piglinSafe + ", bedWorks$value=" + this.bedWorks$value + ", hasSkylight$value=" + this.hasSkylight$value + ", hasCeiling=" + this.hasCeiling + ", ultrawarm=" + this.ultrawarm + ", fixedTime=" + this.fixedTime + ", effects$value=" + this.effects$value + ", monsterSpawnBlockLightLimit=" + this.monsterSpawnBlockLightLimit + ", monsterSpawnLightLevel$value=" + this.monsterSpawnLightLevel$value + ")";
        }
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static final class IntProvider {
        private final String type;
        private final Object value;

        @ConstructorProperties(value={"type", "value"})
        IntProvider(String type, Object value) {
            this.type = type;
            this.value = value;
        }

        public static IntProviderBuilder builder() {
            return new IntProviderBuilder();
        }

        public String getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IntProvider)) {
                return false;
            }
            IntProvider other = (IntProvider)o;
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "Dimension.IntProvider(type=" + this.getType() + ", value=" + this.getValue() + ")";
        }

        public static class IntProviderBuilder {
            private String type;
            private Object value;

            IntProviderBuilder() {
            }

            public IntProviderBuilder type(String type) {
                this.type = type;
                return this;
            }

            public IntProviderBuilder value(Object value) {
                this.value = value;
                return this;
            }

            public IntProvider build() {
                return new IntProvider(this.type, this.value);
            }

            public String toString() {
                return "Dimension.IntProvider.IntProviderBuilder(type=" + this.type + ", value=" + this.value + ")";
            }
        }
    }
}

