/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import org.pepsoft.minecraft.ChunkFactory;
import org.pepsoft.minecraft.MC12AnvilChunk;
import org.pepsoft.minecraft.MCRegionChunk;

public class SimpleChunkFactory
implements ChunkFactory {
    private final int maxHeight;
    private final int version;

    public SimpleChunkFactory(int maxHeight, int version) {
        this.maxHeight = maxHeight;
        this.version = version;
    }

    @Override
    public int getMinHeight() {
        return 0;
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public ChunkFactory.ChunkCreationResult createChunk(int chunkX, int chunkZ) {
        ChunkFactory.ChunkCreationResult result = new ChunkFactory.ChunkCreationResult();
        result.chunk = this.version == 19132 ? new MCRegionChunk(chunkX, chunkZ, this.maxHeight) : new MC12AnvilChunk(chunkX, chunkZ, this.maxHeight);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < this.maxHeight; ++y) {
                    if (y == 0) {
                        result.chunk.setBlockType(x, y, z, 7);
                        continue;
                    }
                    if (y <= 3) {
                        result.chunk.setBlockType(x, y, z, 1);
                        continue;
                    }
                    if (y <= 5) {
                        result.chunk.setBlockType(x, y, z, 3);
                        continue;
                    }
                    if (y == 6) {
                        result.chunk.setBlockType(x, y, z, 2);
                        continue;
                    }
                    result.chunk.setSkyLightLevel(x, y, z, 15);
                }
                result.chunk.setHeight(x, z, 7);
            }
        }
        result.chunk.setTerrainPopulated(true);
        result.stats.surfaceArea = 256L;
        result.stats.landArea = 256L;
        return result;
    }
}

