/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.pepsoft.minecraft.RegionFile;

public final class RegionFileCache {
    private static final int MAX_CACHE_SIZE = 256;
    private static final Map<File, Reference<RegionFile>> cache = new HashMap<File, Reference<RegionFile>>();
    private static final Map<File, Reference<RegionFile>> readOnlyCache = new HashMap<File, Reference<RegionFile>>();

    private RegionFileCache() {
    }

    public static synchronized RegionFile getRegionFileIfExists(File basePath, int chunkX, int chunkZ, int version) throws IOException {
        return RegionFileCache.getRegionFileIfExists(basePath, chunkX, chunkZ, version, false);
    }

    public static synchronized RegionFile getRegionFileIfExists(File basePath, int chunkX, int chunkZ, int version, boolean readOnly) throws IOException {
        RegionFile regionFile;
        if (version != 19132 && version != 19133) {
            throw new IllegalArgumentException("Not a supported version: 0x" + Integer.toHexString(version));
        }
        File regionDir = new File(basePath, "region");
        if (!regionDir.exists()) {
            return null;
        }
        File file = new File(regionDir, "r." + (chunkX >> 5) + "." + (chunkZ >> 5) + (version == 19132 ? ".mcr" : ".mca"));
        Reference<RegionFile> ref = readOnly ? readOnlyCache.get(file) : cache.get(file);
        RegionFile regionFile2 = regionFile = ref != null ? ref.get() : null;
        if (regionFile != null) {
            return regionFile;
        }
        if (!file.isFile()) {
            return null;
        }
        if ((readOnly ? readOnlyCache.size() : cache.size()) >= 256) {
            RegionFileCache.clear();
        }
        regionFile = new RegionFile(file, readOnly);
        (readOnly ? readOnlyCache : cache).put(file, new SoftReference<RegionFile>(regionFile));
        return regionFile;
    }

    public static synchronized RegionFile getRegionFile(File basePath, int chunkX, int chunkZ, int version) throws IOException {
        RegionFile regionFile;
        if (version != 19132 && version != 19133) {
            throw new IllegalArgumentException("Not a supported version: 0x" + Integer.toHexString(version));
        }
        File regionDir = new File(basePath, "region");
        File file = new File(regionDir, "r." + (chunkX >> 5) + "." + (chunkZ >> 5) + (version == 19132 ? ".mcr" : ".mca"));
        Reference<RegionFile> ref = cache.get(file);
        RegionFile regionFile2 = regionFile = ref != null ? ref.get() : null;
        if (regionFile != null) {
            return regionFile;
        }
        if (!regionDir.exists()) {
            regionDir.mkdirs();
        }
        if (cache.size() >= 256) {
            RegionFileCache.clear();
        }
        regionFile = new RegionFile(file);
        cache.put(file, new SoftReference<RegionFile>(regionFile));
        return regionFile;
    }

    public static synchronized void clear() throws IOException {
        for (Reference<RegionFile> ref : cache.values()) {
            if (ref.get() == null) continue;
            ref.get().close();
        }
        cache.clear();
    }

    public static int getSizeDelta(File basePath, int chunkX, int chunkZ, int version) throws IOException {
        RegionFile r = RegionFileCache.getRegionFile(basePath, chunkX, chunkZ, version);
        return r.getSizeDelta();
    }

    public static DataInputStream getChunkDataInputStream(File basePath, int chunkX, int chunkZ, int version) throws IOException {
        RegionFile r = RegionFileCache.getRegionFile(basePath, chunkX, chunkZ, version);
        return r.getChunkDataInputStream(chunkX & 0x1F, chunkZ & 0x1F);
    }

    public static DataOutputStream getChunkDataOutputStream(File basePath, int chunkX, int chunkZ, int version) throws IOException {
        RegionFile r = RegionFileCache.getRegionFile(basePath, chunkX, chunkZ, version);
        return r.getChunkDataOutputStream(chunkX & 0x1F, chunkZ & 0x1F);
    }
}

