/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class Property<V> {
    public final String name;
    public final Class<V> type;
    private final Method valueOfMethod;

    public Property(String name, Class<V> type) {
        this.name = name;
        this.type = type;
        Method method = null;
        if (type != String.class) {
            try {
                method = type.getMethod("parse", String.class);
            }
            catch (NoSuchMethodException e) {
                try {
                    method = type.getMethod("valueOf", String.class);
                }
                catch (NoSuchMethodException e2) {
                    throw new IllegalArgumentException("Type " + type + " has no parse(String) or valueOf(String) methods");
                }
            }
        }
        this.valueOfMethod = method;
    }

    public V fromString(String str) {
        if (this.valueOfMethod == null) {
            return (V)str;
        }
        try {
            return (V)this.valueOfMethod.invoke(null, str);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e.getClass().getSimpleName() + " when trying to parse\"" + str + "\" to " + this.type, e);
        }
    }
}

