/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import java.util.HashMap;
import java.util.Map;
import org.jnbt.ByteTag;
import org.jnbt.CompoundTag;
import org.jnbt.LongTag;
import org.jnbt.StringTag;
import org.jnbt.Tag;
import org.pepsoft.minecraft.CustomGenerator;
import org.pepsoft.minecraft.JavaLevel;
import org.pepsoft.minecraft.MapGenerator;
import org.pepsoft.minecraft.SeededGenerator;
import org.pepsoft.minecraft.SuperflatGenerator;
import org.pepsoft.minecraft.SuperflatPreset;
import org.pepsoft.worldpainter.Generator;
import org.pepsoft.worldpainter.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Java116Level
extends JavaLevel {
    private final Map<Integer, MapGenerator> generators = new HashMap<Integer, MapGenerator>();
    private long seed;
    private boolean mapFeatures;
    private static final Logger logger = LoggerFactory.getLogger(Java116Level.class);

    Java116Level(int minHeight, int maxHeight, Platform platform) {
        super(minHeight, maxHeight, platform);
    }

    Java116Level(CompoundTag tag, int minHeight, int maxHeight) {
        super(tag, minHeight, maxHeight);
        this.loadWorldGenSettings();
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public void setSeed(long seed) {
        this.seed = seed;
    }

    @Override
    public boolean isMapFeatures() {
        return this.mapFeatures;
    }

    @Override
    public MapGenerator getGenerator(int dim) {
        return this.generators.get(dim);
    }

    @Override
    public void setMapFeatures(boolean mapFeatures) {
        this.mapFeatures = mapFeatures;
    }

    @Override
    public void setGenerator(int dim, MapGenerator generator) {
        this.generators.put(dim, generator);
    }

    @Override
    public CompoundTag toNBT() {
        this.setMap("WorldGenSettings", this.getOrCreateWorldGenSettings());
        return super.toNBT();
    }

    private void loadWorldGenSettings() {
        Map<String, Tag> worldGenSettings = this.getMap("WorldGenSettings");
        if (worldGenSettings == null) {
            return;
        }
        this.mapFeatures = ((ByteTag)worldGenSettings.get("generate_features")).getValue() == 1;
        this.seed = ((LongTag)worldGenSettings.get("seed")).getValue();
        CompoundTag dimensionsTag = (CompoundTag)worldGenSettings.get("dimensions");
        if (dimensionsTag == null) {
            return;
        }
        block10: for (Tag tag : dimensionsTag.getValue().values()) {
            Tag biomeSourceTag;
            String noiseSettings;
            Long generatorSeed;
            CompoundTag dimensionTag = (CompoundTag)tag;
            String type = ((StringTag)dimensionTag.getTag("type")).getValue();
            CompoundTag generatorTag = (CompoundTag)dimensionTag.getTag("generator");
            String generatorType = ((StringTag)generatorTag.getTag("type")).getValue();
            Tag generatorSettings = generatorTag.getTag("settings");
            Long l = generatorSeed = generatorTag.containsTag("seed") ? Long.valueOf(((LongTag)generatorTag.getTag("seed")).getValue()) : null;
            MapGenerator generator = generatorType.equals("minecraft:noise") && generatorSettings instanceof StringTag ? ((noiseSettings = ((StringTag)generatorSettings).getValue()).equals("minecraft:overworld") ? ((biomeSourceTag = generatorTag.getTag("biome_source")) instanceof CompoundTag && ((CompoundTag)biomeSourceTag).containsTag("large_biomes") && ((CompoundTag)biomeSourceTag).getTag("large_biomes") instanceof ByteTag && ((ByteTag)((CompoundTag)biomeSourceTag).getTag("large_biomes")).getValue() == 1 ? new SeededGenerator(Generator.LARGE_BIOMES, generatorSeed) : new SeededGenerator(Generator.DEFAULT, generatorSeed)) : (noiseSettings.equals("minecraft:nether") ? new SeededGenerator(Generator.NETHER, generatorSeed) : (noiseSettings.equals("minecraft:end") ? new SeededGenerator(Generator.END, generatorSeed) : (noiseSettings.equals("minecraft:amplified") ? new SeededGenerator(Generator.AMPLIFIED, generatorSeed) : new CustomGenerator(generatorType, (Tag)generatorTag))))) : (generatorType.equals("minecraft:flat") ? new SuperflatGenerator(SuperflatPreset.fromMinecraft1_18_0((CompoundTag)generatorSettings)) : new CustomGenerator(generatorType, (Tag)generatorTag));
            switch (type) {
                case "minecraft:overworld": {
                    this.generators.put(0, generator);
                    continue block10;
                }
                case "minecraft:the_nether": {
                    this.generators.put(1, generator);
                    continue block10;
                }
                case "minecraft:the_end": {
                    this.generators.put(2, generator);
                    continue block10;
                }
            }
            logger.warn("Ignoring dimension of unknown type {}", (Object)type);
        }
    }

    private Map<String, Tag> getOrCreateWorldGenSettings() {
        CompoundTag dimensionsTag;
        Map<String, Tag> worldGenSettings = this.getMap("WorldGenSettings");
        if (worldGenSettings == null) {
            worldGenSettings = new HashMap<String, Tag>();
            worldGenSettings.put("generate_features", (Tag)new ByteTag("generate_features", this.mapFeatures ? (byte)1 : 0));
        }
        worldGenSettings.put("seed", (Tag)new LongTag("seed", this.seed));
        if (worldGenSettings.containsKey("dimensions")) {
            dimensionsTag = (CompoundTag)worldGenSettings.get("dimensions");
        } else {
            dimensionsTag = new CompoundTag("dimensions", new HashMap());
            worldGenSettings.put("dimensions", (Tag)dimensionsTag);
        }
        for (int dim : this.platform.supportedDimensions) {
            String biomeSourcePreset;
            String biomeSourceType;
            StringTag settingsTag;
            String generatorType;
            MapGenerator generator;
            String dimensionName;
            switch (dim) {
                case 0: {
                    dimensionName = "minecraft:overworld";
                    generator = this.generators.getOrDefault(0, new SeededGenerator(Generator.LARGE_BIOMES, this.seed));
                    break;
                }
                case 1: {
                    dimensionName = "minecraft:the_nether";
                    generator = this.generators.getOrDefault(1, new SeededGenerator(Generator.NETHER, this.seed));
                    break;
                }
                case 2: {
                    dimensionName = "minecraft:the_end";
                    generator = this.generators.getOrDefault(2, new SeededGenerator(Generator.END, this.seed));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Dimension " + dim + " not supported");
                }
            }
            CompoundTag dimensionTag = (CompoundTag)dimensionsTag.getTag(dimensionName);
            if (dimensionTag == null) {
                dimensionTag = new CompoundTag(dimensionName, new HashMap());
                dimensionTag.getValue().put("type", new StringTag("type", dimensionName));
                dimensionsTag.getValue().put(dimensionName, dimensionTag);
            }
            if (generator.getType() == Generator.CUSTOM && ((CustomGenerator)generator).getSettings() instanceof CompoundTag) {
                dimensionTag.getValue().put("generator", ((CustomGenerator)generator).getSettings());
                continue;
            }
            Boolean biomeSourceLargeBiomes = null;
            switch (generator.getType()) {
                case DEFAULT: {
                    generatorType = "minecraft:noise";
                    settingsTag = new StringTag("settings", "minecraft:overworld");
                    biomeSourceType = "minecraft:vanilla_layered";
                    biomeSourcePreset = null;
                    biomeSourceLargeBiomes = Boolean.FALSE;
                    break;
                }
                case LARGE_BIOMES: {
                    generatorType = "minecraft:noise";
                    settingsTag = new StringTag("settings", "minecraft:overworld");
                    biomeSourceType = "minecraft:vanilla_layered";
                    biomeSourcePreset = null;
                    biomeSourceLargeBiomes = Boolean.TRUE;
                    break;
                }
                case AMPLIFIED: {
                    generatorType = "minecraft:noise";
                    settingsTag = new StringTag("settings", "minecraft:amplified");
                    biomeSourceType = "minecraft:vanilla_layered";
                    biomeSourcePreset = null;
                    biomeSourceLargeBiomes = Boolean.FALSE;
                    break;
                }
                case FLAT: {
                    generatorType = "minecraft:flat";
                    SuperflatPreset settings = ((SuperflatGenerator)generator).getSettings();
                    settingsTag = (settings != null ? settings : SuperflatPreset.defaultPreset(this.platform)).toMinecraft1_18_0();
                    biomeSourcePreset = null;
                    biomeSourceType = null;
                    break;
                }
                case NETHER: {
                    generatorType = "minecraft:noise";
                    settingsTag = new StringTag("settings", "minecraft:nether");
                    biomeSourceType = "minecraft:multi_noise";
                    biomeSourcePreset = "minecraft:nether";
                    break;
                }
                case END: {
                    generatorType = "minecraft:noise";
                    settingsTag = new StringTag("settings", "minecraft:end");
                    biomeSourceType = "minecraft:the_end";
                    biomeSourcePreset = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Generator " + generator + " not supported for Minecraft 1.16 - 1.17");
                }
            }
            long seed = generator instanceof SeededGenerator ? ((SeededGenerator)generator).getSeed() : 0L;
            CompoundTag generatorTag = (CompoundTag)dimensionTag.getTag("generator");
            if (generatorTag == null) {
                generatorTag = new CompoundTag("generator", new HashMap());
                dimensionTag.getValue().put("generator", generatorTag);
            }
            if (biomeSourceType != null) {
                generatorTag.setTag("seed", (Tag)new LongTag("seed", seed));
            }
            generatorTag.setTag("type", (Tag)new StringTag("type", generatorType));
            if (settingsTag != null) {
                generatorTag.setTag("settings", (Tag)settingsTag);
            }
            if (biomeSourceType == null) continue;
            CompoundTag biomeSourceTag = (CompoundTag)generatorTag.getTag("biome_source");
            if (biomeSourceTag == null) {
                biomeSourceTag = new CompoundTag("biome_source", new HashMap());
                generatorTag.getValue().put("biome_source", biomeSourceTag);
            }
            biomeSourceTag.setTag("type", (Tag)new StringTag("type", biomeSourceType));
            switch (biomeSourceType) {
                case "minecraft:multi_noise": 
                case "minecraft:vanilla_layered": 
                case "minecraft:the_end": {
                    biomeSourceTag.setTag("seed", (Tag)new LongTag("seed", seed));
                }
            }
            if (biomeSourcePreset != null) {
                biomeSourceTag.setTag("preset", (Tag)new StringTag("preset", biomeSourcePreset));
            }
            if (biomeSourceLargeBiomes == null) continue;
            biomeSourceTag.setTag("large_biomes", (Tag)new ByteTag("large_biomes", (byte)(biomeSourceLargeBiomes != false ? 1 : 0)));
        }
        return worldGenSettings;
    }
}

