/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import java.util.HashMap;
import java.util.UUID;
import org.jnbt.CompoundTag;
import org.jnbt.StringTag;
import org.pepsoft.minecraft.AbstractNBTItem;
import org.pepsoft.minecraft.Painting;
import org.pepsoft.minecraft.Player;
import org.pepsoft.minecraft.Villager;
import org.pepsoft.util.ArrayUtils;
import org.pepsoft.util.MathUtils;

public class Entity
extends AbstractNBTItem {
    private double[] relPos;
    private static final int[] FACING_VALUES = new int[]{3, 4, 2, 5};
    private static final long serialVersionUID = 1L;

    public Entity(String id) {
        super(new CompoundTag("", new HashMap()));
        if (id == null) {
            throw new NullPointerException();
        }
        this.setString("id", id);
        this.setShort("Fire", (short)-20);
        this.setShort("Air", (short)300);
        this.setBoolean("OnGround", true);
        this.setPos(new double[]{0.0, 0.0, 0.0});
        this.setRot(new float[]{0.0f, 0.0f});
        this.setVel(new double[]{0.0, 0.0, 0.0});
    }

    protected Entity(CompoundTag tag, double[] relPos) {
        super(tag);
        if (relPos != null && relPos.length != 3) {
            throw new IllegalArgumentException("relPos.length != 3");
        }
        this.relPos = relPos;
    }

    public final String getId() {
        return this.getString("id");
    }

    public final double[] getRelPos() {
        double[] dArray;
        if (this.relPos != null) {
            dArray = this.relPos;
        } else {
            double[] dArray2 = new double[3];
            dArray2[0] = 0.0;
            dArray2[1] = 0.0;
            dArray = dArray2;
            dArray2[2] = 0.0;
        }
        return dArray;
    }

    public final void setRelPos(double[] relPos) {
        if (relPos.length != 3) {
            throw new IllegalArgumentException();
        }
        this.relPos = relPos;
    }

    public final double[] getPos() {
        double[] list = this.getDoubleList("Pos");
        return list != null ? list : new double[3];
    }

    public final void setPos(double[] pos) {
        if (pos.length != 3) {
            throw new IllegalArgumentException();
        }
        this.setDoubleList("Pos", pos);
        if (this.containsTag("TileX")) {
            this.setInt("TileX", (int)Math.floor(pos[0]));
            this.setInt("TileY", (int)Math.floor(pos[1]));
            this.setInt("TileZ", (int)Math.floor(pos[2]));
        }
    }

    public final float[] getRot() {
        float[] list = this.getFloatList("Rotation");
        return list != null ? list : new float[2];
    }

    public final void setRot(float[] rot) {
        if (rot.length != 2) {
            throw new IllegalArgumentException();
        }
        this.setFloatList("Rotation", rot);
    }

    public final double[] getVel() {
        double[] list = this.getDoubleList("Motion");
        return list != null ? list : new double[3];
    }

    public final void setVel(double[] vel) {
        if (vel.length != 3) {
            throw new IllegalArgumentException();
        }
        this.setDoubleList("Motion", vel);
    }

    public final UUID getUUID() {
        String uuidStr = this.getString("UUID");
        if (uuidStr != null) {
            return UUID.fromString(uuidStr);
        }
        return new UUID(this.getLong("UUIDMost"), this.getLong("UUIDLeast"));
    }

    public final void setUUID(UUID uuid) {
        this.setLong("UUIDMost", uuid.getMostSignificantBits());
        this.setLong("UUIDLeast", uuid.getLeastSignificantBits());
        this.setString("UUID", null);
    }

    public Entity rotate(int steps) {
        Entity rotEntity = this.clone();
        if (steps != 0) {
            int facing;
            float[] rot = rotEntity.getRot();
            rot[0] = MathUtils.mod((float)(rot[0] + (float)steps * 90.0f), (float)360.0f);
            rotEntity.setRot(rot);
            if (this.containsTag("facing") && (facing = this.getByte("facing")) >= 0 && facing <= 3) {
                facing = facing + steps & 3;
                rotEntity.setByte("facing", (byte)facing);
            }
            if (this.containsTag("Facing") && (facing = this.getByte("Facing")) >= 2 && facing <= 5) {
                facing = FACING_VALUES[ArrayUtils.indexOf((int[])FACING_VALUES, (int)facing) + steps & 3];
                rotEntity.setByte("Facing", (byte)facing);
            }
        }
        return rotEntity;
    }

    public Entity mirror(boolean mirrorYAxis) {
        int facing;
        Entity mirEntity = this.clone();
        double[] vel = mirEntity.getVel();
        if (mirrorYAxis) {
            vel[2] = -vel[2];
        } else {
            vel[0] = -vel[0];
        }
        mirEntity.setVel(vel);
        float[] rot = mirEntity.getRot();
        rot[0] = mirrorYAxis ? MathUtils.mod((float)(180.0f - rot[0]), (float)360.0f) : MathUtils.mod((float)(-rot[0]), (float)360.0f);
        mirEntity.setRot(rot);
        if (this.containsTag("facing")) {
            facing = this.getByte("facing");
            if (mirrorYAxis) {
                switch (facing) {
                    case 0: {
                        facing = 2;
                        break;
                    }
                    case 2: {
                        facing = 0;
                    }
                }
            } else {
                switch (facing) {
                    case 1: {
                        facing = 3;
                        break;
                    }
                    case 3: {
                        facing = 1;
                    }
                }
            }
            mirEntity.setByte("facing", (byte)facing);
        }
        if (this.containsTag("Facing")) {
            facing = this.getByte("Facing");
            if (mirrorYAxis) {
                switch (facing) {
                    case 2: {
                        facing = 3;
                        break;
                    }
                    case 3: {
                        facing = 2;
                    }
                }
            } else {
                switch (facing) {
                    case 4: {
                        facing = 5;
                        break;
                    }
                    case 5: {
                        facing = 4;
                    }
                }
            }
            mirEntity.setByte("Facing", (byte)facing);
        }
        return mirEntity;
    }

    @Override
    public Entity clone() {
        Entity clone = (Entity)super.clone();
        if (this.relPos != null) {
            clone.relPos = (double[])this.relPos.clone();
        }
        return clone;
    }

    public static Entity fromNBT(CompoundTag entityTag) {
        return Entity.fromNBT(entityTag, null);
    }

    public static Entity fromNBT(CompoundTag entityTag, double[] relPos) {
        String id;
        switch (id = ((StringTag)entityTag.getTag("id")).getValue()) {
            case "Player": {
                return new Player(entityTag, relPos);
            }
            case "Villager": {
                return new Villager(entityTag, relPos);
            }
            case "Painting": {
                return new Painting(entityTag, relPos);
            }
        }
        return new Entity(entityTag, relPos);
    }
}

